/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.table;

/**
 * TableFilter_INDEX_ORACLE は、TableUpda インターフェースを継承した、DBTableModel 処理用の
 * 実装クラスです。とくに、ORACLE用のインデックス作成スクリプトを作成します。
 *
 * ※ 他のデータベースと同じ形で扱いたいため、用意したクラスですが、内容は、TableFilter_INDEX と同じです。
 *
 * ここでは、テーブル一覧の検索結果より、GF07 のインデックスカラム定義テーブルから
 * 必要な情報を取得し、テーブル作成スクリプトを作成します。
 * 出力ファイルは、テーブル名＋"I.sql" という命名規則で作成します。
 * 検索では、(SYSTEM_ID,TBLSYU,TABLE_NAME,TABLE_LABEL,INDEX_NAME,NAME_JA,INDTYPE,TABLESPACE_NAME,INITIAL_EXTENT)
 * の項目を取得する必要があります。
 *
 * @og.rev 6.5.0.0 (2016/09/30) 新規作成
 *
 * @version  6.5.0.0  2016/09/13
 * @author   Kazuhiko Hasegawa
 * @since    JDK1.8,
 */
public class TableFilter_INDEX_ORACLE extends TableFilter_INDEX {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.5.0.0 (2016/09/30)" ;
}
