/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.system;								// 6.4.2.0 (2016/01/29) package変更 fukurou.util → fukurou.system

import java.nio.charset.Charset;		// 5.5.2.6 (2012/05/25)

/**
 * 共通的に使用される固定値を集約したクラスです。
 *
 * 全変数は、public static final 宣言されています。
 *
 * @og.rev 6.1.0.0 (2014/12/26) 固定値を集約したクラス対応
 * @og.rev 6.4.2.0 (2016/01/29) package変更 fukurou.util → fukurou.system
 *
 * @og.group その他
 *
 * @version  6.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK8.0,
 */
public final class HybsConst {

	/** バッファの初期容量を設定する固定値(通常より若干多い目)。  {@value}  */
	public static final int BUFFER_SMALL  = 100;

	/** バッファの初期容量を設定する固定値(通常より多い目)。  {@value}  */
	public static final int BUFFER_MIDDLE = 200;

	/** バッファの初期容量を設定する固定値(通常より大幅に多い目)。  {@value} */
	public static final int BUFFER_LARGE  = 500;

	/** システム依存の改行記号(String)。	*/
	public static final String CR = System.getProperty("line.separator");

	/** HTMLでの改行記号( &lt;br /&gt; )。	*/
	public static final String BR = "<br />" + CR ;

	/** システム依存のファイルセパレーター文字(char)。	*/
	public static final char FS = System.getProperty("file.separator").charAt(0);

	/** タブ文字(char)。	*/
	public static final char TAB = '\t';

	/**
	 * プラットフォーム依存のデフォルトの Charset です。
	 * プラットフォーム依存性を考慮する場合、エンコード指定で作成しておく事をお勧めします。
	 *
	 * @og.rev 5.5.2.6 (2012/05/25) findbugs対応
	 * @og.rev 6.4.2.0 (2016/01/29) fukurou.util.StringUtil → fukurou.system.HybsConst に変更
	 */
	public static final Charset DEFAULT_CHARSET = Charset.defaultCharset() ;

	/**
	 * ファイル等を読み取る場合のデフォルトエンコードを指定します。
	 * 通常は、UTF-8 にしておきます。
	 *
	 * @og.rev 6.4.5.1 (2016/04/28) ファイル等を読み取る場合のデフォルトエンコードを指定します。
	 */
	public static final String UTF_8 = "UTF-8" ;

	/**
	 * デフォルトコンストラクターをprivateにして、
	 * オブジェクトの生成をさせないようにする。
	 */
	private HybsConst() {}
}
