<?xml version="1.0" encoding="UTF-8"?>
<jsp:root xmlns:jsp="http://java.sun.com/JSP/Page" xmlns:og="hybs-taglib.tld" version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8"/>

<og:head headType="result"/>
<jsp:directive.include file="/jsp/custom/result_info.jsp"/>

<og:comment
	system  = ""
	pgid    = "GF9999"
	title   = "テスト2"
	date    = "2013/09/02"
	author  = "Hiroki.Nakamura"
	text    = "Hiroki.Nakamura"
	version = "001"
/>

<!--   ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。   -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}"/>
<!--   入力チェック   -->
<og:columnCheck command="{@command}" nullCheck="TABLE_NAME"/>

<og:equals val1="{@ACTION}" val2="{@ACTION}">
	<og:columnCheck command="{@command}" nullCheck="masterKeys"/>
</og:equals>

<og:equals val1="{@ACTION}" val2="DIFFERENCE">
	<og:columnCheck command="{@command}" nullCheck="diffKeys"/>
</og:equals>

<og:value command="SET" key="C_KEYS" value="{@CLMS}" action="APPEND"/>

<!--   取り消しボタンが押された時に必要です。   -->
<og:entry command="{@command}"/>

<!--   DB検索 SQL文記述 debug="true" でSQL文を確認できます。  -->

<og:query command="{@command}" debug="{@debug}" dbid="{@FROM_DBID}" maxRowCount="{@maxRowCount}">
		select
			 A1.SYSTEM_ID                  												<!-- GF02.ｼｽﾃﾑID -->
			,A1.TBLSYU                     												<!-- GF02.ﾃｰﾌﾞﾙ種別 -->
			,A1.TABLE_NAME                 												<!-- GF02.ﾃｰﾌﾞﾙ名 -->
			,A1.NAME_JA                    												<!-- GF02.名称 -->
			,A1.TABLESPACE_NAME            												<!-- GF02.ﾃｰﾌﾞﾙｽﾍﾟｰｽ名 -->
			,A2.SYSTEM_ID                  												<!-- GF01.ｼｽﾃﾑID -->
			,A2.TBLSYU                     												<!-- GF01.ﾃｰﾌﾞﾙ種別 -->
			,A2.TABLESPACE_NAME            												<!-- GF01.ﾃｰﾌﾞﾙｽﾍﾟｰｽ名 -->
		from  GF02 A1 left outer join GF01 A2
			on	A1.SYSTEM_ID		=	A2.SYSTEM_ID
			and	A1.TBLSYU		=	A2.TBLSYU
			and	A1.TABLESPACE_NAME		=	A2.TABLESPACE_NAME
	<og:where>
		<og:and value="A1.SYSTEM_ID		=	 '{@SYSTEM_ID}'"/>
		<og:and value="A1.TBLSYU		=	 '{@TBLSYU}'"/>
		<og:and value="A1.TABLE_NAME	like '{@TABLE_NAME}%'"/>
		<og:and value="A1.NAME_JA		=	 '{@NAME_JA}'"/>
		<og:and value="A1.TABLESPACE_NAME	=	 '{@TABLESPACE_NAME}'"/>
	</og:where>
	<og:appear startKey="ORDER BY" value="{@ORDER_BY}" defaultVal="1,2,3"/>
</og:query>

<!--   ACTION が指定された場合は、tableMerge により積集合/差分集合を取得します。  -->
<og:equals val1="{@ACTION}" val2="{@ACTION}">
	<og:value command="SET" key="m_keys" value="{@masterKeys}" action="APPEND"/>
	<og:value command="SET" key="d_keys" value="{@diffKeys}" action="APPEND"/>

	
<og:query command="{@command}" debug="{@debug}" dbid="{@FROM_DBID}" maxRowCount="{@maxRowCount}">
		select
			 A1.SYSTEM_ID                  												<!-- GF02.ｼｽﾃﾑID -->
			,A1.TBLSYU                     												<!-- GF02.ﾃｰﾌﾞﾙ種別 -->
			,A1.TABLE_NAME                 												<!-- GF02.ﾃｰﾌﾞﾙ名 -->
			,A1.NAME_JA                    												<!-- GF02.名称 -->
			,A1.TABLESPACE_NAME            												<!-- GF02.ﾃｰﾌﾞﾙｽﾍﾟｰｽ名 -->
			,A2.SYSTEM_ID                  												<!-- GF01.ｼｽﾃﾑID -->
			,A2.TBLSYU                     												<!-- GF01.ﾃｰﾌﾞﾙ種別 -->
			,A2.TABLESPACE_NAME            												<!-- GF01.ﾃｰﾌﾞﾙｽﾍﾟｰｽ名 -->
		from  GF02 A1 left outer join GF01 A2
			on	A1.SYSTEM_ID		=	A2.SYSTEM_ID
			and	A1.TBLSYU		=	A2.TBLSYU
			and	A1.TABLESPACE_NAME		=	A2.TABLESPACE_NAME
	<og:where>
		<og:and value="A1.SYSTEM_ID		=	 '{@SYSTEM_ID}'"/>
		<og:and value="A1.TBLSYU		=	 '{@TBLSYU}'"/>
		<og:and value="A1.TABLE_NAME	like '{@TABLE_NAME}%'"/>
		<og:and value="A1.NAME_JA		=	 '{@NAME_JA}'"/>
		<og:and value="A1.TABLESPACE_NAME	=	 '{@TABLESPACE_NAME}'"/>
	</og:where>
	<og:appear startKey="ORDER BY" value="{@ORDER_BY}" defaultVal="1,2,3"/>
</og:query>
	<og:tableMerge action="{@ACTION}" masterScope="request" masterKeys="{@m_keys}" diffKeys="{@d_keys}"
	slaveScope="session" modifyClms="ROWID" display="true"/>
</og:equals>

<!--   formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。   -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!--   複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。   -->
<!--   このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。  -->
<og:writeCheck>
	<og:submit value="update" lbl="COPY" command="COPY" accesskey="C"/>
	<og:submit value="update" lbl="MODIFY" command="MODIFY" accesskey="M"/>
	<og:submit value="update" lbl="DELETE" command="DELETE" accesskey="Z"/>
	<br/>
</og:writeCheck>

<!--   DB検索結果を表示させます。   -->
<!--   checked="true" で、チェック済みの状態で表示できます。   -->
<!--   selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。  -->

<og:view
	viewFormType = "HTMLTable"
	command      = "{@command}"
	checked      = "{@checked}"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}"
	noDisplay    = "ROWID"
/>

</form>
<jsp:directive.include file="/jsp/common/htmlend.jsp"/>
</jsp:root>
