<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<!-- POPUPでは、自分自身にsubmiするため、headType="popup" の記述が必要です。 -->
<og:head headType="popup" />

<jsp:directive.include file="/jsp/custom/popup_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2005"
	title	= "テーブルカラム定義マスタ"
	date	= "2014/05/16"
	author	= "Takahashi Masakazu"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "CLM"
/>

<form method="GET" action="popup.jsp" >

	<!-- 変更はここから -->
	<table summary="layout" >
	<tr>
		<og:column name="SYSTEM_ID" defaultVal="{@LAST.SYSTEM_ID}" />
		<og:column name="CLM"		aimai="V*" />
		<og:column name="NAME_JA"	aimai="V*" />
	</tr>
	</table>

	<!-- POPUPでは、scope="request" で検索するので、PrevNextは表示しません。 -->
	<og:queryButton usePrevNext="false" useEditMenu="false" />
</form>

<hr />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->

<!-- POPUPでは、scope="request" で検索します。 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" scope="request">
		select	A.SYSTEM_ID,A.CLM,A.NAME_JA,A.CLS_NAME,
				A.VIEW_LENGTH,A.USE_LENGTH,A.DATA_DEFAULT,
				A.RENDERER,A.EDITOR,A.DBTYPE,A.BIKO
		from GF03 A
	<og:where>
		<og:and value = "A.FGJ         in  ('0','1')"			/>
		<og:and value = "A.SYSTEM_ID   =    '{@SYSTEM_ID}'"	/>
		<og:and value = "A.CLM         like '{@CLM}'"			/>
		<og:and value = "A.NAME_JA     like '{@NAME_JA}'"		/>
		<og:and value = "A.KBCLM       =    '{@KBCLM}'"		/>
		<og:and value = "A.CLS_NAME    =    '{@CLS_NAME}'"		/>
		<og:and value = "A.RENDERER    =    '{@RENDERER}'"		/>
		<og:and value = "A.EDITOR      =    '{@EDITOR}'"		/>
		<og:and value = "A.DBTYPE      =    '{@DBTYPE}'"		/>
		<og:and value = "A.USE_LENGTH  =    '{@USE_LENGTH}'"	/>
		<og:and value = "A.BIKO        like '{@BIKO}'"		/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SYSTEM_ID,A.CLM" />
</og:query>

<!-- viewタグでpopupReturnKeysを設定するとポップアップ時に値を返します -->
<!-- POPUPでは、scope="request" 、selectedType = "radio" で、１件選択するようにします。 -->
<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	scope      = "request"
	selectedType = "radio"
	popupReturnKeys = "CLM,NAME_JA,CLS_NAME,VIEW_LENGTH,USE_LENGTH,DATA_DEFAULT,RENDERER,EDITOR,DBTYPE,BIKO"
	mainView  = "false"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
