<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX004"
	title	= "対訳"
	date	= "2015/05/09"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- 変更はここから -->

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェックを行います。 -->
<og:columnCheck command="NEW"
	nullCheck="sqlType"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- 翻訳されたデータを、取得します。 -->
<og:query command="NEW" debug="{@debug}" maxRowCount="0">
	select distinct '1' as WRITABLE
				, A.SYSTEM_ID
				, A.ID					AS CLM
				, A.GENBUN				AS NAME_JA
				, A.LANG_YAKU			AS LANG
				, B.YAKU				AS LNAME
				, C.YAKU				AS SNAME
				, D.YAKU				AS DESCRIPTION
				, ''					AS UNIQ
	from   GF28 A
			left outer join GF28 B on A.SYSTEM_ID=B.SYSTEM_ID and A.ID=B.ID and A.LANG_YAKU=B.LANG_YAKU and B.KBHORYU in ('1','7','8') and B.KBYAKU='1'
			left outer join GF28 C on A.SYSTEM_ID=C.SYSTEM_ID and A.ID=C.ID and A.LANG_YAKU=C.LANG_YAKU and C.KBHORYU in ('1','7','8') and C.KBYAKU='2'
			left outer join GF28 D on A.SYSTEM_ID=D.SYSTEM_ID and A.ID=D.ID and A.LANG_YAKU=D.LANG_YAKU and D.KBHORYU in ('1','7','8') and D.KBYAKU='3'
	<og:where>
		<og:and value = "A.SYSTEM_ID	=    '{@MEM.SYSTEM_ID}'"	/>
		<og:and value = "A.GENBUN		LIKE '{@MEM.GENBUN}'"		/>
		<og:and value = "A.KBYAKU		=    '{@MEM.KBYAKU}'"		/>
		<og:and value = "A.KEYWORD		LIKE '{@MEM.KEYWORD}'"		/>
		<og:and value = "A.ID			LIKE '{@MEM.ID}'"			/>
		<og:and value = "A.YAKU			LIKE '{@MEM.YAKU}'"			/>
		<og:and value = "A.LANG_YAKU	=    '{@MEM.LANG_YAKU}'"	/>
		<og:and value = "A.FGJ in ( '0','1' )"						/>
	</og:where>
	and    A.KBHORYU in ('1','7','8')			<!-- 対象は、1:翻訳済 、7:原訳同一、8:重複 -->
	order by 1,2,3
</og:query>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0" scope="request" >
	select '0' as WRITABLE , A.SYSTEM_ID , A.CLM , A.NAME_JA , A.LANG , A.LNAME , A.SNAME , A.DESCRIPTION , A.UNIQ
	from GEA08 A
	where A.SYSTEM_ID = '{@MEM.SYSTEM_ID}'
	and   A.LANG     != 'ja'
	and   A.FGJ       = '1'
	and   A.KBLBL &lt;= '9'			<!-- GF の タグリブは省く -->
	order by 1,2,3
</og:query>

<!-- すでにDB登録済みのデータを除外します。 -->
<og:tableMerge caseKey="{@sqlType}" caseVal="INSERT"
	action		= "MINUS"
	masterKeys	= "SYSTEM_ID,CLM,LANG"
/>

<og:tableMerge caseKey="{@sqlType}" caseVal="MODIFY"
	action		= "DIFFERENCE"
	masterKeys	= "SYSTEM_ID,CLM,LANG"
	diffKeys	= "LNAME,SNAME,DESCRIPTION"
	modifyClms	= "UNIQ"
/>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
	<!-- 登録、取消、リセットボタンを作成します。 -->
	<og:writeCheck>
		<og:submit  value="entry"   lbl="{@sqlType}" />
		<og:submit  value="reset"   lbl="RESET"      accesskey="R" />
		<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<og:view
		viewFormType = "HTMLTable"
		command 	 = "NEW"
		checked      = "{@checked}"
		startNo      = "{@startNo}" 
		pageSize     = "10000"
	/>

	<og:hidden name="sqlType" value="{@sqlType}" />
	<og:hidden name="DBID"    value="{@DBID}" />
</form>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
