/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.filter;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;

public class FileResponseTransform {
    private static final String CHART_KEY = "/ChartTemp/";
    private static final int KEY_LEN = "/ChartTemp/".length();
    private static final Set<String> TARGET_CHANGE_SET = new HashSet<String>();
    private static final ChangeData[] CHG_DATA = new ChangeData[]{new ChangeData(null, "\"/[^/]*/jsp/", "\"../"), new ChangeData(null, "'/[^/]*/jsp/", "'../"), new ChangeData(null, "\\(/[^/]*/jsp/", "(../"), new ChangeData(null, "=\"/[^/]*/[^/]*/ChartTemp/", "=\"../ChartTemp/"), new ChangeData(null, "='/[^/]*/[^/]*/ChartTemp/", "='../ChartTemp/"), new ChangeData(null, "=\"/[^/]*/help/", "=\"../help/"), new ChangeData(null, "='/[^/]*/help/", "='../help/"), new ChangeData(null, "\\.jsp", ".htm"), new ChangeData("query.htm", "action=\"result", "action=\"forward"), new ChangeData("forward.htm", "frame src=\"result", "frame src=\"forward"), new ChangeData("reset.htm", "frame src=\"result", "frame src=\"forward"), new ChangeData("index.htm", "frame src=\"forward.htm", "frame src=\"../common/dummy.html"), new ChangeData("index.htm", "frame src=\"entry.htm", "frame src=\"../common/dummy.html"), new ChangeData("indexRNW.htm", "frame src=\"forward.htm", "frame src=\"renew.htm"), new ChangeData("indexNW.htm", "frame src=\"query.htm", "frame src=\"queryNW.htm"), new ChangeData("indexNW.htm", "frame src=\"entry.htm", "frame src=\"../common/dummy.html"), new ChangeData("entry", "<input[^>]*history.back[^>]*>", ""), new ChangeData(null, "onSubmit=\"return oneClick\\(\\);\"", "onSubmit=\"return false;\""), new ChangeData(null, "onSubmit=\"\"", "onSubmit=\"return false;\""), new ChangeData(null, "src=\"\\.\\./common/option/ajaxSubmit\\.js\\?v=[^\"]+\"", ""), new ChangeData("queryNW.htm", "=\"http://.*jsp/+?", "=\"../"), new ChangeData("queryNW.htm", "\"query.htm?", "\"querNWy.htm?"), new ChangeData("query.htm", "renew\\('query.htm'", "renew\\('queryNW.htm'"), new IndexMatrixMenuData(), new IndexChangeData(), new HrefChangeData(), new NoTranHrefChangeData(), new FileDownloadChangeData()};

    public String replace(String string, String string2) {
        String string3 = string2;
        if (string.indexOf("query.htm") >= 0 && string2.indexOf("name=\"command\" value=\"\u767b\u9332") >= 0) {
            string3 = string2.replace("forward.jsp", "entry.htm");
        }
        if (string2.indexOf(CHART_KEY) >= 0) {
            this.chartTempFileCopy(string, string2);
        }
        for (int i = 0; i < CHG_DATA.length; ++i) {
            string3 = CHG_DATA[i].replace(string, string3);
        }
        return string3;
    }

    private void chartTempFileCopy(String string, String string2) {
        int n = string.indexOf("filetemp/DIR");
        File file = new File(string.substring(0, n) + "filetemp/DIR/ChartTemp/");
        if (!file.exists() && !file.mkdirs()) {
            System.err.println(file + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        File file2 = new File(string.substring(0, n) + "filetemp/ChartTemp/");
        int n2 = string2.indexOf(CHART_KEY);
        while (n2 >= 0) {
            int n3 = string2.indexOf(".png", n2 + KEY_LEN);
            String string3 = string2.substring(n2 + KEY_LEN, n3 + 4);
            FileUtil.copy((File)new File(file2, string3), (File)new File(file, string3));
            n2 = string2.indexOf(CHART_KEY, n3 + 4);
        }
    }

    private static final class FileDownloadChangeData
    extends ChangeData {
        private static final String PTN1 = "../common/fileDownload.htm\\?[^\"]*filename=([^&\"]*)[^\"]*\"";
        private static final Pattern PTN_OBJ1 = Pattern.compile("../common/fileDownload.htm\\?[^\"]*filename=([^&\"]*)[^\"]*\"");

        private FileDownloadChangeData() {
        }

        @Override
        public String replace(String string, String string2) {
            String string3 = string2;
            if (string3.indexOf("../common/fileDownload.htm") >= 0) {
                Matcher matcher = PTN_OBJ1.matcher(string3);
                int n = 0;
                while (matcher.find(n)) {
                    String string4 = matcher.group(1);
                    string4 = StringUtil.urlDecode((String)string4);
                    int n2 = matcher.start();
                    n = matcher.end();
                    string3 = string3.substring(0, n2) + string4 + "\"" + string3.substring(n);
                    matcher.reset(string3);
                }
            }
            return string3;
        }

        @Override
        public String toString() {
            return "FileDownloadChangeData()";
        }
    }

    private static final class NoTranHrefChangeData
    extends ChangeData {
        private static final String DIV_TAG = "<div id=\"noTransitionUrl\">";
        private static final String DISPLAY_NONE = "<style type=\"text/css\">#noTransitionUrl,#noTransitionTarget{display:none;}</style>";
        private static final String BODY_END = "</body>";
        private static final String APPEND_JS = "<script type=\"text/javascript\" src=\"../common/option/noTranHref.js\" ><!-- --></script>";

        private NoTranHrefChangeData() {
        }

        @Override
        public String replace(String string, String string2) {
            String string3 = string2;
            if (string.indexOf("entry") >= 0 && string2.indexOf("noTransitionUrl") >= 0) {
                int n;
                StringBuilder stringBuilder = new StringBuilder(string3);
                int n2 = stringBuilder.indexOf(DIV_TAG);
                if (n2 >= 0) {
                    stringBuilder.insert(n2, DISPLAY_NONE);
                }
                if ((n = stringBuilder.indexOf(BODY_END)) >= 0) {
                    stringBuilder.insert(n, APPEND_JS);
                } else {
                    stringBuilder.append(APPEND_JS);
                }
                string3 = stringBuilder.toString();
            }
            return string3;
        }

        @Override
        public String toString() {
            return "NoTranHrefChangeData()";
        }
    }

    private static final class HrefChangeData
    extends ChangeData {
        private static final String PTN1 = "<input type=\"hidden\" name=\"hX_([^\"]*)\" value=\"([^\"]*.htm)";
        private static final Pattern PTN_OBJ1 = Pattern.compile("<input type=\"hidden\" name=\"hX_([^\"]*)\" value=\"([^\"]*.htm)");
        private static final String ORG = "<input name=\"command\"";
        private static final String SELF = "<input name=\"command\" onClick=\"location.href='";
        private static final String PRNT = "<input name=\"command\" onClick=\"parent.location.href='";
        private static final String TOP = "<input name=\"command\" onClick=\"top.location.href='";
        private static final String PTN2 = "<form .*target=\"([^\"]*)\"";
        private static final Pattern PTN_OBJ2 = Pattern.compile("<form .*target=\"([^\"]*)\"");
        private static final String LOC_HREF = "location.href";
        private static final String TP_SUBMIT = "type=\"submit\"";
        private static final String TP_BUTTON = "type=\"button\"";

        private HrefChangeData() {
        }

        @Override
        public String replace(String string, String string2) {
            String string3 = string2;
            if (string.indexOf("query") < 0) {
                CharSequence charSequence;
                Matcher matcher = PTN_OBJ2.matcher(string3);
                String string4 = SELF;
                if (matcher.find()) {
                    int n = string.lastIndexOf(47);
                    String string5 = string.substring(0, n);
                    charSequence = matcher.group(1);
                    if ("CONTENTS".equals(charSequence)) {
                        string4 = PRNT;
                    } else if ("_top".equals(charSequence)) {
                        string4 = TOP;
                    } else if ("RESULT".equals(charSequence) || charSequence == null) {
                        if (TARGET_CHANGE_SET.contains(string5)) {
                            string4 = PRNT;
                        }
                    } else {
                        string4 = "<input name=\"command\" onClick=\"parent." + (String)charSequence + ".location.href='";
                        TARGET_CHANGE_SET.add(string5);
                    }
                }
                Matcher matcher2 = PTN_OBJ1.matcher(string3);
                int n = 0;
                while (matcher2.find(n)) {
                    charSequence = matcher2.group(1);
                    if (!((String)charSequence).endsWith("CMD")) {
                        String string6 = matcher2.group(2);
                        String string7 = "<input name=\"command\" value=\"" + (String)charSequence;
                        String string8 = string6 != null && string6.startsWith("../") ? PRNT + string6 + "'\" value=\"" + (String)charSequence : (string6 != null && string6.startsWith("update") ? string4 + (String)charSequence + ".htm'\" value=\"" + (String)charSequence : string4 + string6 + "'\" value=\"" + (String)charSequence);
                        string3 = string3.replace(string7, string8);
                    }
                    n = matcher2.end();
                    matcher2.reset(string3);
                }
                charSequence = new StringBuilder(string3);
                int n2 = ((StringBuilder)charSequence).indexOf(LOC_HREF);
                while (n2 >= 0) {
                    int n3 = ((StringBuilder)charSequence).indexOf(TP_SUBMIT, n2);
                    int n4 = ((StringBuilder)charSequence).indexOf("/>", n2);
                    if (n3 >= 0 && n4 >= 0 && n3 < n4) {
                        ((StringBuilder)charSequence).replace(n3, n3 + TP_SUBMIT.length(), TP_BUTTON);
                    }
                    n2 = ((StringBuilder)charSequence).indexOf(LOC_HREF, Math.max(n4, n2 + LOC_HREF.length()));
                }
                string3 = ((StringBuilder)charSequence).toString();
            }
            return string3;
        }

        @Override
        public String toString() {
            return "HrefChangeData()";
        }
    }

    private static final class IndexChangeData
    extends ChangeData {
        private static final Pattern PTN1 = Pattern.compile("index.htm\\?[^\"]*command=(NEW|RENEW)");

        private IndexChangeData() {
        }

        @Override
        public String replace(String string, String string2) {
            String string3 = string2;
            Matcher matcher = PTN1.matcher(string3);
            int n = 0;
            while (matcher.find(n)) {
                int n2 = matcher.start();
                String string4 = matcher.group(1);
                if ("NEW".equalsIgnoreCase(string4)) {
                    string3 = string3.substring(0, n2 + 5) + "NW" + string3.substring(n2 + 5);
                } else if ("RENEW".equalsIgnoreCase(string4)) {
                    string3 = string3.substring(0, n2 + 5) + "RNW" + string3.substring(n2 + 5);
                }
                n = matcher.end();
                matcher.reset(string3);
            }
            return string3;
        }

        @Override
        public String toString() {
            return "IndexChangeData()";
        }
    }

    private static final class IndexMatrixMenuData
    extends ChangeData {
        private IndexMatrixMenuData() {
        }

        @Override
        public String replace(String string, String string2) {
            String string3 = string2;
            if (string.indexOf("matrixMenu") >= 0) {
                string3 = string3.replaceAll("\"../[^/]*[/]*index.htm\\?[^\"]*GAMENID=([^&\"]*)[^\"]*\"", "\"../jsp/index$1.htm\"");
                string3 = string3.replaceAll("matrixMenu.htm\\?[^\"]*group=([^&\"]*)[^\"]*\"", "matrixMenu$1.htm\"");
                string3 = string3.replaceAll("=\"../../../mr/jsp/", "=\"../");
            } else if (string.indexOf("jsp/index") >= 0) {
                string3 = string3.replaceAll("frame src=\"../[^\"]*GAMENID=([^&\"]*)[^\"]*\"", "frame src=\"../$1/index.htm\"");
            } else if (string.indexOf("query") >= 0) {
                string3 = string3.replaceAll("../result.htm\\?[^\"]*GAMENID=([^&\"]*)[^\"]*\"", "../jsp/index$1.htm\"");
            } else if (string.indexOf("multiMenu") >= 0 || string.indexOf("menu") >= 0 || string.indexOf("normalMenu") >= 0) {
                string3 = string3.replaceAll("multiMenu.htm\\?[^\"]*group=([^&\"]*)[^\"]*\"", "menu$1.htm\"");
            }
            return string3;
        }

        @Override
        public String toString() {
            return "IndexMatrixMenuData()";
        }
    }

    private static class ChangeData {
        private final String filename;
        private final String org;
        private final String rep;

        public ChangeData() {
            this(null, null, null);
        }

        public ChangeData(String string, String string2, String string3) {
            this.filename = string;
            this.org = string2;
            this.rep = string3;
        }

        public String replace(String string, String string2) {
            String string3 = string2;
            if (this.filename == null || string.indexOf(this.filename) >= 0) {
                string3 = string2.replaceAll(this.org, this.rep);
            }
            return string3;
        }

        public String toString() {
            return "ChangeData( " + this.filename + " , " + this.org + " , " + this.rep + " )";
        }
    }
}

