/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.storage.object.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;

public final class ObjectListOptions {
    private Map<String, String> queryParams = Maps.newHashMap();

    private ObjectListOptions() {
    }

    public static ObjectListOptions create() {
        return new ObjectListOptions();
    }

    public ObjectListOptions limit(int limit) {
        Preconditions.checkState((limit >= 0 ? 1 : 0) != 0, (Object)"limit must be >= 0");
        Preconditions.checkState((limit <= 10000 ? 1 : 0) != 0, (Object)"limit must be <= 10000");
        this.queryParams.put("limit", Integer.toString(limit));
        return this;
    }

    public ObjectListOptions marker(String marker) {
        this.queryParams.put("marker", (String)Preconditions.checkNotNull((Object)marker, (Object)"marker"));
        return this;
    }

    public ObjectListOptions endMarker(String endMarker) {
        this.queryParams.put("end_marker", (String)Preconditions.checkNotNull((Object)endMarker, (Object)"endMarker"));
        return this;
    }

    public ObjectListOptions startsWith(String prefix) {
        this.queryParams.put("prefix", (String)Preconditions.checkNotNull((Object)prefix, (Object)"prefix"));
        return this;
    }

    public ObjectListOptions delimiter(char delimiter) {
        this.queryParams.put("delimiter", Character.toString(delimiter));
        return this;
    }

    public ObjectListOptions path(String path) {
        this.queryParams.put("path", (String)Preconditions.checkNotNull((Object)path, (Object)"path"));
        return this;
    }

    public Map<String, String> getOptions() {
        return this.queryParams;
    }
}

