/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.servlet;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.SystemManager;
import org.opengion.hayabusa.common.SystemParameter;
import org.opengion.hayabusa.common.UserSummary;
import org.opengion.hayabusa.filter.AccessStopFilter;
import org.opengion.hayabusa.resource.ResourceFactory;
import org.opengion.hayabusa.resource.UserInfo;

public final class HybsAdmin
extends HttpServlet {
    private static final long serialVersionUID = 4000L;
    private static final String CR = HybsSystem.CR;
    private static final String JSP = HybsSystem.sys("JSP");
    private static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + CR + "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"" + CR + "    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">" + CR + "<html xmlns=\"http://www.w3.org/1999/xhtml\" >" + CR + "<head>" + CR + "    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />" + CR + "    <meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />" + CR + "    <link rel=\"stylesheet\" href=\"" + JSP + "/common/default.css\" type=\"text/css\" />" + CR + "    <link rel=\"stylesheet\" href=\"" + JSP + "/custom/custom.css\" type=\"text/css\" />" + CR + "    <title>Hybs Admin</title>" + CR + "</head>" + CR;
    private static final String TABLE_HEADER = HybsAdmin.getTableHeaderTag();
    private static final String OS_INFO = HybsSystem.sys("OS_INFO");
    private static final String SERVER_INFO = HybsSystem.sys("SERVER_INFO");
    private static final String SERVLET_INFO = HybsSystem.sys("SERVLET_INFO");
    private static final String REAL_PATH = HybsSystem.sys("REAL_PATH");
    private static final String TOMCAT_HOME = HybsSystem.sys("TOMCAT_HOME");
    private static final String JDK_INFO = HybsSystem.sys("JDK_INFO");
    private static final String JAVA_HOME = HybsSystem.sys("JAVA_HOME");
    private static final String ENGINE_INFO = HybsSystem.sys("ENGINE_INFO");
    private static final String[] USER_KEYS = new String[]{"ID", "Jname", "Roles", "IPAddress", "LoginTime", "LastAccess", "LastGamenNm"};

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        PrintWriter printWriter = httpServletResponse.getWriter();
        String string = httpServletRequest.getParameter("COMMAND");
        printWriter.println(HEADER);
        printWriter.println("<body>");
        printWriter.print("<h2>");
        printWriter.print(httpServletRequest.getServerName());
        printWriter.print(":");
        printWriter.print(httpServletRequest.getServerPort());
        printWriter.print(httpServletRequest.getContextPath());
        printWriter.println("</h2>");
        if ("infomation".equalsIgnoreCase(string)) {
            printWriter.print(this.getInfomation());
        } else if ("close".equalsIgnoreCase(string)) {
            printWriter.print(this.getCloseMessage(httpServletRequest.getSession()));
        } else if ("loginUser".equalsIgnoreCase(string)) {
            String string2 = httpServletRequest.getParameter("sort");
            String string3 = httpServletRequest.getParameter("direc");
            boolean bl = string3 == null ? true : Boolean.valueOf(string3);
            printWriter.print(this.getLoginUser(string2, bl));
        } else if ("plugin".equalsIgnoreCase(string)) {
            printWriter.print(this.getPlugInInfo());
        } else if ("taglib".equalsIgnoreCase(string)) {
            printWriter.print(this.getTaglibInfo());
        } else if ("systemResource".equalsIgnoreCase(string)) {
            printWriter.print(this.getSystemResource());
        } else if ("AccessStop".equalsIgnoreCase(string)) {
            printWriter.print(this.getAccessStop());
        } else if ("UserInfo".equalsIgnoreCase(string)) {
            printWriter.print(this.setUserinfo(httpServletRequest));
        } else {
            printWriter.print(this.getAdminLink());
        }
        printWriter.println("</body></html>");
    }

    private String getInfomation() {
        int n = SystemManager.getRunningCount();
        int n2 = (int)(Runtime.getRuntime().freeMemory() / 1024L);
        int n3 = (int)(Runtime.getRuntime().totalMemory() / 1024L);
        int n4 = (n3 - n2) * 100 / n3;
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<table border = \"0px\" >").append(CR);
        this.tableTr1(stringBuilder, "\u30b5\u30fc\u30d0\u30fc\u60c5\u5831");
        this.tableTr(stringBuilder, "\uff2f\uff33\u60c5\u5831", OS_INFO);
        this.tableTr(stringBuilder, "\u30b5\u30fc\u30d0\u30fc\u540d", SERVER_INFO);
        this.tableTr(stringBuilder, "\u30b5\u30fc\u30d6\u30ec\u30c3\u30c8", SERVLET_INFO);
        this.tableTr(stringBuilder, "TOMCAT_HOME", TOMCAT_HOME);
        this.tableTr(stringBuilder, "JDK\u30d0\u30fc\u30b8\u30e7\u30f3", JDK_INFO);
        this.tableTr(stringBuilder, "JAVA_HOME", JAVA_HOME);
        this.tableTr1(stringBuilder, "\u5b9f\u884c\u74b0\u5883");
        this.tableTr(stringBuilder, "REAL_PATH", REAL_PATH);
        this.tableTr(stringBuilder, "\u30d0\u30fc\u30b8\u30e7\u30f3No", ENGINE_INFO);
        this.tableTr(stringBuilder, "\u4f5c\u6210\u65e5\u6642", "2018/01/09 17:46:52");
        this.tableTr1(stringBuilder, "\u30ed\u30b0\u30a4\u30f3\u60c5\u5831");
        this.tableTr(stringBuilder, "\u30ed\u30b0\u30a4\u30f3\u4eba\u6570", String.valueOf(n), " \u540d ", "( <a href=\"admin?COMMAND=loginUser\">\u660e\u7d30\u60c5\u5831</a> )");
        this.tableTr1(stringBuilder, "\u30e1\u30e2\u30ea\u60c5\u5831");
        this.tableTr(stringBuilder, "\u7a7a\u304d\u30e1\u30e2\u30ea", String.valueOf(n2), " [KByte]");
        this.tableTr(stringBuilder, "\u5408\u8a08\u30e1\u30e2\u30ea", String.valueOf(n3), " [KByte]");
        this.tableTr(stringBuilder, "\u4f7f\u7528\u7387", String.valueOf(n4), " [\uff05]");
        stringBuilder.append("</table>").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("<table width=\"50%\" frame=\"box\" border = \"1px\" cellspacing=\"0px\" cellpadding=\"0px\" >").append(CR);
        stringBuilder.append("\t<tr><td align=\"center\" width=\"").append(n4).append("%\" bgcolor=\"red\" >").append(CR);
        stringBuilder.append(n4).append("%</td>").append(CR);
        stringBuilder.append("\t\t<td align=\"center\">").append(100 - n4).append("%</td>").append(CR);
        stringBuilder.append("\t</tr>").append(CR);
        stringBuilder.append("</table>").append(CR);
        stringBuilder.append("<hr />").append(CR);
        stringBuilder.append("<pre>").append(CR);
        stringBuilder.append(ConnectionFactory.information()).append(CR);
        stringBuilder.append("</pre>").append(CR);
        return stringBuilder.toString();
    }

    private StringBuilder tableTr1(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<tr><td colspan=\"4\"><b>\u3010").append(string).append("\u3011</b></td></tr>").append(CR);
        return stringBuilder;
    }

    private StringBuilder tableTr(StringBuilder stringBuilder, String string, String ... stringArray) {
        stringBuilder.append("<tr><td width=\"20px\">\u3000</td><td>").append(string).append("</td><td> = </td><td>");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
        }
        stringBuilder.append("</td></tr>").append(CR);
        return stringBuilder;
    }

    private String getCloseMessage(HttpSession httpSession) {
        SystemManager.allClear(false);
        ServletContext servletContext = httpSession.getServletContext();
        Map<String, String> map = SystemParameter.makeSystemParameter(servletContext);
        HybsSystem.setInitialData(map);
        SystemManager.removeSession(httpSession);
        String string = "<pre>\u30ad\u30e3\u30c3\u30b7\u30e5\u60c5\u5831\u3092\u30af\u30ea\u30a2\u30fc\u3057\u307e\u3057\u305f\u3002" + CR + "\u30e6\u30fc\u30b6\u30fc\u60c5\u5831\u306e\u521d\u671f\u5316\u306b\u95a2\u3057\u3066\u306f\u3001\u30d6\u30e9\u30a6\u30b6\u3092\u9589\u3058\u3066\u3001\u518d\u30ed\u30b0\u30a4\u30f3\u304c\u5fc5\u8981\u3067\u3059\u3002" + CR + ConnectionFactory.information() + "</pre>";
        return string;
    }

    private String getLoginUser(String string, boolean bl) {
        int n = SystemManager.getRunningCount();
        UserSummary[] userSummaryArray = SystemManager.getRunningUserSummary(string, bl);
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("\u73fe\u5728 ").append(n).append(" \u540d\u306e\u65b9\u304c\u30ed\u30b0\u30a4\u30f3\u4e2d\u3067\u3059\u3002");
        stringBuilder.append(CR);
        stringBuilder.append("<table ").append(TABLE_HEADER).append(" >").append(CR);
        stringBuilder.append(" <thead><tr><th>No</th>");
        for (String string2 : USER_KEYS) {
            stringBuilder.append("  <th><a href=\"?COMMAND=loginUser&sort=").append(string2).append("&direc=").append(!bl).append("\">").append(string2).append("</a></th>");
        }
        stringBuilder.append(" </tr></thead>").append(CR);
        stringBuilder.append(" <colgroup class=\"S9\" ><!-- --></colgroup>").append(CR);
        stringBuilder.append(" <colgroup class=\"X\" span=\"6\" ><!-- --></colgroup>").append(CR);
        stringBuilder.append(CR);
        for (int i = 0; i < userSummaryArray.length; ++i) {
            UserSummary userSummary = userSummaryArray[i];
            stringBuilder.append(" <tr class=\"row_").append(i % 2).append("\" >").append(CR);
            stringBuilder.append("  <td>").append(String.valueOf(i + 1)).append("</td>").append(CR);
            stringBuilder.append("  <td>").append(userSummary.getUserID()).append("</td>").append(CR);
            stringBuilder.append("  <td>").append(userSummary.getJname()).append("</td>").append(CR);
            stringBuilder.append("  <td>").append(userSummary.getRoles()).append("</td>").append(CR);
            stringBuilder.append("  <td>").append(userSummary.getIPAddress()).append("</td>").append(CR);
            stringBuilder.append("  <td>").append(HybsSystem.getDate(userSummary.getLoginTime())).append("</td>").append(CR);
            stringBuilder.append("  <td>").append(userSummary.getAttribute("LASTACCESS")).append("</td>").append(CR);
            stringBuilder.append("  <td>").append(StringUtil.nval((String)userSummary.getAttribute("LASTGAMENNM"), (String)"")).append("</td>").append(CR);
            stringBuilder.append(" </tr>").append(CR);
        }
        stringBuilder.append("</table>").append(CR);
        return stringBuilder.toString();
    }

    private String getPlugInInfo() {
        String[] stringArray = new String[]{"Query", "Renderer", "Editor", "DBType", "ViewForm", "TableReader", "TableWriter", "TableFilter", "ChartWriter", "CalendarQuery", "DBConstValue", "Daemon", "JspCreate"};
        ClassInfo classInfo = new ClassInfo();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            HybsEntry[] hybsEntryArray = HybsSystem.sysEntry(string + "_");
            for (int j = 0; j < hybsEntryArray.length; ++j) {
                String string2 = hybsEntryArray[j].getKey().substring(string.length() + 1);
                String string3 = hybsEntryArray[j].getValue();
                classInfo.addLine(string, string2, string3);
            }
        }
        return classInfo.getClassInfoData();
    }

    private String getTaglibInfo() {
        ClassInfo classInfo = new ClassInfo();
        JarFile jarFile = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> enumeration = classLoader.getResources("org/opengion/hayabusa/taglib/");
            while (enumeration.hasMoreElements()) {
                String string;
                String string2;
                String string3;
                String string4;
                Object object;
                Object object2;
                URL uRL = enumeration.nextElement();
                String string5 = uRL.getFile();
                if ("jar".equals(uRL.getProtocol())) {
                    object2 = string5.substring(string5.indexOf(58) + 1, string5.lastIndexOf(33));
                    jarFile = new JarFile((String)object2);
                    object = jarFile.entries();
                    while (object.hasMoreElements()) {
                        JarEntry jarEntry = (JarEntry)object.nextElement();
                        string4 = jarEntry.getName();
                        if (jarEntry.isDirectory() || !string4.endsWith("Tag.class")) continue;
                        string3 = "Taglib";
                        string2 = string4.substring(string4.lastIndexOf(47) + 1, string4.length() - 6);
                        string = string4.replace('/', '.').substring(0, string4.length() - 6);
                        classInfo.addLine(string3, string2, string);
                    }
                    Closer.zipClose((ZipFile)jarFile);
                    jarFile = null;
                    continue;
                }
                object2 = new File(string5);
                object = ((File)object2).listFiles();
                for (int i = 0; i < ((File[])object).length; ++i) {
                    string4 = object[i].getName();
                    if (!((File)object[i]).isFile() || !string4.endsWith("Tag.class")) continue;
                    string3 = "Taglib";
                    string2 = string4.substring(0, string4.length() - 6);
                    string = "org.opengion.hayabusa.taglib." + string2;
                    classInfo.addLine(string3, string2, string);
                }
            }
        }
        catch (IOException iOException) {
            String string = "taglib\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u53d6\u308a\u30b9\u30c8\u30ea\u30fc\u30e0\u3092\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + CR + iOException.getMessage();
            throw new RuntimeException(string, iOException);
        }
        finally {
            Closer.zipClose(jarFile);
        }
        return classInfo.getClassInfoData();
    }

    private String getSystemResource() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<table ").append(TABLE_HEADER).append(" >").append(CR);
        stringBuilder.append("\t<thead><tr><th>No</th><th>Key</th><th>Value</th></tr></thead>").append(CR);
        stringBuilder.append("\t<colgroup class=\"S9\" ><!-- --></colgroup>").append(CR);
        stringBuilder.append("\t<colgroup class=\"X\" span=\"2\" ><!-- --></colgroup>").append(CR);
        stringBuilder.append(CR);
        String[][] stringArray = HybsSystem.getSystemResourceData();
        for (int i = 0; i < stringArray[0].length; ++i) {
            stringBuilder.append("\t<tr class=\"row_").append(i % 2).append("\" >").append(CR);
            stringBuilder.append("\t\t<td>").append(String.valueOf(i + 1)).append("</td>").append(CR);
            stringBuilder.append("\t\t<td>").append(stringArray[0][i]).append("</td>").append(CR);
            stringBuilder.append("\t\t<td>").append(stringArray[1][i]).append("</td>").append(CR);
            stringBuilder.append("\t</tr>").append(CR);
        }
        stringBuilder.append("</table>").append(CR);
        return stringBuilder.toString();
    }

    private String getAccessStop() {
        boolean bl = AccessStopFilter.isStopFilter();
        bl = !bl;
        String string = bl ? "Web\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306e\u30b5\u30fc\u30d3\u30b9\u3092\u505c\u6b62\u3057\u307e\u3059\u3002" : "Web\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306e\u30b5\u30fc\u30d3\u30b9\u3092\u958b\u59cb\u3057\u307e\u3059\u3002";
        AccessStopFilter.setStopFilter(bl);
        return string;
    }

    private String getAdminLink() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<table><tr>").append(CR);
        stringBuilder.append("<td width=\"10px\"/>").append(CR);
        stringBuilder.append("<td>[<a href=\"admin?COMMAND=infomation\" target=\"RESULT\" >\u72b6\u6cc1\u8868\u793a</a>]</td>").append(CR);
        stringBuilder.append("<td width=\"10px\"/>").append(CR);
        stringBuilder.append("<td>[<a href=\"admin?COMMAND=close\" target=\"RESULT\" >\uff8c\uff9f\uff70\uff99\u524a\u9664</a>]</td>").append(CR);
        stringBuilder.append("<td width=\"10px\"/><td>").append(CR);
        stringBuilder.append("[<a href=\"admin?COMMAND=loginUser\" target=\"RESULT\" >\uff9b\uff78\uff9e\uff72\uff9d\uff95\uff70\uff7b\uff9e\uff70</a>]</td>").append(CR);
        stringBuilder.append("<td width=\"10px\"/><td>").append(CR);
        stringBuilder.append("[<a href=\"admin?COMMAND=plugin\" target=\"RESULT\" >\uff8c\uff9f\uff97\uff78\uff9e\uff72\uff9d\u60c5\u5831</a>]</td>").append(CR);
        stringBuilder.append("<td width=\"10px\"/><td>").append(CR);
        stringBuilder.append("[<a href=\"admin?COMMAND=taglib\" target=\"RESULT\" >\uff80\uff78\uff9e\uff98\uff8c\uff9e\u60c5\u5831</a>]</td>").append(CR);
        stringBuilder.append("<td width=\"10px\"/><td>").append(CR);
        stringBuilder.append("[<a href=\"common/quickReference.html\" target=\"RESULT\" >\uff78\uff72\uff6f\uff78\uff98\uff8c\uff67\uff9a\uff9d\uff7d</a>]</td>").append(CR);
        stringBuilder.append("<td width=\"10px\"/><td>").append(CR);
        stringBuilder.append("[<a href=\"admin?COMMAND=systemResource\" target=\"RESULT\" >\uff7c\uff7d\uff83\uff91\uff98\uff7f\uff70\uff7d</a>]</td>").append(CR);
        stringBuilder.append("<td width=\"10px\"/><td>").append(CR);
        stringBuilder.append("[<a href=\"common/gamen/01_ADMIN/parameter.jsp?GAMENID=01_ADMIN\" target=\"RESULT\" >Parameter</a>]</td>").append(CR);
        stringBuilder.append("</tr></table>").append(CR);
        return stringBuilder.toString();
    }

    private static String getTableHeaderTag() {
        Attributes attributes = new Attributes();
        attributes.set("id", "viewTable");
        attributes.set("summary", "layout");
        return attributes.getAttribute();
    }

    private String setUserinfo(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession();
        UserInfo userInfo = (UserInfo)httpSession.getAttribute("h_uInfo");
        String string = httpServletRequest.getParameter("LANG");
        String string2 = null;
        if (userInfo != null && string != null && string.length() > 0) {
            userInfo.setLang(string);
            ResourceFactory.newInstance(userInfo.getLang()).makeGUIInfos(userInfo);
            string2 = "User language : " + string;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "Error";
        }
        return string2;
    }

    private static final class ClassInfo {
        private final StringBuilder rtn = new StringBuilder(200);
        private int cnt = 0;

        public ClassInfo() {
            this.rtn.append("<table ").append(TABLE_HEADER).append(" >").append(CR);
            this.rtn.append("\t<thead><tr><th>No</th><th>Classify</th><th>Key Name</th><th>Class Name</th><th>Version</th></tr></thead>").append(CR);
            this.rtn.append("\t<colgroup class=\"S9\" ><!-- --></colgroup>").append(CR);
            this.rtn.append("\t<colgroup class=\"X\" ><!-- --></colgroup>").append(CR);
            this.rtn.append("\t<colgroup class=\"X\" ><!-- --></colgroup>").append(CR);
            this.rtn.append("\t<colgroup class=\"X\" ><!-- --></colgroup>").append(CR);
            this.rtn.append("\t<colgroup class=\"X\" ><!-- --></colgroup>").append(CR);
            this.rtn.append("\t<colgroup class=\"X\" ><!-- --></colgroup>").append(CR);
            this.rtn.append(CR);
        }

        public void addLine(String string, String string2, String string3) {
            String string4 = this.getFieldValue(string3);
            boolean bl = string4.compareTo("5.9.28.0") > 0 || string4.indexOf("Pache") >= 0 || string4.indexOf("Nightly") >= 0;
            String string5 = bl ? "warning" : String.valueOf(this.cnt % 2);
            this.rtn.append("\t<tr class=\"row_").append(string5).append("\" >").append(CR);
            this.rtn.append("\t\t<td>").append(this.cnt++).append("</td>").append(CR);
            this.rtn.append("\t\t<td>").append(string).append("</td>").append(CR);
            this.rtn.append("\t\t<td>").append(string2).append("</td>").append(CR);
            this.rtn.append("\t\t<td>").append(string3).append("</td>").append(CR);
            this.rtn.append("\t\t<td>").append(string4).append("</td>").append(CR);
            this.rtn.append("\t</tr>").append(CR);
        }

        public String getClassInfoData() {
            this.rtn.append("</table>").append(CR);
            return this.rtn.toString();
        }

        private String getFieldValue(String string) {
            String string2;
            try {
                Object object = HybsSystem.newInstance(string);
                Field field = object.getClass().getDeclaredField("VERSION");
                field.setAccessible(true);
                string2 = (String)field.get(null);
            }
            catch (Throwable throwable) {
                string2 = throwable.getMessage();
            }
            return string2;
        }
    }
}

