/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v2.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.identity.v2.RoleService;
import org.openstack4j.core.transport.HttpMethod;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v2.Role;
import org.openstack4j.openstack.identity.v2.domain.KeystoneCreateRole;
import org.openstack4j.openstack.identity.v2.domain.KeystoneRole;
import org.openstack4j.openstack.internal.BaseOpenStackService;

public class RoleServiceImpl
extends BaseOpenStackService
implements RoleService {
    @Override
    public ActionResponse addUserRole(String userId, String roleId) {
        return this.addUserRole(null, userId, roleId);
    }

    @Override
    public ActionResponse addUserRole(String tenantId, String userId, String roleId) {
        return this.addRemoveRoles(HttpMethod.PUT, tenantId, userId, roleId);
    }

    @Override
    public ActionResponse removeUserRole(String userId, String roleId) {
        return this.removeUserRole(null, userId, roleId);
    }

    @Override
    public ActionResponse removeUserRole(String tenantId, String userId, String roleId) {
        return this.addRemoveRoles(HttpMethod.DELETE, tenantId, userId, roleId);
    }

    private ActionResponse addRemoveRoles(HttpMethod method, String tenantId, String userId, String roleId) {
        Preconditions.checkNotNull((Object)userId);
        Preconditions.checkNotNull((Object)roleId);
        String uri = tenantId != null ? this.uri("/tenants/%s/users/%s/roles/OS-KSADM/%s", tenantId, userId, roleId) : this.uri("/users/%s/roles/OS-KSADM/%s", userId, roleId);
        return this.request(method, ActionResponse.class, uri).execute();
    }

    @Override
    public List<? extends Role> list() {
        return this.get(KeystoneRole.Roles.class, this.uri("/OS-KSADM/roles", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Role> listRolesForUser(String userId) {
        return this.listRolesForUser(userId, null);
    }

    @Override
    public List<? extends Role> listRolesForUser(String userId, String tenantId) {
        Preconditions.checkNotNull((Object)userId);
        String uri = tenantId != null ? this.uri("/tenants/%s/users/%s/roles", tenantId, userId) : this.uri("/users/%s/roles", userId);
        return this.get(KeystoneRole.Roles.class, uri).execute().getList();
    }

    @Override
    public ActionResponse delete(String roleId) {
        Preconditions.checkNotNull((Object)roleId);
        return this.deleteWithResponse(this.uri("/OS-KSADM/roles/%s", roleId)).execute();
    }

    @Override
    public Role get(String roleId) {
        Preconditions.checkNotNull((Object)roleId);
        return this.get(KeystoneRole.class, this.uri("/OS-KSADM/roles/%s", roleId)).execute();
    }

    @Override
    public Role create(String name) {
        Preconditions.checkNotNull((Object)name);
        return this.post(KeystoneRole.class, this.uri("/OS-KSADM/roles", new Object[0])).entity(new KeystoneCreateRole(name)).execute();
    }

    @Override
    public Role getByName(String name) {
        Preconditions.checkNotNull((Object)name);
        List<? extends Role> roles = this.list();
        for (Role role : roles) {
            if (!name.equalsIgnoreCase(role.getName())) continue;
            return role;
        }
        return null;
    }
}

