/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.image.domain.functions;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.model.image.ContainerFormat;
import org.openstack4j.model.image.DiskFormat;
import org.openstack4j.model.image.Image;
import org.openstack4j.model.image.builder.ImageBuilder;
import org.openstack4j.openstack.image.domain.GlanceImage;
import org.openstack4j.openstack.image.domain.ImageHeader;
import org.openstack4j.openstack.internal.Parser;

public class ImageFromHeadersFunction
implements Function<HttpResponse, Image> {
    private static final ImageFromHeadersFunction instance = new ImageFromHeadersFunction();

    public static ImageFromHeadersFunction instance() {
        return instance;
    }

    private ImageFromHeadersFunction() {
    }

    @Nullable
    public Image apply(HttpResponse from) {
        ImageBuilder builder = GlanceImage.builder().id(from.header(ImageHeader.ID.asHeader())).name(from.header(ImageHeader.NAME.asHeader())).checksum(from.header(ImageHeader.CHECKSUM.asHeader())).minDisk(Parser.asLong(from.header(ImageHeader.MIN_DISK.asHeader()))).minRam(Parser.asLong(from.header(ImageHeader.MIN_RAM.asHeader()))).isPublic(Parser.asBoolean(from.header(ImageHeader.IS_PUBLIC.asHeader()))).owner(from.header(ImageHeader.OWNER.asHeader())).containerFormat(ContainerFormat.value(from.header(ImageHeader.CONTAINER_FORMAT.asHeader()))).diskFormat(DiskFormat.value(from.header(ImageHeader.DISK_FORMAT.asHeader())));
        GlanceImage image = (GlanceImage)builder.build();
        image.location(from.header("Location")).isDeleted(Parser.asBoolean(from.header(ImageHeader.DELETED.asHeader()))).isProtected(Parser.asBoolean(from.header(ImageHeader.PROTECTED.asHeader()))).createdAt(Parser.asDate(from.header(ImageHeader.CREATED_AT.asHeader()))).updatedAt(Parser.asDate(from.header(ImageHeader.UPDATED_AT.asHeader()))).deletedAt(Parser.asDate(from.header(ImageHeader.DELETED_AT.asHeader()))).size(Parser.asLong(from.header(ImageHeader.SIZE.asHeader()))).status(Image.Status.value(from.header(ImageHeader.STATUS.asHeader())));
        HashMap properties = null;
        String property = ImageHeader.PROPERTY.asHeader() + "-";
        for (String k : from.headers().keySet()) {
            if (k.indexOf(property) <= -1) continue;
            if (properties == null) {
                properties = Maps.newHashMap();
            }
            properties.put(k.substring(property.length()).toLowerCase(), from.headers().get(k));
        }
        image.properties(properties);
        return image;
    }
}

