/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.openstack4j.model.identity.AuthStore;
import org.openstack4j.model.identity.AuthVersion;
import org.openstack4j.openstack.common.Auth;
import org.openstack4j.openstack.identity.v3.domain.Auth;

@JsonRootName(value="auth")
public class Credentials
extends Auth
implements AuthStore {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="passwordCredentials")
    private PasswordCredentials passwordCreds = new PasswordCredentials();

    public Credentials() {
        super(Auth.Type.CREDENTIALS);
    }

    public Credentials(String username, String password) {
        this();
        this.passwordCreds.setCredentials(username, password);
    }

    public Credentials(String username, String password, String domainId) {
        this();
        this.passwordCreds.setCredentials(username, password);
        this.setDomainId(domainId);
    }

    @Override
    @JsonIgnore
    public String getUsername() {
        return this.passwordCreds.username;
    }

    @Override
    @JsonIgnore
    public String getPassword() {
        return this.passwordCreds.password;
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.getDomainId();
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.getDomainName();
    }

    @Override
    @JsonIgnore
    public AuthVersion getVersion() {
        return AuthVersion.V3;
    }

    private static final class PasswordCredentials {
        @JsonProperty
        String username;
        @JsonProperty
        String password;

        private PasswordCredentials() {
        }

        public void setCredentials(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

