/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.KeyVaultClientImpl;
import com.microsoft.azure.keyvault.models.KeyBundle;
import com.microsoft.azure.keyvault.models.KeyOperationResult;
import com.microsoft.sqlserver.jdbc.KeyVaultCredential;
import com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionKeyStoreProvider;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerKeyVaultAuthenticationCallback;
import com.microsoft.windowsazure.credentials.CloudCredentials;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.http.impl.client.HttpClientBuilder;

public class SQLServerColumnEncryptionAzureKeyVaultProvider
extends SQLServerColumnEncryptionKeyStoreProvider {
    String name = "AZURE_KEY_VAULT";
    private final String azureKeyVaultDomainName = "vault.azure.net";
    private final String rsaEncryptionAlgorithmWithOAEPForAKV = "RSA-OAEP";
    private final byte[] firstVersion = new byte[]{1};
    private KeyVaultClient keyVaultClient;
    private KeyVaultCredential credential;

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public SQLServerColumnEncryptionAzureKeyVaultProvider(SQLServerKeyVaultAuthenticationCallback sQLServerKeyVaultAuthenticationCallback, ExecutorService executorService) throws SQLServerException {
        if (null == sQLServerKeyVaultAuthenticationCallback) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_NullValue"));
            Object[] objectArray = new Object[]{"SQLServerKeyVaultAuthenticationCallback"};
            throw new SQLServerException(messageFormat.format(objectArray), null);
        }
        this.credential = new KeyVaultCredential(sQLServerKeyVaultAuthenticationCallback);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        this.keyVaultClient = new KeyVaultClientImpl(httpClientBuilder, executorService, (CloudCredentials)this.credential);
    }

    @Override
    public byte[] decryptColumnEncryptionKey(String string, String string2, byte[] byArray) throws SQLServerException {
        this.ValidateNonEmptyAKVPath(string);
        if (null == byArray) {
            throw new SQLServerException(SQLServerException.getErrString("R_NullEncryptedColumnEncryptionKey"), null);
        }
        if (0 == byArray.length) {
            throw new SQLServerException(SQLServerException.getErrString("R_EmptyEncryptedColumnEncryptionKey"), null);
        }
        string2 = this.validateEncryptionAlgorithm(string2);
        int n = this.getAKVKeySize(string);
        if (byArray[0] != this.firstVersion[0]) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidEcryptionAlgorithmVersion"));
            Object[] objectArray = new Object[]{String.format("%02X ", byArray[0]), String.format("%02X ", this.firstVersion[0])};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        int n2 = this.firstVersion.length;
        short s = this.convertTwoBytesToShort(byArray, n2);
        short s2 = this.convertTwoBytesToShort(byArray, n2 += 2);
        n2 += 2;
        n2 += s;
        if (s2 != n) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_AKVKeyLengthError"));
            Object[] objectArray = new Object[]{s2, n, string};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        int n3 = byArray.length - n2 - s2;
        if (n3 != n) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_AKVSignatureLengthError"));
            Object[] objectArray = new Object[]{n3, n, string};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        byte[] byArray2 = new byte[s2];
        System.arraycopy(byArray, n2, byArray2, 0, s2);
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, n2 += s2, byArray3, 0, n3);
        byte[] byArray4 = new byte[byArray.length - byArray3.length];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length - byArray3.length);
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SQLServerException(SQLServerException.getErrString("R_NoSHA256Algorithm"), null);
        }
        messageDigest.update(byArray4);
        byte[] byArray5 = messageDigest.digest();
        if (null == byArray5) {
            throw new SQLServerException(SQLServerException.getErrString("R_HashNull"), null);
        }
        if (!this.AzureKeyVaultVerifySignature(byArray5, byArray3, string)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_CEKSignatureNotMatchCMK"));
            Object[] objectArray = new Object[]{string};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        byte[] byArray6 = this.AzureKeyVaultUnWrap(string, string2, byArray2);
        return byArray6;
    }

    private short convertTwoBytesToShort(byte[] byArray, int n) throws SQLServerException {
        short s = -1;
        if (n + 1 >= byArray.length) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_ByteToShortConversion"), null, 0, false);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(byArray[n]);
        byteBuffer.put(byArray[n + 1]);
        s = byteBuffer.getShort(0);
        return s;
    }

    @Override
    public byte[] encryptColumnEncryptionKey(String string, String string2, byte[] byArray) throws SQLServerException {
        this.ValidateNonEmptyAKVPath(string);
        if (null == byArray) {
            throw new SQLServerException(SQLServerException.getErrString("R_NullColumnEncryptionKey"), null);
        }
        if (0 == byArray.length) {
            throw new SQLServerException(SQLServerException.getErrString("R_EmptyCEK"), null);
        }
        string2 = this.validateEncryptionAlgorithm(string2);
        int n = this.getAKVKeySize(string);
        byte[] byArray2 = new byte[]{this.firstVersion[0]};
        byte[] byArray3 = null;
        try {
            byArray3 = string.toLowerCase().getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedEncoding"));
            Object[] objectArray = new Object[]{"UTF-16LE"};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        byte[] byArray4 = new byte[]{(byte)((short)byArray3.length & 0xFF), (byte)((short)byArray3.length >> 8 & 0xFF)};
        byte[] byArray5 = this.AzureKeyVaultWrap(string, string2, byArray);
        byte[] byArray6 = new byte[]{(byte)((short)byArray5.length & 0xFF), (byte)((short)byArray5.length >> 8 & 0xFF)};
        if (byArray5.length != n) {
            throw new SQLServerException(SQLServerException.getErrString("R_CipherTextLengthNotMatchRSASize"), null);
        }
        byte[] byArray7 = new byte[byArray2.length + byArray4.length + byArray6.length + byArray3.length + byArray5.length];
        int n2 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray7, 0, byArray2.length);
        System.arraycopy(byArray4, 0, byArray7, n2, byArray4.length);
        System.arraycopy(byArray6, 0, byArray7, n2 += byArray4.length, byArray6.length);
        System.arraycopy(byArray3, 0, byArray7, n2 += byArray6.length, byArray3.length);
        System.arraycopy(byArray5, 0, byArray7, n2 += byArray3.length, byArray5.length);
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SQLServerException(SQLServerException.getErrString("R_NoSHA256Algorithm"), null);
        }
        messageDigest.update(byArray7);
        byte[] byArray8 = messageDigest.digest();
        byte[] byArray9 = null;
        byArray9 = this.AzureKeyVaultSignHashedData(byArray8, string);
        if (byArray9.length != n) {
            throw new SQLServerException(SQLServerException.getErrString("R_SignedHashLengthError"), null);
        }
        if (!this.AzureKeyVaultVerifySignature(byArray8, byArray9, string)) {
            throw new SQLServerException(SQLServerException.getErrString("R_InvalidSignatureComputed"), null);
        }
        int n3 = byArray2.length + byArray6.length + byArray4.length + byArray5.length + byArray3.length + byArray9.length;
        byte[] byArray10 = new byte[n3];
        int n4 = 0;
        System.arraycopy(byArray2, 0, byArray10, n4, byArray2.length);
        System.arraycopy(byArray4, 0, byArray10, n4 += byArray2.length, byArray4.length);
        System.arraycopy(byArray6, 0, byArray10, n4 += byArray4.length, byArray6.length);
        System.arraycopy(byArray3, 0, byArray10, n4 += byArray6.length, byArray3.length);
        System.arraycopy(byArray5, 0, byArray10, n4 += byArray3.length, byArray5.length);
        System.arraycopy(byArray9, 0, byArray10, n4 += byArray5.length, byArray9.length);
        return byArray10;
    }

    private String validateEncryptionAlgorithm(String string) throws SQLServerException {
        if (null == string) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_NullKeyEncryptionAlgorithm"), null, 0, false);
        }
        if (string.equalsIgnoreCase("RSA_OAEP")) {
            string = "RSA-OAEP";
        }
        if (!"RSA-OAEP".equalsIgnoreCase(string.trim())) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidKeyEncryptionAlgorithm"));
            Object[] objectArray = new Object[]{string, "RSA-OAEP"};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        return string;
    }

    private void ValidateNonEmptyAKVPath(String string) throws SQLServerException {
        if (null == string || string.trim().isEmpty()) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_AKVPathNull"));
            Object[] objectArray = new Object[]{string};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_AKVURLInvalid"));
            Object[] objectArray = new Object[]{string};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        if (!uRI.getHost().toLowerCase().endsWith("vault.azure.net")) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_AKVMasterKeyPathInvalid"));
            Object[] objectArray = new Object[]{string};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
    }

    private byte[] AzureKeyVaultWrap(String string, String string2, byte[] byArray) throws SQLServerException {
        if (null == byArray) {
            throw new SQLServerException(SQLServerException.getErrString("R_CEKNull"), null);
        }
        KeyOperationResult keyOperationResult = null;
        try {
            keyOperationResult = (KeyOperationResult)this.keyVaultClient.wrapKeyAsync(string, string2, byArray).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new SQLServerException(SQLServerException.getErrString("R_EncryptCEKError"), null);
        }
        return keyOperationResult.getResult();
    }

    private byte[] AzureKeyVaultUnWrap(String string, String string2, byte[] byArray) throws SQLServerException {
        KeyOperationResult keyOperationResult;
        if (null == byArray) {
            throw new SQLServerException(SQLServerException.getErrString("R_EncryptedCEKNull"), null);
        }
        if (0 == byArray.length) {
            throw new SQLServerException(SQLServerException.getErrString("R_EmptyEncryptedCEK"), null);
        }
        try {
            keyOperationResult = (KeyOperationResult)this.keyVaultClient.unwrapKeyAsync(string, string2, byArray).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new SQLServerException(SQLServerException.getErrString("R_DecryptCEKError"), null);
        }
        return keyOperationResult.getResult();
    }

    private byte[] AzureKeyVaultSignHashedData(byte[] byArray, String string) throws SQLServerException {
        assert (null != byArray && 0 != byArray.length);
        KeyOperationResult keyOperationResult = null;
        try {
            keyOperationResult = (KeyOperationResult)this.keyVaultClient.signAsync(string, "RS256", byArray).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new SQLServerException(SQLServerException.getErrString("R_GenerateSignature"), null);
        }
        return keyOperationResult.getResult();
    }

    private boolean AzureKeyVaultVerifySignature(byte[] byArray, byte[] byArray2, String string) throws SQLServerException {
        assert (null != byArray && 0 != byArray.length);
        assert (null != byArray2 && 0 != byArray2.length);
        boolean bl = false;
        try {
            bl = (Boolean)this.keyVaultClient.verifyAsync(string, "RS256", byArray, byArray2).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new SQLServerException(SQLServerException.getErrString("R_VerifySignature"), null);
        }
        return bl;
    }

    private int getAKVKeySize(String string) throws SQLServerException {
        KeyBundle keyBundle = null;
        try {
            keyBundle = (KeyBundle)this.keyVaultClient.getKeyAsync(string).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new SQLServerException(SQLServerException.getErrString("R_GetAKVKeySize"), null);
        }
        if (!keyBundle.getKey().getKty().equalsIgnoreCase("RSA") && !keyBundle.getKey().getKty().equalsIgnoreCase("RSA-HSM")) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_NonRSAKey"));
            Object[] objectArray = new Object[]{keyBundle.getKey().getKty()};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        return keyBundle.getKey().getN().length;
    }
}

