/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CekTableEntry;
import com.microsoft.sqlserver.jdbc.CryptoMetadata;
import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVExecuteOp;
import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.ISQLServerDataRecord;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDataTable;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerSQLXML;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.SQLServerStatementColumnEncryptionSetting;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.StreamRetValue;
import com.microsoft.sqlserver.jdbc.StreamSetterArgs;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TVP;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.Locale;
import microsoft.sql.DateTimeOffset;

final class Parameter {
    private TypeInfo typeInfo;
    CryptoMetadata cryptoMeta = null;
    private boolean shouldHonorAEForParameter = false;
    private boolean userProvidesPrecision = false;
    private boolean userProvidesScale = false;
    private String typeDefinition = null;
    boolean renewDefinition = false;
    private JDBCType jdbcTypeSetByUser = null;
    private int valueLength = 0;
    private boolean forceEncryption = false;
    int scale = 0;
    private int outScale = 4;
    private String name;
    private DTV getterDTV;
    private DTV registeredOutDTV = null;
    private DTV setterDTV = null;
    private DTV inputDTV = null;

    TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    final CryptoMetadata getCryptoMetadata() {
        return this.cryptoMeta;
    }

    Parameter(boolean bl) {
        this.shouldHonorAEForParameter = bl;
    }

    boolean isOutput() {
        return null != this.registeredOutDTV;
    }

    JDBCType getJdbcType() throws SQLServerException {
        return null != this.inputDTV ? this.inputDTV.getJdbcType() : JDBCType.UNKNOWN;
    }

    private static JDBCType getSSPAUJDBCType(JDBCType jDBCType) {
        switch (jDBCType) {
            case CHAR: {
                return JDBCType.NCHAR;
            }
            case VARCHAR: {
                return JDBCType.NVARCHAR;
            }
            case LONGVARCHAR: {
                return JDBCType.LONGNVARCHAR;
            }
            case CLOB: {
                return JDBCType.NCLOB;
            }
        }
        return jDBCType;
    }

    void registerForOutput(JDBCType jDBCType, SQLServerConnection sQLServerConnection) throws SQLServerException {
        if (JDBCType.DATETIMEOFFSET == jDBCType && !sQLServerConnection.isKatmaiOrLater()) {
            throw new SQLServerException(SQLServerException.getErrString("R_notSupported"), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET, null);
        }
        if (sQLServerConnection.sendStringParametersAsUnicode()) {
            if (this.shouldHonorAEForParameter) {
                this.setJdbcTypeSetByUser(jDBCType);
            }
            jDBCType = Parameter.getSSPAUJDBCType(jDBCType);
        }
        this.registeredOutDTV = new DTV();
        this.registeredOutDTV.setJdbcType(jDBCType);
        if (null == this.setterDTV) {
            this.inputDTV = this.registeredOutDTV;
        }
        this.resetOutputValue();
    }

    int getOutScale() {
        return this.outScale;
    }

    void setOutScale(int n) {
        this.outScale = n;
        this.userProvidesScale = true;
    }

    final Parameter cloneForBatch() {
        Parameter parameter = new Parameter(this.shouldHonorAEForParameter);
        parameter.typeInfo = this.typeInfo;
        parameter.typeDefinition = this.typeDefinition;
        parameter.outScale = this.outScale;
        parameter.name = this.name;
        parameter.getterDTV = this.getterDTV;
        parameter.registeredOutDTV = this.registeredOutDTV;
        parameter.setterDTV = this.setterDTV;
        parameter.inputDTV = this.inputDTV;
        parameter.cryptoMeta = this.cryptoMeta;
        parameter.jdbcTypeSetByUser = this.jdbcTypeSetByUser;
        parameter.valueLength = this.valueLength;
        parameter.userProvidesPrecision = this.userProvidesPrecision;
        parameter.userProvidesScale = this.userProvidesScale;
        return parameter;
    }

    final void skipValue(TDSReader tDSReader, boolean bl) throws SQLServerException {
        if (null == this.getterDTV) {
            this.getterDTV = new DTV();
        }
        this.deriveTypeInfo(tDSReader);
        this.getterDTV.skipValue(this.typeInfo, tDSReader, bl);
    }

    final void skipRetValStatus(TDSReader tDSReader) throws SQLServerException {
        StreamRetValue streamRetValue = new StreamRetValue();
        streamRetValue.setFromTDS(tDSReader);
    }

    void clearInputValue() {
        this.setterDTV = null;
        this.inputDTV = this.registeredOutDTV;
    }

    void resetOutputValue() {
        this.getterDTV = null;
        this.typeInfo = null;
    }

    void deriveTypeInfo(TDSReader tDSReader) throws SQLServerException {
        if (null == this.typeInfo) {
            this.typeInfo = TypeInfo.getInstance(tDSReader, true);
            if (this.shouldHonorAEForParameter && this.typeInfo.isEncrypted()) {
                CekTableEntry cekTableEntry = this.cryptoMeta.getCekTableEntry();
                this.cryptoMeta = new StreamRetValue().getCryptoMetadata(tDSReader);
                this.cryptoMeta.setCekTableEntry(cekTableEntry);
            }
        }
    }

    void setFromReturnStatus(int n, SQLServerConnection sQLServerConnection) throws SQLServerException {
        if (null == this.getterDTV) {
            this.getterDTV = new DTV();
        }
        this.getterDTV.setValue(null, JDBCType.INTEGER, new Integer(n), JavaType.INTEGER, null, null, null, sQLServerConnection, this.getForceEncryption());
    }

    void setValue(JDBCType jDBCType, Object object, JavaType javaType, StreamSetterArgs streamSetterArgs, Calendar calendar, Integer n, Integer n2, SQLServerConnection sQLServerConnection, boolean bl, SQLServerStatementColumnEncryptionSetting sQLServerStatementColumnEncryptionSetting, int n3, String string, String string2) throws SQLServerException {
        Object object2;
        Object object3;
        if (this.shouldHonorAEForParameter) {
            this.userProvidesPrecision = false;
            this.userProvidesScale = false;
            if (null != n) {
                this.userProvidesPrecision = true;
            }
            if (null != n2) {
                this.userProvidesScale = true;
            }
            if (!(this.isOutput() || JavaType.SHORT != javaType || JDBCType.TINYINT != jDBCType && JDBCType.SMALLINT != jDBCType)) {
                if ((Short)object >= 0 && (Short)object <= 255) {
                    object = ((Short)object).byteValue();
                    javaType = JavaType.of(object);
                    jDBCType = javaType.getJDBCType(SSType.UNKNOWN, jDBCType);
                } else if (JDBCType.TINYINT == jDBCType) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidDataForAE"));
                    Object[] objectArray = new Object[]{javaType.toString().toLowerCase(Locale.ENGLISH), jDBCType.toString().toLowerCase(Locale.ENGLISH)};
                    throw new SQLServerException(messageFormat.format(objectArray), null);
                }
            }
        }
        if (bl && !Util.shouldHonorAEForParameters(sQLServerStatementColumnEncryptionSetting, sQLServerConnection)) {
            object3 = new MessageFormat(SQLServerException.getErrString("R_ForceEncryptionTrue_HonorAEFalse"));
            object2 = new Object[]{n3, string};
            SQLServerException.makeFromDriverError(sQLServerConnection, this, ((Format)object3).format(object2), null, true);
        }
        if (!(JDBCType.DATETIMEOFFSET != jDBCType && JavaType.DATETIMEOFFSET != javaType || sQLServerConnection.isKatmaiOrLater())) {
            throw new SQLServerException(SQLServerException.getErrString("R_notSupported"), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET, null);
        }
        if (JavaType.TVP == javaType) {
            object3 = null;
            if (null == object) {
                object3 = new TVP(string2);
            } else if (object instanceof SQLServerDataTable) {
                object3 = new TVP(string2, (SQLServerDataTable)object);
            } else if (object instanceof ResultSet) {
                if (sQLServerConnection.getSelectMethod().equalsIgnoreCase("cursor") && object instanceof SQLServerResultSet) {
                    object2 = (SQLServerStatement)((SQLServerResultSet)object).getStatement();
                    if (sQLServerConnection.equals(((SQLServerStatement)object2).connection)) {
                        if (Locale.getDefault().getLanguage() == Locale.ENGLISH.getLanguage()) {
                            throw new SQLServerException(SQLServerException.getErrString("R_invalidServerCursorForTVP"), null);
                        }
                        throw new SQLServerException(SQLServerException.getErrString("R_notSupported"), null, 0, null);
                    }
                }
                object3 = new TVP(string2, (ResultSet)object);
            } else if (object instanceof ISQLServerDataRecord) {
                object3 = new TVP(string2, (ISQLServerDataRecord)object);
            } else {
                object2 = new MessageFormat(SQLServerException.getErrString("R_TVPInvalidValue"));
                Object[] objectArray = new Object[]{n3};
                throw new SQLServerException(((Format)object2).format(objectArray), null);
            }
            if (!((TVP)object3).isNull() && 0 == ((TVP)object3).getTVPColumnCount()) {
                throw new SQLServerException(SQLServerException.getErrString("R_TVPEmptyMetadata"), null);
            }
            this.name = ((TVP)object3).getTVPName();
            object = object3;
        }
        if (this.shouldHonorAEForParameter) {
            this.setForceEncryption(bl);
            if (!this.isOutput() || this.jdbcTypeSetByUser == null) {
                this.setJdbcTypeSetByUser(jDBCType);
            }
            if (!jDBCType.isTextual() && !jDBCType.isBinary() || !this.isOutput() || this.valueLength == 0) {
                this.valueLength = Util.getValueLengthBaseOnJavaType(object, javaType, n, n2, jDBCType);
            }
            if (null != n2) {
                this.outScale = n2;
            }
        }
        if (sQLServerConnection.sendStringParametersAsUnicode() && (JavaType.STRING == javaType || JavaType.READER == javaType || JavaType.CLOB == javaType)) {
            jDBCType = Parameter.getSSPAUJDBCType(jDBCType);
        }
        object3 = new DTV();
        ((DTV)object3).setValue(sQLServerConnection.getDatabaseCollation(), jDBCType, object, javaType, streamSetterArgs, calendar, n2, sQLServerConnection, bl);
        this.inputDTV = this.setterDTV = object3;
    }

    boolean isNull() {
        if (null != this.getterDTV) {
            return this.getterDTV.isNull();
        }
        return false;
    }

    boolean isValueGotten() {
        return null != this.getterDTV;
    }

    Object getValue(JDBCType jDBCType, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TDSReader tDSReader) throws SQLServerException {
        if (null == this.getterDTV) {
            this.getterDTV = new DTV();
        }
        this.deriveTypeInfo(tDSReader);
        return this.getterDTV.getValue(jDBCType, this.outScale, inputStreamGetterArgs, calendar, this.typeInfo, this.cryptoMeta, tDSReader);
    }

    int getInt(TDSReader tDSReader) throws SQLServerException {
        Integer n = (Integer)this.getValue(JDBCType.INTEGER, null, null, tDSReader);
        return null != n ? n : 0;
    }

    String getTypeDefinition(SQLServerConnection sQLServerConnection, TDSReader tDSReader) throws SQLServerException {
        if (null == this.inputDTV) {
            return null;
        }
        this.inputDTV.executeOp(new GetTypeDefinitionOp(this, sQLServerConnection));
        return this.typeDefinition;
    }

    void sendByRPC(TDSWriter tDSWriter, SQLServerConnection sQLServerConnection) throws SQLServerException {
        assert (null != this.inputDTV) : "Parameter was neither set nor registered";
        try {
            this.inputDTV.sendCryptoMetaData(this.cryptoMeta, tDSWriter);
            this.inputDTV.jdbcTypeSetByUser(this.getJdbcTypeSetByUser(), this.getValueLength());
            this.inputDTV.sendByRPC(this.name, null, sQLServerConnection.getDatabaseCollation(), this.valueLength, this.isOutput() ? this.outScale : this.scale, this.isOutput(), tDSWriter, sQLServerConnection);
        }
        finally {
            this.inputDTV.sendCryptoMetaData(null, tDSWriter);
        }
        if (JavaType.INPUTSTREAM == this.inputDTV.getJavaType() || JavaType.READER == this.inputDTV.getJavaType()) {
            this.setterDTV = null;
            this.inputDTV = null;
        }
    }

    JDBCType getJdbcTypeSetByUser() {
        return this.jdbcTypeSetByUser;
    }

    void setJdbcTypeSetByUser(JDBCType jDBCType) {
        this.jdbcTypeSetByUser = jDBCType;
    }

    int getValueLength() {
        return this.valueLength;
    }

    void setValueLength(int n) {
        this.valueLength = n;
        this.userProvidesPrecision = true;
    }

    boolean getForceEncryption() {
        return this.forceEncryption;
    }

    void setForceEncryption(boolean bl) {
        this.forceEncryption = bl;
    }

    final class GetTypeDefinitionOp
    extends DTVExecuteOp {
        private static final String NVARCHAR_MAX = "nvarchar(max)";
        private static final String NVARCHAR_4K = "nvarchar(4000)";
        private static final String NTEXT = "ntext";
        private static final String VARCHAR_MAX = "varchar(max)";
        private static final String VARCHAR_8K = "varchar(8000)";
        private static final String TEXT = "text";
        private static final String VARBINARY_MAX = "varbinary(max)";
        private static final String VARBINARY_8K = "varbinary(8000)";
        private static final String IMAGE = "image";
        private final Parameter param;
        private final SQLServerConnection con;

        GetTypeDefinitionOp(Parameter parameter2, SQLServerConnection sQLServerConnection) {
            this.param = parameter2;
            this.con = sQLServerConnection;
        }

        private void setTypeDefinition(DTV dTV) {
            switch (dTV.getJdbcType()) {
                case TINYINT: {
                    this.param.typeDefinition = SSType.TINYINT.toString();
                    break;
                }
                case SMALLINT: {
                    this.param.typeDefinition = SSType.SMALLINT.toString();
                    break;
                }
                case INTEGER: {
                    this.param.typeDefinition = SSType.INTEGER.toString();
                    break;
                }
                case BIGINT: {
                    this.param.typeDefinition = SSType.BIGINT.toString();
                    break;
                }
                case REAL: {
                    if (this.param.shouldHonorAEForParameter && null != Parameter.this.jdbcTypeSetByUser && (null != this.param.getCryptoMetadata() || !this.param.renewDefinition)) {
                        this.param.typeDefinition = SSType.REAL.toString();
                        break;
                    }
                }
                case FLOAT: 
                case DOUBLE: {
                    this.param.typeDefinition = SSType.FLOAT.toString();
                    break;
                }
                case DECIMAL: 
                case NUMERIC: {
                    Integer n;
                    if (Parameter.this.scale > 38) {
                        Parameter.this.scale = 38;
                    }
                    if (null != (n = dTV.getScale()) && Parameter.this.scale < n) {
                        Parameter.this.scale = n;
                    }
                    if (this.param.isOutput() && Parameter.this.scale < this.param.getOutScale()) {
                        Parameter.this.scale = this.param.getOutScale();
                    }
                    if (this.param.shouldHonorAEForParameter && null != Parameter.this.jdbcTypeSetByUser && (null != this.param.getCryptoMetadata() || !this.param.renewDefinition)) {
                        if (0 == Parameter.this.valueLength) {
                            if (!Parameter.this.isOutput()) {
                                this.param.typeDefinition = "decimal(18, " + Parameter.this.scale + ")";
                            }
                        } else if (18 >= Parameter.this.valueLength) {
                            this.param.typeDefinition = "decimal(18," + Parameter.this.scale + ")";
                            if (18 < Parameter.this.valueLength + Parameter.this.scale) {
                                this.param.typeDefinition = "decimal(" + (18 + Parameter.this.scale) + "," + Parameter.this.scale + ")";
                            }
                        } else {
                            this.param.typeDefinition = "decimal(38," + Parameter.this.scale + ")";
                        }
                        if (Parameter.this.isOutput()) {
                            this.param.typeDefinition = "decimal(38, " + Parameter.this.scale + ")";
                        }
                        if (!Parameter.this.userProvidesPrecision) break;
                        this.param.typeDefinition = "decimal(" + Parameter.this.valueLength + "," + Parameter.this.scale + ")";
                        break;
                    }
                    this.param.typeDefinition = "decimal(38," + Parameter.this.scale + ")";
                    break;
                }
                case MONEY: {
                    this.param.typeDefinition = SSType.MONEY.toString();
                    break;
                }
                case SMALLMONEY: {
                    this.param.typeDefinition = SSType.SMALLMONEY.toString();
                    break;
                }
                case BIT: 
                case BOOLEAN: {
                    this.param.typeDefinition = SSType.BIT.toString();
                    break;
                }
                case LONGVARBINARY: 
                case BLOB: {
                    this.param.typeDefinition = VARBINARY_MAX;
                    break;
                }
                case BINARY: 
                case VARBINARY: {
                    if (VARBINARY_MAX == this.param.typeDefinition || IMAGE == this.param.typeDefinition) break;
                    if (this.param.shouldHonorAEForParameter && null != Parameter.this.jdbcTypeSetByUser && (null != this.param.getCryptoMetadata() || !this.param.renewDefinition)) {
                        if (0 == Parameter.this.valueLength) {
                            this.param.typeDefinition = "varbinary";
                        } else {
                            this.param.typeDefinition = "varbinary(" + Parameter.this.valueLength + ")";
                        }
                        if (JDBCType.LONGVARBINARY != Parameter.this.jdbcTypeSetByUser) break;
                        this.param.typeDefinition = VARBINARY_MAX;
                        break;
                    }
                    this.param.typeDefinition = VARBINARY_8K;
                    break;
                }
                case DATE: {
                    this.param.typeDefinition = this.con.isKatmaiOrLater() ? SSType.DATE.toString() : SSType.DATETIME.toString();
                    break;
                }
                case TIME: {
                    if (this.param.shouldHonorAEForParameter && (null != this.param.getCryptoMetadata() || !this.param.renewDefinition)) {
                        if (Parameter.this.userProvidesScale) {
                            this.param.typeDefinition = SSType.TIME.toString() + "(" + Parameter.this.outScale + ")";
                            break;
                        }
                        this.param.typeDefinition = (this.param.typeDefinition = SSType.TIME.toString() + "(" + Parameter.this.valueLength + ")");
                        break;
                    }
                    this.param.typeDefinition = this.con.getSendTimeAsDatetime() ? SSType.DATETIME.toString() : SSType.TIME.toString();
                    break;
                }
                case TIMESTAMP: {
                    if (this.param.shouldHonorAEForParameter && (null != this.param.getCryptoMetadata() || !this.param.renewDefinition)) {
                        if (Parameter.this.userProvidesScale) {
                            this.param.typeDefinition = this.con.isKatmaiOrLater() ? SSType.DATETIME2.toString() + "(" + Parameter.this.outScale + ")" : SSType.DATETIME.toString();
                            break;
                        }
                        this.param.typeDefinition = this.con.isKatmaiOrLater() ? SSType.DATETIME2.toString() + "(" + Parameter.this.valueLength + ")" : SSType.DATETIME.toString();
                        break;
                    }
                    this.param.typeDefinition = this.con.isKatmaiOrLater() ? SSType.DATETIME2.toString() : SSType.DATETIME.toString();
                    break;
                }
                case DATETIME: {
                    this.param.typeDefinition = SSType.DATETIME.toString();
                    if (!this.param.shouldHonorAEForParameter) {
                        if (!this.param.isOutput()) break;
                        this.param.typeDefinition = SSType.DATETIME2.toString() + "(" + Parameter.this.outScale + ")";
                        break;
                    }
                    if (null != this.param.getCryptoMetadata() || !this.param.renewDefinition || !this.param.isOutput()) break;
                    this.param.typeDefinition = SSType.DATETIME2.toString() + "(" + Parameter.this.outScale + ")";
                    break;
                }
                case SMALLDATETIME: {
                    this.param.typeDefinition = SSType.SMALLDATETIME.toString();
                    break;
                }
                case TIME_WITH_TIMEZONE: 
                case TIMESTAMP_WITH_TIMEZONE: 
                case DATETIMEOFFSET: {
                    if (this.param.shouldHonorAEForParameter && (null != this.param.getCryptoMetadata() || !this.param.renewDefinition)) {
                        if (Parameter.this.userProvidesScale) {
                            this.param.typeDefinition = SSType.DATETIMEOFFSET.toString() + "(" + Parameter.this.outScale + ")";
                            break;
                        }
                        this.param.typeDefinition = SSType.DATETIMEOFFSET.toString() + "(" + Parameter.this.valueLength + ")";
                        break;
                    }
                    this.param.typeDefinition = SSType.DATETIMEOFFSET.toString();
                    break;
                }
                case LONGVARCHAR: 
                case CLOB: {
                    this.param.typeDefinition = VARCHAR_MAX;
                    break;
                }
                case CHAR: 
                case VARCHAR: {
                    if (VARCHAR_MAX == this.param.typeDefinition || TEXT == this.param.typeDefinition) break;
                    if (this.param.shouldHonorAEForParameter && null != Parameter.this.jdbcTypeSetByUser && (null != this.param.getCryptoMetadata() || !this.param.renewDefinition)) {
                        if (0 == Parameter.this.valueLength) {
                            this.param.typeDefinition = "varchar";
                            break;
                        }
                        this.param.typeDefinition = "varchar(" + Parameter.this.valueLength + ")";
                        if (8000 > Parameter.this.valueLength) break;
                        this.param.typeDefinition = VARCHAR_MAX;
                        break;
                    }
                    this.param.typeDefinition = VARCHAR_8K;
                    break;
                }
                case LONGNVARCHAR: {
                    if (this.param.shouldHonorAEForParameter && (null != this.param.getCryptoMetadata() || !this.param.renewDefinition)) {
                        if (null != Parameter.this.jdbcTypeSetByUser && (Parameter.this.jdbcTypeSetByUser == JDBCType.VARCHAR || Parameter.this.jdbcTypeSetByUser == JDBCType.CHAR || Parameter.this.jdbcTypeSetByUser == JDBCType.LONGVARCHAR)) {
                            if (0 == Parameter.this.valueLength) {
                                this.param.typeDefinition = "varchar";
                            } else if (8000 < Parameter.this.valueLength) {
                                this.param.typeDefinition = VARCHAR_MAX;
                            } else {
                                this.param.typeDefinition = "varchar(" + Parameter.this.valueLength + ")";
                            }
                            if (Parameter.this.jdbcTypeSetByUser != JDBCType.LONGVARCHAR) break;
                            this.param.typeDefinition = VARCHAR_MAX;
                            break;
                        }
                        if (null != Parameter.this.jdbcTypeSetByUser && (Parameter.this.jdbcTypeSetByUser == JDBCType.NVARCHAR || Parameter.this.jdbcTypeSetByUser == JDBCType.LONGNVARCHAR)) {
                            if (0 == Parameter.this.valueLength) {
                                this.param.typeDefinition = "nvarchar";
                            } else if (4000 < Parameter.this.valueLength) {
                                this.param.typeDefinition = NVARCHAR_MAX;
                            } else {
                                this.param.typeDefinition = "nvarchar(" + Parameter.this.valueLength + ")";
                            }
                            if (Parameter.this.jdbcTypeSetByUser != JDBCType.LONGNVARCHAR) break;
                            this.param.typeDefinition = NVARCHAR_MAX;
                            break;
                        }
                        if (0 == Parameter.this.valueLength) {
                            this.param.typeDefinition = "nvarchar";
                            break;
                        }
                        this.param.typeDefinition = "nvarchar(" + Parameter.this.valueLength + ")";
                        if (8000 > Parameter.this.valueLength) break;
                        this.param.typeDefinition = NVARCHAR_MAX;
                        break;
                    }
                    this.param.typeDefinition = NVARCHAR_MAX;
                    break;
                }
                case NCLOB: {
                    this.param.typeDefinition = NVARCHAR_MAX;
                    break;
                }
                case NCHAR: 
                case NVARCHAR: {
                    if (NVARCHAR_MAX == this.param.typeDefinition || NTEXT == this.param.typeDefinition) break;
                    if (this.param.shouldHonorAEForParameter && (null != this.param.getCryptoMetadata() || !this.param.renewDefinition)) {
                        if (null != Parameter.this.jdbcTypeSetByUser && (Parameter.this.jdbcTypeSetByUser == JDBCType.VARCHAR || Parameter.this.jdbcTypeSetByUser == JDBCType.CHAR || JDBCType.LONGVARCHAR == Parameter.this.jdbcTypeSetByUser)) {
                            if (0 == Parameter.this.valueLength) {
                                this.param.typeDefinition = "varchar";
                            } else {
                                this.param.typeDefinition = "varchar(" + Parameter.this.valueLength + ")";
                                if (8000 <= Parameter.this.valueLength) {
                                    this.param.typeDefinition = VARCHAR_MAX;
                                }
                            }
                            if (JDBCType.LONGVARCHAR != Parameter.this.jdbcTypeSetByUser) break;
                            this.param.typeDefinition = VARCHAR_MAX;
                            break;
                        }
                        if (null != Parameter.this.jdbcTypeSetByUser && (Parameter.this.jdbcTypeSetByUser == JDBCType.NVARCHAR || Parameter.this.jdbcTypeSetByUser == JDBCType.NCHAR || JDBCType.LONGNVARCHAR == Parameter.this.jdbcTypeSetByUser)) {
                            if (0 == Parameter.this.valueLength) {
                                this.param.typeDefinition = "nvarchar";
                            } else {
                                this.param.typeDefinition = "nvarchar(" + Parameter.this.valueLength + ")";
                                if (8000 <= Parameter.this.valueLength) {
                                    this.param.typeDefinition = NVARCHAR_MAX;
                                }
                            }
                            if (JDBCType.LONGNVARCHAR != Parameter.this.jdbcTypeSetByUser) break;
                            this.param.typeDefinition = NVARCHAR_MAX;
                            break;
                        }
                        if (0 == Parameter.this.valueLength) {
                            this.param.typeDefinition = "nvarchar";
                            break;
                        }
                        this.param.typeDefinition = "nvarchar(" + Parameter.this.valueLength + ")";
                        if (8000 > Parameter.this.valueLength) break;
                        this.param.typeDefinition = NVARCHAR_MAX;
                        break;
                    }
                    this.param.typeDefinition = NVARCHAR_4K;
                    break;
                }
                case SQLXML: {
                    this.param.typeDefinition = SSType.XML.toString();
                    break;
                }
                case TVP: {
                    this.param.typeDefinition = "[" + this.param.name + "] READONLY";
                    break;
                }
                case GUID: {
                    this.param.typeDefinition = SSType.GUID.toString();
                    break;
                }
                default: {
                    assert (false) : "Unexpected JDBC type " + (Object)((Object)dTV.getJdbcType());
                    break;
                }
            }
        }

        @Override
        void execute(DTV dTV, String string) throws SQLServerException {
            if (null != string && string.length() > 4000) {
                dTV.setJdbcType(JDBCType.LONGNVARCHAR);
            }
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Clob clob) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Byte by) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Integer n) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Time time) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Date date) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Timestamp timestamp) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, java.util.Date date) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Calendar calendar) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, LocalDate localDate) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, LocalTime localTime) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, LocalDateTime localDateTime) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, OffsetTime offsetTime) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, OffsetDateTime offsetDateTime) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, DateTimeOffset dateTimeOffset) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Float f) throws SQLServerException {
            Parameter.this.scale = 4;
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Double d) throws SQLServerException {
            Parameter.this.scale = 4;
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, BigDecimal bigDecimal) throws SQLServerException {
            if (null != bigDecimal) {
                Parameter.this.scale = bigDecimal.scale();
                if (Parameter.this.scale < 0) {
                    Parameter.this.scale = 0;
                }
            }
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Long l) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, BigInteger bigInteger) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Short s) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Boolean bl) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, byte[] byArray) throws SQLServerException {
            if (null != byArray && byArray.length > 8000) {
                dTV.setJdbcType(dTV.getJdbcType().isBinary() ? JDBCType.LONGVARBINARY : JDBCType.LONGVARCHAR);
            }
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Blob blob) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, InputStream inputStream) throws SQLServerException {
            StreamSetterArgs streamSetterArgs = dTV.getStreamSetterArgs();
            JDBCType jDBCType = dTV.getJdbcType();
            if (JDBCType.CHAR == jDBCType || JDBCType.VARCHAR == jDBCType || JDBCType.BINARY == jDBCType || JDBCType.VARBINARY == jDBCType) {
                if (streamSetterArgs.getLength() > 8000L) {
                    dTV.setJdbcType(jDBCType.isBinary() ? JDBCType.LONGVARBINARY : JDBCType.LONGVARCHAR);
                } else if (-1L == streamSetterArgs.getLength()) {
                    byte[] byArray = new byte[8001];
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, byArray.length);
                    int n = 0;
                    try {
                        bufferedInputStream.mark(byArray.length);
                        n = bufferedInputStream.read(byArray, 0, byArray.length);
                        if (-1 == n) {
                            n = 0;
                        }
                        bufferedInputStream.reset();
                    }
                    catch (IOException iOException) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                        Object[] objectArray = new Object[]{iOException.toString()};
                        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), "", true);
                    }
                    dTV.setValue(bufferedInputStream, JavaType.INPUTSTREAM);
                    if (n > 8000) {
                        dTV.setJdbcType(jDBCType.isBinary() ? JDBCType.LONGVARBINARY : JDBCType.LONGVARCHAR);
                    } else {
                        streamSetterArgs.setLength(n);
                    }
                }
            }
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Reader reader) throws SQLServerException {
            if (JDBCType.NCHAR == dTV.getJdbcType() || JDBCType.NVARCHAR == dTV.getJdbcType()) {
                StreamSetterArgs streamSetterArgs = dTV.getStreamSetterArgs();
                if (streamSetterArgs.getLength() > 4000L) {
                    dTV.setJdbcType(JDBCType.LONGNVARCHAR);
                } else if (-1L == streamSetterArgs.getLength()) {
                    char[] cArray = new char[4001];
                    BufferedReader bufferedReader = new BufferedReader(reader, cArray.length);
                    int n = 0;
                    try {
                        bufferedReader.mark(cArray.length);
                        n = bufferedReader.read(cArray, 0, cArray.length);
                        if (-1 == n) {
                            n = 0;
                        }
                        bufferedReader.reset();
                    }
                    catch (IOException iOException) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                        Object[] objectArray = new Object[]{iOException.toString()};
                        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), "", true);
                    }
                    dTV.setValue(bufferedReader, JavaType.READER);
                    if (n > 4000) {
                        dTV.setJdbcType(JDBCType.LONGNVARCHAR);
                    } else {
                        streamSetterArgs.setLength(n);
                    }
                }
            }
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, SQLServerSQLXML sQLServerSQLXML) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, TVP tVP) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }
    }
}

