/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import org.odftoolkit.odfdom.type.OdfDataType;
import org.odftoolkit.odfdom.type.W3CSchemaType;

public class ScriptCode
implements OdfDataType {
    private String mScriptCode;

    public ScriptCode(String scriptCode) throws IllegalArgumentException {
        if (scriptCode == null || !scriptCode.matches("^[A-Za-z0-9]{1,8}$")) {
            throw new IllegalArgumentException("parameter can not be null for ScriptCode");
        }
        if (!W3CSchemaType.isValid("token", scriptCode)) {
            throw new IllegalArgumentException("parameter is invalidate for datatype ScriptCode");
        }
        this.mScriptCode = scriptCode;
    }

    public String toString() {
        return this.mScriptCode;
    }

    public static ScriptCode valueOf(String stringValue) throws IllegalArgumentException {
        return new ScriptCode(stringValue);
    }

    public static boolean isValid(String stringValue) {
        if (stringValue == null || !stringValue.matches("^[A-Za-z0-9]{1,8}$")) {
            return false;
        }
        return W3CSchemaType.isValid("token", stringValue);
    }
}

