/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.attribute.dr3d;

import org.odftoolkit.odfdom.OdfAttribute;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.dom.element.chart.ChartPlotAreaElement;
import org.odftoolkit.odfdom.dom.element.dr3d.Dr3dSceneElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;

public class Dr3dLightingModeAttribute
extends OdfAttribute {
    public static final OdfName ATTRIBUTE_NAME = OdfName.get(OdfNamespace.get(OdfNamespaceNames.DR3D), "lighting-mode");

    public Dr3dLightingModeAttribute(OdfFileDom ownerDocument) {
        super(ownerDocument, ATTRIBUTE_NAME);
    }

    public OdfName getOdfName() {
        return ATTRIBUTE_NAME;
    }

    public String getName() {
        return ATTRIBUTE_NAME.getLocalName();
    }

    public void setEnumValue(Value attrValue) {
        this.setValue(attrValue.toString());
    }

    public Value getEnumValue() {
        return Value.enumValueOf(this.getValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(String attrValue) {
        OdfElement parentElement = (OdfElement)((Object)this.getOwnerElement());
        if (parentElement != null) {
            if (parentElement instanceof ChartPlotAreaElement) {
                super.setValue(Boolean.toString(Boolean.parseBoolean(attrValue)));
                return;
            }
            if (parentElement instanceof Dr3dSceneElement) {
                super.setValue(Boolean.toString(Boolean.parseBoolean(attrValue)));
                return;
            }
            if (!(parentElement instanceof StyleGraphicPropertiesElement)) return;
            super.setValue(StyleGraphicPropertiesElement.Dr3dLightingModeAttributeValue.enumValueOf(attrValue).toString());
            return;
        } else {
            super.setValue(attrValue);
        }
    }

    public String getValue() {
        block6: {
            OdfElement parentElement = (OdfElement)((Object)this.getOwnerElement());
            if (parentElement != null) {
                try {
                    if (parentElement instanceof ChartPlotAreaElement) {
                        return String.valueOf(Boolean.parseBoolean(super.getValue()));
                    }
                    if (parentElement instanceof Dr3dSceneElement) {
                        return String.valueOf(Boolean.parseBoolean(super.getValue()));
                    }
                    if (parentElement instanceof StyleGraphicPropertiesElement) {
                        return StyleGraphicPropertiesElement.Dr3dLightingModeAttributeValue.enumValueOf(super.getValue()).toString();
                    }
                    break block6;
                }
                catch (IllegalArgumentException e) {
                    throw new NumberFormatException("the value of dr3d:lighting-mode is not valid");
                }
            }
            return super.getValue();
        }
        return null;
    }

    public String getDefault() {
        return null;
    }

    public boolean hasDefault() {
        return false;
    }

    public boolean isId() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Value {
        DOUBLE_SIDED("double-sided"),
        STANDARD("standard");

        private String mValue;

        private Value(String value) {
            this.mValue = value;
        }

        public String toString() {
            return this.mValue;
        }

        public static Value enumValueOf(String value) {
            for (Value aIter : Value.values()) {
                if (!value.equals(aIter.toString())) continue;
                return aIter;
            }
            return null;
        }
    }
}

