/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.number;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.doc.number.OdfNumber;
import org.odftoolkit.odfdom.doc.number.OdfNumberText;
import org.odftoolkit.odfdom.doc.style.OdfStyleMap;
import org.odftoolkit.odfdom.dom.element.number.NumberNumberStyleElement;
import org.w3c.dom.Node;

public class OdfNumberStyle
extends NumberNumberStyleElement {
    public OdfNumberStyle(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfNumberStyle(OdfFileDom ownerDoc, String format, String styleName) {
        super(ownerDoc);
        this.setStyleNameAttribute(styleName);
        this.buildFromFormat(format);
    }

    public void buildFromFormat(String format) {
        Matcher m;
        Pattern p = Pattern.compile("[#0,.]+");
        if (format != null && !format.equals("") && (m = p.matcher(format)).find()) {
            char ch;
            int pos;
            String preMatch = format.substring(0, m.start());
            String numberSpec = format.substring(m.start(), m.end());
            String postMatch = format.substring(m.end());
            this.emitText(preMatch);
            OdfNumber number = new OdfNumber((OdfFileDom)((Object)this.getOwnerDocument()));
            int nDigits = 0;
            for (pos = 0; pos < numberSpec.length() && (ch = numberSpec.charAt(pos)) != '.'; ++pos) {
                if (ch == ',') {
                    number.setNumberGroupingAttribute(new Boolean(true));
                    continue;
                }
                if (ch != '0') continue;
                ++nDigits;
            }
            number.setNumberMinIntegerDigitsAttribute(nDigits);
            if (pos < numberSpec.length()) {
                number.setNumberDecimalPlacesAttribute(numberSpec.length() - (pos + 1));
            }
            this.appendChild((Node)((Object)number));
            this.emitText(postMatch);
        }
    }

    private void emitText(String textBuffer) {
        if (!textBuffer.equals("")) {
            OdfNumberText textElement = new OdfNumberText((OdfFileDom)((Object)this.getOwnerDocument()));
            textElement.setTextContent(textBuffer);
            this.appendChild((Node)((Object)textElement));
        }
    }

    public void setMapPositive(String mapName) {
        OdfStyleMap map = new OdfStyleMap((OdfFileDom)((Object)this.getOwnerDocument()));
        map.setStyleApplyStyleNameAttribute(mapName);
        map.setStyleConditionAttribute("value()>0");
        this.appendChild((Node)((Object)map));
    }

    public void setMapNegative(String mapName) {
        OdfStyleMap map = new OdfStyleMap((OdfFileDom)((Object)this.getOwnerDocument()));
        map.setStyleApplyStyleNameAttribute(mapName);
        map.setStyleConditionAttribute("value()<0");
        this.appendChild((Node)((Object)map));
    }
}

