/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.table;

import java.util.List;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.doc.style.OdfStyle;
import org.odftoolkit.odfdom.doc.table.DomNodeList;
import org.odftoolkit.odfdom.doc.table.OdfCoveredTableCell;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;
import org.odftoolkit.odfdom.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeValueTypeAttribute;
import org.odftoolkit.odfdom.dom.element.table.TableCoveredTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElementBase;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.type.PositiveInteger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfTableRow
extends TableTableRowElement {
    private OdfStyle m_defaultCellStyle;
    private int mCurrentNumberOfColumns = 0;

    public OdfTableRow(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfTable getTable() {
        return this.getAncestorAs(OdfTable.class);
    }

    public Node removeCell(Node remChild) throws DOMException {
        if (remChild instanceof OdfTableCell) {
            OdfTableCell td = (OdfTableCell)((Object)remChild);
            int nColSpan = td.getTableNumberColumnsRepeatedAttribute();
            int nColRepeat = td.getTableNumberColumnsRepeatedAttribute();
            int nColVanish = Math.max(nColSpan, nColRepeat);
            this.mCurrentNumberOfColumns -= nColVanish;
        }
        return super.removeChild(remChild);
    }

    public Node appendCell(Node newChild) throws DOMException {
        OdfCoveredTableCell aOldCoveredCell = null;
        if (newChild instanceof OdfCoveredTableCell && !((OdfCoveredTableCell)((Object)newChild)).isAutoGenerated()) {
            for (Node aTestNode = super.getLastChild(); aTestNode != null; aTestNode = aTestNode.getPreviousSibling()) {
                if (aTestNode instanceof OdfCoveredTableCell) {
                    if (!((OdfCoveredTableCell)((Object)aTestNode)).isAutoGenerated()) break;
                    aOldCoveredCell = (OdfCoveredTableCell)((Object)aTestNode);
                    continue;
                }
                if (aTestNode instanceof OdfTableCell) break;
            }
        }
        Node aNode = null;
        if (aOldCoveredCell != null) {
            ((OdfCoveredTableCell)((Object)newChild)).setNumberRowsSpanned(aOldCoveredCell.getNumberRowsSpanned());
            ((OdfCoveredTableCell)((Object)newChild)).setNumberColumnsSpanned(aOldCoveredCell.getNumberColumnsSpanned());
            aNode = newChild;
            Node nextCovered = aOldCoveredCell.getNextSibling();
            this.replaceChild(newChild, (Node)((Object)aOldCoveredCell));
            int repeated = ((OdfCoveredTableCell)((Object)newChild)).getTableNumberColumnsRepeatedAttribute();
            while (repeated > 1 && nextCovered != null && nextCovered instanceof OdfCoveredTableCell && ((OdfCoveredTableCell)((Object)nextCovered)).isAutoGenerated()) {
                Node removeNode = nextCovered;
                nextCovered = nextCovered.getNextSibling();
                this.removeChild(removeNode);
                --repeated;
                --this.mCurrentNumberOfColumns;
            }
        } else {
            aNode = super.appendChild(newChild);
        }
        if (aNode instanceof OdfTableCell) {
            int count;
            OdfTableCell td = (OdfTableCell)((Object)aNode);
            Integer tableNumberColumnsSpannedAttribute = td.getTableNumberColumnsSpannedAttribute();
            int nColSpan = 0;
            if (tableNumberColumnsSpannedAttribute != null) {
                nColSpan = tableNumberColumnsSpannedAttribute;
            }
            Integer tableNumberColumnsRepeatedAttribute = td.getTableNumberColumnsRepeatedAttribute();
            int nColRepeat = 0;
            if (tableNumberColumnsRepeatedAttribute != null) {
                nColRepeat = tableNumberColumnsRepeatedAttribute;
            }
            int nStartCol = this.mCurrentNumberOfColumns;
            int nColAdd = Math.max(nColSpan, nColRepeat);
            int nEndCol = nStartCol + nColAdd;
            OdfTable table = this.getTable();
            if (table != null && (count = table.getTableColumnCount()) < nEndCol) {
                if (nColRepeat > 1) {
                    table.addTableColumn(nEndCol - count);
                } else {
                    for (int i = 0; i < nEndCol - count; ++i) {
                        table.addTableColumn(1);
                    }
                }
            }
            this.mCurrentNumberOfColumns += nColAdd;
            if (nColSpan > 1) {
                this.appendCoveredCells(nColSpan - 1, td.getTableNumberRowsSpannedAttribute(), aNode);
            }
            this.inheritSpannedCells(nEndCol);
        }
        return aNode;
    }

    private void appendCoveredCells(int nColSpan, int nRowSpan, Node aNode) {
        while (nColSpan > 0) {
            OdfCoveredTableCell aCTC = (OdfCoveredTableCell)((Object)this.getOwnerDocument().createElementNS(TableCoveredTableCellElement.ELEMENT_NAME.getUri(), TableCoveredTableCellElement.ELEMENT_NAME.getQName()));
            aCTC.setNumberColumnsSpanned(new PositiveInteger(nColSpan));
            aCTC.setNumberRowsSpanned(new PositiveInteger(nRowSpan));
            aCTC.setAutoGenerated();
            this.appendChild((Node)((Object)aCTC));
            --nColSpan;
        }
    }

    public void inheritSpannedCells(int nCol) {
        TableTableCellElementBase aUpperCell;
        OdfTableRow aPrevRow = this.getPreviousRow();
        if (aPrevRow == null) {
            return;
        }
        Node aUpperNode = aPrevRow.getCellAt(nCol);
        if (aUpperNode == null) {
            return;
        }
        int nCoveredCellsToAdd = 0;
        int nUpperRowSpan = 1;
        if (aUpperNode instanceof OdfTableCell && (nUpperRowSpan = ((TableTableCellElement)(aUpperCell = (OdfTableCell)((Object)aUpperNode))).getTableNumberRowsSpannedAttribute().intValue()) > 1) {
            nCoveredCellsToAdd = ((TableTableCellElement)aUpperCell).getTableNumberColumnsSpannedAttribute();
        }
        if (aUpperNode instanceof OdfCoveredTableCell && (nUpperRowSpan = ((OdfCoveredTableCell)(aUpperCell = (OdfCoveredTableCell)((Object)aUpperNode))).getNumberRowsSpanned().intValue()) > 1) {
            nCoveredCellsToAdd = ((OdfCoveredTableCell)aUpperCell).getNumberColumnsSpanned().intValue();
        }
        if (nCoveredCellsToAdd == 0) {
            return;
        }
        this.mCurrentNumberOfColumns += nCoveredCellsToAdd;
        this.appendCoveredCells(nCoveredCellsToAdd, nUpperRowSpan - 1, null);
    }

    public OdfTableRow getPreviousRow() {
        for (Node aPrevNode = this.getPreviousSibling(); aPrevNode != null; aPrevNode = aPrevNode.getPreviousSibling()) {
            if (!(aPrevNode instanceof OdfTableRow)) continue;
            return (OdfTableRow)((Object)aPrevNode);
        }
        return null;
    }

    public Node getCellAt(int nCol) {
        for (Node n : new DomNodeList(this.getChildNodes())) {
            if (!(n instanceof OdfTableCell) && !(n instanceof OdfCoveredTableCell)) continue;
            if (nCol == 0) {
                return n;
            }
            nCol -= ((TableTableCellElementBase)((Object)n)).getTableNumberColumnsRepeatedAttribute().intValue();
        }
        return null;
    }

    public void populateStrings(List<String> valueList, List<String> cellStyleList, List<String> paraStyleList) {
        int cellIndex = 0;
        int paraIndex = 0;
        for (String value : valueList) {
            OdfTableCell cell = new OdfTableCell((OdfFileDom)((Object)this.getOwnerDocument()));
            cell.setTableStyleNameAttribute(cellStyleList.get(cellIndex));
            cell.setOfficeTimeValueAttribute(value);
            cell.setOfficeValueTypeAttribute(OfficeValueTypeAttribute.Value.STRING.toString());
            OdfTextParagraph para = new OdfTextParagraph((OdfFileDom)((Object)this.getOwnerDocument()), paraStyleList.get(paraIndex), value);
            cell.appendChild((Node)((Object)para));
            this.appendCell((Node)((Object)cell));
            cellIndex = (cellIndex + 1) % cellStyleList.size();
            paraIndex = (paraIndex + 1) % paraStyleList.size();
        }
    }

    public void setDefaultCellStyle(OdfStyle s) {
        if (this.m_defaultCellStyle != null) {
            this.m_defaultCellStyle.removeStyleUser(this);
        }
        this.m_defaultCellStyle = s;
        if (this.m_defaultCellStyle != null) {
            this.m_defaultCellStyle.addStyleUser(this);
            this.setTableDefaultCellStyleNameAttribute(this.m_defaultCellStyle.getStyleNameAttribute());
        }
    }

    public OdfStyle getDefaultCellStyle() {
        return this.m_defaultCellStyle;
    }
}

