/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.AbstractIscStmtHandle;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.Synchronizable;

class FBStatementFetcher
implements FBFetcher {
    private boolean closed;
    private boolean wasFetched;
    protected final GDSHelper gdsHelper;
    protected final FBObjectListener.FetcherListener fetcherListener;
    protected final int maxRows;
    protected int fetchSize;
    protected final Synchronizable syncProvider;
    protected final AbstractIscStmtHandle stmt;
    private Object[] rowsArray;
    private int size;
    protected byte[][] _nextRow;
    private int rowNum = 0;
    private int rowPosition = 0;
    private boolean isEmpty;
    private boolean isBeforeFirst;
    private boolean isFirst;
    private boolean isLast;
    private boolean isAfterLast;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FBStatementFetcher(GDSHelper gdsHelper, Synchronizable syncProvider, AbstractIscStmtHandle stmth, FBObjectListener.FetcherListener fetcherListener, int maxRows, int fetchSize) throws SQLException {
        this.gdsHelper = gdsHelper;
        this.stmt = stmth;
        this.syncProvider = syncProvider;
        this.fetcherListener = fetcherListener;
        this.maxRows = maxRows;
        this.fetchSize = fetchSize;
        Object object = syncProvider.getSynchronizationObject();
        synchronized (object) {
            if (this.stmt.isAllRowsFetched()) {
                this.rowsArray = (Object[])this.stmt.getRows();
                this.size = this.stmt.size();
            }
        }
    }

    protected byte[][] getNextRow() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this._nextRow;
    }

    protected void setNextRow(byte[][] nextRow) {
        this._nextRow = nextRow;
        if (!this.wasFetched) {
            this.wasFetched = true;
            if (this._nextRow == null) {
                this.isEmpty = true;
            } else {
                this.isBeforeFirst = true;
            }
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        this.setIsBeforeFirst(false);
        this.setIsFirst(false);
        this.setIsLast(false);
        this.setIsAfterLast(false);
        if (this.isEmpty()) {
            return false;
        }
        if (this.getNextRow() == null || this.maxRows != 0 && this.getRowNum() == this.maxRows) {
            this.setIsAfterLast(true);
            this.fetcherListener.allRowsFetched(this);
            this.setRowNum(0);
            return false;
        }
        this.fetcherListener.rowChanged(this, this.getNextRow());
        this.fetch();
        this.setRowNum(this.getRowNum() + 1);
        if (this.getRowNum() == 1) {
            this.setIsFirst(true);
        }
        if (this.getNextRow() == null || this.maxRows != 0 && this.getRowNum() == this.maxRows) {
            this.setIsLast(true);
        }
        return true;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public boolean first() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public boolean last() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public boolean previous() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public boolean relative(int row) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void afterLast() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetch() throws SQLException {
        Object object = this.syncProvider.getSynchronizationObject();
        synchronized (object) {
            int fetchSize;
            this.checkClosed();
            int maxRows = 0;
            if (this.maxRows != 0) {
                maxRows = this.maxRows - this.rowNum;
            }
            if ((fetchSize = this.fetchSize) == 0) {
                fetchSize = 400;
            }
            if (maxRows != 0 && fetchSize > maxRows) {
                fetchSize = maxRows;
            }
            if (!(this.stmt.isAllRowsFetched() || this.rowsArray != null && this.size != this.rowPosition)) {
                try {
                    this.gdsHelper.fetch(this.stmt, fetchSize);
                    this.rowPosition = 0;
                    this.rowsArray = (Object[])this.stmt.getRows();
                    this.size = this.stmt.size();
                }
                catch (GDSException ge) {
                    throw new FBSQLException(ge);
                }
            }
            if (this.rowsArray != null && this.size > this.rowPosition) {
                this.setNextRow((byte[][])this.rowsArray[this.rowPosition]);
                this.rowsArray[this.rowPosition] = null;
                ++this.rowPosition;
            } else {
                this.setNextRow(null);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        this.close(CompletionReason.OTHER);
    }

    @Override
    public void close(CompletionReason completionReason) throws SQLException {
        this.closed = true;
        try {
            this.gdsHelper.closeStatement(this.stmt, false, completionReason.isTransactionEnd());
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
        finally {
            this.fetcherListener.fetcherClosed(this);
        }
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw new FBSQLException("Result set is already closed.");
        }
    }

    @Override
    public int getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(int rowNumValue) {
        this.rowNum = rowNumValue;
    }

    @Override
    public boolean isEmpty() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isEmpty;
    }

    public void setIsEmpty(boolean isEmptyValue) {
        this.isEmpty = isEmptyValue;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isBeforeFirst;
    }

    public void setIsBeforeFirst(boolean isBeforeFirstValue) {
        this.isBeforeFirst = isBeforeFirstValue;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isFirst;
    }

    public void setIsFirst(boolean isFirstValue) {
        this.isFirst = isFirstValue;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isLast;
    }

    public void setIsLast(boolean isLastValue) {
        this.isLast = isLastValue;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isAfterLast;
    }

    public void setIsAfterLast(boolean isAfterLastValue) {
        this.isAfterLast = isAfterLastValue;
    }

    @Override
    public void deleteRow() throws SQLException {
    }

    @Override
    public void insertRow(byte[][] data) throws SQLException {
    }

    @Override
    public void updateRow(byte[][] data) throws SQLException {
    }

    @Override
    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }
}

