/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.penguin.math.statistics;

import org.opengion.penguin.math.statistics.HybsSingleRegression;

public class HybsSquadraticRegression
implements HybsSingleRegression {
    private double c1;
    private double c2;
    private double c3;
    private double rsquare;

    public HybsSquadraticRegression(double[][] dArray) {
        this.train(dArray);
    }

    public HybsSquadraticRegression(double d, double d2, double d3) {
        this.c1 = d;
        this.c2 = d2;
        this.c3 = d3;
    }

    public HybsSquadraticRegression() {
    }

    @Override
    public void train(double[][] dArray) {
        int n = dArray.length;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        for (int i = 0; i < n; ++i) {
            d = dArray[i][0];
            d2 = dArray[i][1];
            d3 = d * d;
            d5 += d;
            d4 += d3;
            d6 += d * d2;
            d7 += d2;
            d8 += d3 * d;
            d9 += d3 * d2;
            d10 += d3 * d3;
        }
        double d11 = d4 - d5 * d5 / (double)n;
        double d12 = d6 - d5 * d7 / (double)n;
        double d13 = d8 - d4 * d5 / (double)n;
        double d14 = d9 - d4 * d7 / (double)n;
        double d15 = d10 - d4 * d4 / (double)n;
        double d16 = d11 * d15 - d13 * d13;
        this.c1 = (d14 * d11 - d12 * d13) / d16;
        this.c2 = (d12 * d15 - d14 * d13) / d16;
        this.c3 = d7 / (double)n - this.c2 * d5 / (double)n - this.c1 * d4 / (double)n;
    }

    @Override
    public void setOption(double[] dArray) {
    }

    public double getC1() {
        return this.c1;
    }

    public double getC2() {
        return this.c2;
    }

    public double getC3() {
        return this.c3;
    }

    @Override
    public double[] getCoefficient() {
        double[] dArray = new double[]{this.c1, this.c2, this.c3};
        return dArray;
    }

    @Override
    public void setCoefficient(double[] dArray) {
        this.c1 = dArray[0];
        this.c2 = dArray[1];
        this.c3 = dArray[2];
    }

    @Override
    public double predict(double d) {
        return this.c1 * d * d + this.c2 * d + this.c3;
    }

    public static void main(String[] stringArray) {
        double[][] dArrayArray = new double[][]{{1.0, 2.3}, {2.0, 5.1}, {3.0, 9.1}, {4.0, 16.2}};
        HybsSquadraticRegression hybsSquadraticRegression = new HybsSquadraticRegression(dArrayArray);
        System.out.println(hybsSquadraticRegression.getC1());
        System.out.println(hybsSquadraticRegression.getC2());
        System.out.println(hybsSquadraticRegression.getC3());
        System.out.println(hybsSquadraticRegression.predict(5.0));
    }
}

