/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.html;

import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.fukurou.util.Attributes;

/**
 * DBTableModelの表示を行うインターフェースです。
 * 各種の表示形式をサポートするには、ViewMarker インターフェースを implements した
 * クラスを作成して、DBTableModel をセットするだけです。
 * ViewMarker 自体は,Controller クラスよりアクセスされます。
 *
 * ViewMarker の実装クラス( implements されたクラス)に対する 各種設定(たとえば、HTMLタグなど)
 * は、個々の実装クラス毎に設定します。
 *
 * @og.group 画面表示
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public interface ViewMarker {

	/**
	 * 内容をクリア(初期化)します。
	 *
	 */
	void clear() ;

	/**
	 * カラムに対するマーカーアトリビュートをセットします。
	 *
	 * @og.rev 4.0.0.0 (2005/08/31) 同一カラムの複数登録を許可します。
	 *
	 * @param	attri	リンクアトリビュート
	 */
	void addAttribute( Attributes attri ) ;

	/**
	 * 内部に DBTableModel をセットします。
	 *
	 * @param  table DBTableModelオブジェクト
	 */
	void setDBTableModel( DBTableModel table ) ;

	/**
	 * 指定の行列に対するマーカー文字列を返します。
	 * この値は,すでにマーカー文字列処理されている為, RendererValue で
	 * 変換する必要はありません。
	 * 引数の value はそのカラムの値として利用されます。この値は、修飾済みの
	 * 値を与えることが可能です。
	 *
	 * @param   row 指定の行
	 * @param   column 指定の列
	 * @param   value カラムの値
	 *
	 * @return  row行，colum列 のマーカー文字列
	 */
	String getMarkerString( int row,int column,String value ) ;
	
	/**
	 * マーカーされたカラム番号の配列を返します。
	 *
	 * これは特殊処理で、Edit機能で、カラム列をキャッシュしているときに、
	 * JSPのソース等の変更時に、変更が反映されない対応を行う場合、
	 * 通常の ViewFormのサブクラスから、Edit専用の ViewForm_HTMLSeqClmTable で
	 * 制御する場合、ViewMarkerのEditMarkerでは、通常非表示（検索の場合）ですが
	 * Editのポップアップ画面に、表示されてしまうのを避けるため、noDisplay に
	 * 強制的にするカラム番号が必要です。
	 * あくまで、暫定処置です。Edit機能を改修するときに、この機能は削除します。
	 *
	 * @og.rev 5.8.6.0 (2015/04/03) 6.0.3.0からの移植
	 *
	 * @return  マーカーされたカラム番号の配列
	 */
	int[] getColumnNos();
}
