/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.util;

/**
 * 共通的に使用される固定値を集約したクラスです。
 *
 * 全変数は、public static final 宣言されています。
 *
 * @og.rev 6.1.0.0 (2014/12/26) 固定値を集約したクラス対応
 * @og.group その他
 *
 * @version  6.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK8.0,
 */
public final class HybsConst {

	/** バッファの初期容量を設定する固定値(通常より若干多い目)。  {@value}  */
	public static final int BUFFER_SMALL  = 100;

	/** バッファの初期容量を設定する固定値(通常より多い目)。  {@value}  */
	public static final int BUFFER_MIDDLE = 200;

	/** バッファの初期容量を設定する固定値(通常より大幅に多い目)。  {@value} */
	public static final int BUFFER_LARGE  = 500;

	/** システム依存の改行記号(String)。	*/
	public static final String CR = System.getProperty("line.separator");

	/** HTMLでの改行記号( &lt;br /&gt; )。	*/
	public static final String BR = "<br />" + CR ;

	/** システム依存のファイルセパレーター文字(char)。	*/
	public static final char FS = System.getProperty("file.separator").charAt(0);

	/** タブ文字(char)。	*/
	public static final char TAB = '\t';

	/**
	 * デフォルトコンストラクターをprivateにして、
	 * オブジェクトの生成をさせないようにする。
	 */
	private HybsConst() {}
}
