/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.process;

import java.io.PrintWriter ;

/**
 * LoggerProcess インターフェース は、AbstractProcess を実行する上で必要となる
 * 各種パラメータを設定します。
 * 特に、データベース接続を使用する場合は、このインターフェースを使用して、
 * データベースコネクションを取得する必要があります。
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public interface LoggerProcess extends HybsProcess {
	/**
	 * ログ出力用のPrintWriterを設定します。
	 * 通常は、引数の -logFile=XXXX で指定しますが、直接 PrintWriter を
	 * 渡す必要があるケース(JSPなどで使用するケース)で使用します。
	 * 引数より、こちらの設定のほうが、優先されます。
	 *
	 * @param	logging	ログ出力用のPrintWriter
	 */
	void setLoggingWriter( final PrintWriter logging ) ;

	/**
	 * 画面表示用のPrintWriterを設定します。
	 * 通常は、引数の -dispFile=XXXX で指定しますが、直接 PrintWriter を
	 * 渡す必要があるケース(JSPなどで使用するケース)で使用します。
	 * 引数より、こちらの設定のほうが、優先されます。
	 *
	 * @param	display	画面表示用のPrintWriter
	 */
	void setDisplayWriter( final PrintWriter display ) ;

	/**
	 * エラーログにメッセージを表示します。
	 * ここに書き込まれたメッセージは、通常ログと、特殊ログの
	 * 両方に書き込まれます。
	 * 特殊ログとは、メール連絡等のことです。
	 *
	 * @param	msg	表示するメッセージ
	 * @param	th	例外オブジェクト
	 */
	void errLog( final String msg,final Throwable th ) ;
}
