<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" >
<script type="text/javascript" src="/gf/jsp/common/jquery/jquery-ui.js?v=1377478812228" ><!-- --></script>
</og:head>
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9100"
	title	= "標準(PLSQL)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<!-- nullCheckの記述は不要です。columnのチェックを行う場合は、個別に記述する必要があります -->
<og:columnCheck command = "{@command}" />


<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<!-- は不要です-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		SELECT	SYSTEM_ID
				,USERID
				,GUIKEY
				,SEQNO
				,NAME_JA
				,FGFAVORITE
				,FGJ
				,UNIQ
		FROM	GEA09
	<og:where>
		<og:and value = "USERID		=	'{@USER.ID}'"		/>
		<og:and value = "FGJ			IN		('0','1')"			/>	
		<og:and value = "SYSTEM_ID		=		'{@SYSTEM_ID}'"		/>	
</og:where>
	<og:appear startKey = "ORDER BY" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,SEQNO,GUIKEY" />
</og:query>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<!-- ここでは、すべてを、update.jsp に転送している為、command属性を設定しています。-->
<og:writeCheck>
	<!--<og:submit  action="COPY"    noWritable="null" />-->
	<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,USERID,GUIKEY,NAME_JA"  />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<!-- サンプルではポップアップを使用するためviewFormTypeはHTMLCustomTableを使用します-->
 
<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ"
/>


</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
