<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6330"
	title	= "ロール切り替え"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<jsp:directive.page import="org.opengion.hayabusa.common.HybsSystem" />
<jsp:directive.page import="org.opengion.hayabusa.resource.UserInfo" />
<jsp:directive.page import="org.opengion.hayabusa.resource.UserInfoFactory" />
<jsp:directive.page import="java.util.Locale" />

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<jsp:scriptlet>
	UserInfo userInfo = (UserInfo)session.getAttribute( HybsSystem.USERINFO_KEY );
	String userID = userInfo.getUserID();
	userInfo.clear();
	session.removeAttribute( HybsSystem.USERINFO_KEY );

	UserInfo userInfoNew = UserInfoFactory.newInstance( userID.toUpperCase(Locale.JAPAN),request.getRemoteAddr(),request.getParameter( "ROLES" ) );
	session.setAttribute( HybsSystem.USERINFO_KEY, userInfoNew );
</jsp:scriptlet>

<a href="javascript:top.location.reload();"><og:message lbl="GFM0041" /></a>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
