<jsp:directive.page pageEncoding="UTF-8" />
<og:query command="{@command}" debug="{@debug}" maxRowCount="0" stopZero="true">
	select * from (
		select	RENDERER,EDITOR,DBTYPE,'' as DTYPE,FGCOM,
				CLM,NAME_JA,TABLE_NAME,SEQNO,
				CLS_NAME,USE_LENGTH,NOT_NULL,
				case	when 
							(
								(
										RENDERER not in ( 'MENU','DBMENU','CHBOX' )
									or	EDITOR   not in ( 'MENU','DBMENU','CHBOX' )
									or	CLS_NAME  != 'VARCHAR2'
								)
								and	(
										CLM like 'FG%'
									or  CLM like 'CD%'
									or  CLM like 'KB%'
								)
								and	(	USE_LENGTH in ( '1','2' )	)
							) then '01 FG,CD,KBで始まるカラムが、MENU 関係ではありません'
						when
							(
								NOT_NULL is null
								and	(
										CLS_NAME = 'NUMBER'
									or	RENDERER in ( 'MENU','DBMENU','CHBOX' )
									or	EDITOR   in ( 'MENU','DBMENU','CHBOX' )
								)
							) then '02 NUMBER型や MENU 関係のカラムに、NOT NULL 指定がありません'
						when
							(
								CLS_NAME  != 'NUMBER'
								and	(
										CLM like 'SU%'
									or  CLM like 'NO%'
									or  CLM like 'KN%'
									or  CLM like 'TK%'
									or  CLM like 'SEQ%'
								)
							) then '03 SU,NO,KN,TK,SEQで始まるカラムが、NUMBER型ではありません'
						when
							(
								CLM like 'NM%'
								and	(
										CLS_NAME  != 'VARCHAR2'
									or	instr( NAME_JA , '名' ) = 0
								)
							) then '04 NMで始まるカラムが、VARCHAR2型でない、または「名」が付いていません'
						when
							(
								CLM like 'DY%'
								and	(
										RENDERER not in ( 'YMD','YMDH','MD','YM','DATE' )
									or	EDITOR   not in ( 'YMD','YMDH','MD','YM','DATE' )
									or	DBTYPE   not in ( 'YMD','YMDH','MD','YM','DATE' )
									or	CLS_NAME  != 'VARCHAR2'
								)
							) then '05 DYで始まるカラムが、日付型ではありません'
						when
							(
						--		regexp_instr( NAME_JA , '[０-９Ａ-Ｚａ-ｚァ-ヶ]' ) > 0
								regexp_instr( NAME_JA , '[０-９Ａ-Ｚａ-ｚ]' ) > 0
							) then '06 カラム名称に全角英数字が使われています'
						else null end as RIYU ,
				SYSTEM_ID,FGJ,UNIQ
			from GF05
			where SYSTEM_ID  = '{@SYSTEM_ID}'
			and   TBLSYU     = '{@TBLSYU}'
			<og:where startKey="and">
				<og:and value="TABLE_NAME like '{@TABLE_NAME}%'" />
				<og:and value="CLM        like '{@CLM}%'" />
			</og:where>
			and   FGCOM		<= '5'
			and   FGJ		= '1'
	)
	where RIYU is not null
	order by SYSTEM_ID,CLM,TABLE_NAME
</og:query>

<!-- UNIQ のみでユニークになるが、安全のため、SYSTEM_IDとTBLSYUだけは条件に加えておく -->
<og:hidden name="SQL" >
	UPDATE GF05 SET
			RENDERER		= [RENDERER],
			EDITOR			= [EDITOR],
			DBTYPE			= [DBTYPE],
			FGCOM			= [FGCOM],
			CLM 			= [CLM],
			NAME_JA 		= [NAME_JA],
			CLS_NAME		= [CLS_NAME],
			USE_LENGTH		= [USE_LENGTH],
			NOT_NULL		= [NOT_NULL],
			BIKO			= [BIKO],
			CDKH			= 'C',
			FGJ				= '1',
			DYUPD			= '{@USER.YMDH}',
			USRUPD			= '{@USER.ID}',
			PGUPD			= '{@GUI.KEY}'
	WHERE SYSTEM_ID	= '{@SYSTEM_ID}'
	AND   TBLSYU	= '{@TBLSYU}'
	AND   UNIQ		= [UNIQ]
</og:hidden>

<og:hidden name="noWritable">SYSTEM_ID,TABLE_NAME,SEQNO,DTYPE</og:hidden>
