/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.tomcat;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.servlets.DefaultServlet;

public class CacheDefaultServlet
extends DefaultServlet {
    private static final long serialVersionUID = 4353L;
    private static final String DEF_P1 = "/common";
    private static final String DEF_P2 = "/menu";
    private static final String DEF_P3 = "/image";
    private static final String DEF_ALL = "*";
    private static final String MAX_AGE = String.valueOf(86400);
    private static final String[] DEF_PATH = new String[]{"/common", "/menu", "/image"};
    private static final String[] DEF_SUFX = new String[]{"*"};
    private String ccHeader = null;
    private String[] pathArray = null;
    private String[] sufxArray = null;
    private boolean isDefault = true;

    public void init() throws ServletException {
        super.init();
        String string = this.getServletConfig().getInitParameter("maxage");
        String string2 = this.getServletConfig().getInitParameter("path");
        String string3 = this.getServletConfig().getInitParameter("suffix");
        this.ccHeader = "private, max-age=" + (string == null ? MAX_AGE : string);
        this.pathArray = string2 == null ? DEF_PATH : string2.split(" ");
        this.sufxArray = string3 == null ? DEF_SUFX : string3.split(" ");
        boolean bl = this.isDefault = string2 == null && string3 == null;
        if (this.debug > 0) {
            this.log("CacheDefaultServlet.maxage:  " + string);
            this.log("CacheDefaultServlet.path  :  " + string2);
            this.log("CacheDefaultServlet.suffix:  " + string3);
        }
    }

    protected void serveResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, String string) throws IOException, ServletException {
        String string2 = this.getRelativePath(httpServletRequest);
        if (this.isDefault) {
            if (string2.indexOf(DEF_P1) >= 0 || string2.indexOf(DEF_P2) >= 0 || string2.indexOf(DEF_P3) >= 0) {
                httpServletResponse.setHeader("Cache-Control", this.ccHeader);
                httpServletResponse.setHeader("Expires", null);
                httpServletResponse.setHeader("Pragma", null);
            }
        } else {
            boolean bl2 = true;
            block0: for (int i = 0; bl2 && i < this.pathArray.length; ++i) {
                String string3 = this.pathArray[i];
                if (!string3.equals(DEF_ALL) && string2.indexOf(string3) < 0) continue;
                for (int j = 0; bl2 && j < this.sufxArray.length; ++j) {
                    String string4 = this.sufxArray[j];
                    if (!string4.equals(DEF_ALL) && !string2.endsWith(string4)) continue;
                    httpServletResponse.setHeader("Cache-Control", this.ccHeader);
                    httpServletResponse.setHeader("Expires", null);
                    httpServletResponse.setHeader("Pragma", null);
                    bl2 = false;
                    continue block0;
                }
            }
        }
        super.serveResource(httpServletRequest, httpServletResponse, bl, string);
    }
}

