/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.firebirdsql.pool.AbstractConnectionPool;
import org.firebirdsql.pool.ConnectionPoolConfiguration;

public abstract class BasicAbstractConnectionPool
extends AbstractConnectionPool
implements ConnectionPoolConfiguration,
ConnectionPoolDataSource,
Serializable,
Referenceable {
    private int minPoolSize = 0;
    private int maxPoolSize = 10;
    private int blockingTimeout = 5000;
    private int retryInterval = 1000;
    private int maxIdleTime = 2147483;
    private int pingInterval = 5000;
    private String pingStatement;
    private boolean pooling = true;
    private boolean statementPooling = true;
    private boolean keepStatements = true;
    private int maxStatements = 1000;
    private Reference reference;
    private static final String REF_BLOCKING_TIMEOUT = "blockingTimeout";
    private static final String REF_RETRY_INTERVAL = "retryInterval";
    private static final String REF_LOGIN_TIMEOUT = "loginTimeout";
    private static final String REF_PING_INTERVAL = "pingInterval";
    private static final String REF_PING_STATEMENT = "pingStatement";
    private static final String REF_POOLING = "pooling";
    private static final String REF_STATEMENT_POOLING = "statementPooling";
    private static final String REF_MAX_STATEMENTS = "maxStatements";
    private static final String REF_MAX_POOL_SIZE = "maxPoolSize";
    private static final String REF_MIN_POOL_SIZE = "minPoolSize";
    private static final String REF_MAX_IDLE_TIME = "maxIdleTime";
    private static final String REF_MAX_CONNECTIONS = "maxConnections";
    private static final String REF_MIN_CONNECTIONS = "minConnections";
    private static final String REF_IDLE_TIMEOUT = "idleTimeout";

    protected BasicAbstractConnectionPool() {
    }

    @Override
    public abstract int getLoginTimeout() throws SQLException;

    @Override
    public abstract void setLoginTimeout(int var1) throws SQLException;

    @Override
    public abstract PrintWriter getLogWriter() throws SQLException;

    @Override
    public abstract void setLogWriter(PrintWriter var1) throws SQLException;

    @Override
    public abstract PooledConnection getPooledConnection() throws SQLException;

    @Override
    public abstract PooledConnection getPooledConnection(String var1, String var2) throws SQLException;

    @Override
    public ConnectionPoolConfiguration getConfiguration() {
        return this;
    }

    @Override
    public int getBlockingTimeout() {
        return this.blockingTimeout;
    }

    public void setBlockingTimeout(int blockingTimeout) {
        this.blockingTimeout = blockingTimeout;
    }

    @Override
    public int getIdleTimeout() {
        return this.getMaxIdleTime();
    }

    public void setIdleTimeout(int idleTimeout) {
        this.setMaxIdleTime(idleTimeout);
    }

    @Override
    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    public int getMaxConnections() {
        return this.getMaxPoolSize();
    }

    public void setMaxConnections(int maxConnections) {
        this.setMaxPoolSize(maxConnections);
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    @Override
    public int getMinConnections() {
        return this.getMinPoolSize();
    }

    public void setMinConnections(int minConnections) {
        this.setMinPoolSize(minConnections);
    }

    @Override
    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    @Override
    public int getPingInterval() {
        return this.pingInterval;
    }

    public void setPingInterval(int pingInterval) {
        this.pingInterval = pingInterval;
    }

    @Override
    public String getPingStatement() {
        return this.pingStatement;
    }

    public void setPingStatement(String pingStatement) {
        this.pingStatement = pingStatement;
    }

    @Override
    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    @Override
    public boolean isPingable() {
        return this.getPingInterval() > 0 && this.getPingStatement() != null;
    }

    @Override
    public boolean isPooling() {
        return this.pooling;
    }

    public void setPooling(boolean pooling) {
        this.pooling = pooling;
    }

    @Override
    public boolean isStatementPooling() {
        return this.statementPooling;
    }

    public void setStatementPooling(boolean statementPooling) {
        if (this.getMaxStatements() == 0) {
            statementPooling = false;
        }
        this.statementPooling = statementPooling;
    }

    public boolean isKeepStatements() {
        return this.keepStatements;
    }

    public void setKeepStatements(boolean keepStatements) {
        this.keepStatements = keepStatements;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public void setMaxStatements(int maxStatements) {
        this.maxStatements = maxStatements;
        if (maxStatements > 0 && !this.isStatementPooling()) {
            this.setStatementPooling(true);
        } else if (maxStatements == 0) {
            this.setStatementPooling(false);
        }
    }

    protected abstract BasicAbstractConnectionPool createObjectInstance();

    public Object getObjectInstance(Object obj) throws Exception {
        int i;
        if (!(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        if (!this.getClass().getName().equals(ref.getClassName())) {
            return null;
        }
        BasicAbstractConnectionPool ds = this.createObjectInstance();
        int[] addressesToRemove = new int[ref.size()];
        for (i = 0; i < ref.size(); ++i) {
            RefAddr element = ref.get(i);
            String type = element.getType();
            String addr = element.getContent().toString();
            if (REF_BLOCKING_TIMEOUT.equals(type)) {
                ds.setBlockingTimeout(Integer.parseInt(addr));
            } else if (REF_MAX_IDLE_TIME.equals(type)) {
                ds.setMaxIdleTime(Integer.parseInt(addr));
            } else if (REF_IDLE_TIMEOUT.equals(type)) {
                ds.setMaxIdleTime(Integer.parseInt(addr));
            } else if (REF_LOGIN_TIMEOUT.equals(type)) {
                ds.setLoginTimeout(Integer.parseInt(addr));
            } else if (REF_MAX_POOL_SIZE.equals(type)) {
                ds.setMaxPoolSize(Integer.parseInt(addr));
            } else if (REF_MIN_POOL_SIZE.equals(type)) {
                ds.setMinPoolSize(Integer.parseInt(addr));
            } else if (REF_MAX_CONNECTIONS.equals(type)) {
                ds.setMaxPoolSize(Integer.parseInt(addr));
            } else if (REF_MIN_CONNECTIONS.equals(type)) {
                ds.setMinPoolSize(Integer.parseInt(addr));
            } else if (REF_PING_INTERVAL.equals(type)) {
                ds.setPingInterval(Integer.parseInt(addr));
            } else if (REF_RETRY_INTERVAL.equals(type)) {
                ds.setRetryInterval(Integer.parseInt(addr));
            } else if (REF_PING_STATEMENT.equals(type)) {
                ds.setPingStatement(addr);
            } else if (REF_POOLING.equals(type)) {
                ds.setPooling(Boolean.valueOf(addr));
            } else if (REF_STATEMENT_POOLING.equals(type)) {
                ds.setStatementPooling(Boolean.valueOf(addr));
            } else {
                if (!REF_MAX_STATEMENTS.equals(type)) continue;
                ds.setMaxStatements(Integer.parseInt(addr));
            }
            addressesToRemove[i] = 1;
        }
        for (i = addressesToRemove.length - 1; i >= 0; --i) {
            if (addressesToRemove[i] != 1) continue;
            ref.remove(i);
        }
        return ds;
    }

    protected String getRefAddr(Reference ref, String type) {
        RefAddr addr = ref.get(type);
        if (addr == null) {
            return null;
        }
        return addr.getContent().toString();
    }

    @Override
    public Reference getReference() {
        if (this.reference == null) {
            return this.getDefaultReference();
        }
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getDefaultReference() {
        Reference ref = new Reference(this.getClass().getName(), this.getClass().getName(), null);
        if (this.getBlockingTimeout() != 5000) {
            ref.add(new StringRefAddr(REF_BLOCKING_TIMEOUT, String.valueOf(this.getBlockingTimeout())));
        }
        if (this.getMaxIdleTime() != 2147483) {
            ref.add(new StringRefAddr(REF_MAX_IDLE_TIME, String.valueOf(this.getMaxIdleTime())));
        }
        if (this.getMaxPoolSize() != 10) {
            ref.add(new StringRefAddr(REF_MAX_POOL_SIZE, String.valueOf(this.getMaxPoolSize())));
        }
        if (this.getMinPoolSize() != 0) {
            ref.add(new StringRefAddr(REF_MIN_POOL_SIZE, String.valueOf(this.getMinPoolSize())));
        }
        if (this.getPingInterval() != 5000) {
            ref.add(new StringRefAddr(REF_PING_INTERVAL, String.valueOf(this.getPingInterval())));
        }
        if (this.getRetryInterval() != 1000) {
            ref.add(new StringRefAddr(REF_RETRY_INTERVAL, String.valueOf(this.getRetryInterval())));
        }
        if (this.getPingStatement() != null) {
            ref.add(new StringRefAddr(REF_PING_STATEMENT, String.valueOf(this.getPingStatement())));
        }
        if (!this.isPooling()) {
            ref.add(new StringRefAddr(REF_POOLING, String.valueOf(this.isPooling())));
        }
        if (!this.isStatementPooling()) {
            ref.add(new StringRefAddr(REF_STATEMENT_POOLING, String.valueOf(this.isStatementPooling())));
        }
        if (this.getMaxStatements() != 1000) {
            ref.add(new StringRefAddr(REF_MAX_STATEMENTS, String.valueOf(this.getMaxStatements())));
        }
        return ref;
    }

    public static byte[] serialize(Object obj) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bout);
            out.writeObject(obj);
            out.flush();
        }
        catch (IOException ex) {
            return null;
        }
        return bout.toByteArray();
    }

    public static Object deserialize(byte[] data) {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        try {
            ObjectInputStream in = new ObjectInputStream(bin);
            return in.readObject();
        }
        catch (IOException ex) {
            return null;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }
}

