/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import org.firebirdsql.jdbc.FBEscapedParser;
import org.firebirdsql.jdbc.FBProcedureCall;
import org.firebirdsql.jdbc.FBProcedureParam;
import org.firebirdsql.jdbc.FBSQLParseException;

public class FBEscapedCallParser {
    private static final int NORMAL_STATE = 1;
    private static final int LITERAL_STATE = 2;
    private static final int BRACE_STATE = 4;
    private static final int CURLY_BRACE_STATE = 8;
    private static final int SPACE_STATE = 16;
    private static final int COMMA_STATE = 32;
    private static final int INITIAL_CAPACITY = 32;
    private int state = 1;
    private boolean isNameProcessed;
    private boolean isExecuteWordProcessed;
    private boolean isProcedureWordProcessed;
    private boolean isCallWordProcessed;
    private int openBraceCount;
    private FBProcedureCall procedureCall;
    private FBEscapedParser escapedParser;

    public FBEscapedCallParser(int mode) {
        this.escapedParser = new FBEscapedParser(mode);
    }

    protected int getState() {
        return this.state;
    }

    protected void setState(int state) {
        this.state = state;
    }

    protected boolean isInState(int state) {
        return this.state == state;
    }

    protected void switchState(char testChar) throws FBSQLParseException {
        if (Character.isWhitespace(testChar) && !this.isInState(2)) {
            this.setState(16);
            return;
        }
        switch (testChar) {
            case '\'': {
                if (this.isInState(1)) {
                    this.setState(2);
                    break;
                }
                if (!this.isInState(2)) break;
                this.setState(1);
                break;
            }
            case ',': {
                if (this.isInState(2) || this.isInState(4)) break;
                this.setState(32);
                break;
            }
            case '(': 
            case ')': {
                if (this.isInState(2)) break;
                this.setState(4);
                break;
            }
            case '{': 
            case '}': {
                if (this.isInState(2)) break;
                this.setState(8);
                break;
            }
            default: {
                if (this.isInState(2) || this.isInState(4)) break;
                this.setState(1);
            }
        }
    }

    private String cleanUpCall(String sql) throws FBSQLParseException {
        int startIndex;
        int endIndex = sql.length();
        for (startIndex = 0; startIndex < endIndex && Character.isWhitespace(sql.charAt(startIndex)); ++startIndex) {
        }
        while (endIndex > startIndex && Character.isWhitespace(sql.charAt(endIndex - 1))) {
            --endIndex;
        }
        if (startIndex < endIndex && sql.charAt(startIndex) == '{' && endIndex > 0 && sql.charAt(endIndex - 1) == '}') {
            ++startIndex;
            --endIndex;
        }
        if (startIndex >= endIndex) {
            throw new FBSQLParseException("Escaped call statement was empty.");
        }
        return sql.substring(startIndex, endIndex);
    }

    private boolean isCallKeywordProcessed() {
        return this.isCallWordProcessed || this.isExecuteWordProcessed && this.isProcedureWordProcessed;
    }

    public FBProcedureCall parseCall(String sql) throws SQLException {
        String value;
        int startIndex;
        sql = this.cleanUpCall(sql);
        this.procedureCall = new FBProcedureCall();
        this.isExecuteWordProcessed = false;
        this.isProcedureWordProcessed = false;
        this.isCallWordProcessed = false;
        this.isNameProcessed = false;
        boolean isFirstOutParam = false;
        int paramCount = 0;
        int paramPosition = 0;
        this.setState(1);
        StringBuilder buffer = new StringBuilder(32);
        int length = sql.length();
        block8: for (int i = 0; i < length; ++i) {
            char currentChar = sql.charAt(i);
            this.switchState(currentChar);
            switch (this.state) {
                case 1: {
                    if (currentChar == '=' && this.openBraceCount <= 0 && buffer.length() >= 1 && buffer.charAt(0) == '?' && !isFirstOutParam && !this.isNameProcessed) {
                        FBProcedureParam param = this.procedureCall.addParam(paramPosition, "?");
                        param.setIndex(++paramCount);
                        isFirstOutParam = true;
                        ++paramPosition;
                        buffer.setLength(0);
                        continue block8;
                    }
                    buffer.append(currentChar);
                    continue block8;
                }
                case 16: {
                    if (buffer.length() == 0) {
                        this.setState(1);
                        continue block8;
                    }
                    if (this.openBraceCount > 0) {
                        buffer.append(currentChar);
                        this.setState(1);
                        continue block8;
                    }
                    if (!this.isNameProcessed) {
                        int j;
                        boolean tokenProcessed = this.processToken(buffer.toString().trim());
                        if (!tokenProcessed) continue block8;
                        buffer.setLength(0);
                        this.setState(1);
                        if (!this.isNameProcessed) continue block8;
                        for (j = i; j < length - 1 && Character.isWhitespace(sql.charAt(j)); ++j) {
                        }
                        if (sql.charAt(j) != '(') continue block8;
                        i = j;
                        continue block8;
                    }
                    buffer.append(currentChar);
                    this.setState(1);
                    continue block8;
                }
                case 4: {
                    boolean isProcedureName;
                    boolean bl = isProcedureName = currentChar == '(' && this.isCallKeywordProcessed() && !this.isNameProcessed;
                    if (isProcedureName) {
                        if (buffer.length() == 0) {
                            throw new FBSQLParseException("Procedure name is empty.");
                        }
                        this.procedureCall.setName(buffer.toString().trim());
                        this.isNameProcessed = true;
                        buffer.setLength(0);
                    } else {
                        buffer.append(currentChar);
                        this.openBraceCount = currentChar == '(' ? ++this.openBraceCount : --this.openBraceCount;
                    }
                    this.setState(1);
                    continue block8;
                }
                case 8: {
                    buffer.append(currentChar);
                    this.setState(1);
                    continue block8;
                }
                case 32: {
                    if (this.openBraceCount > 0) {
                        buffer.append(currentChar);
                        continue block8;
                    }
                    String param = this.processParam(buffer.toString());
                    buffer.setLength(0);
                    FBProcedureParam callParam = this.procedureCall.addParam(paramPosition, param);
                    if (callParam.isParam()) {
                        callParam.setIndex(++paramCount);
                    }
                    ++paramPosition;
                    this.setState(1);
                    continue block8;
                }
                case 2: {
                    buffer.append(currentChar);
                }
            }
        }
        if (buffer.length() == 0) {
            return this.procedureCall;
        }
        int endIndex = buffer.length();
        for (startIndex = 0; startIndex < endIndex && Character.isSpaceChar(buffer.charAt(startIndex)); ++startIndex) {
        }
        while (endIndex > startIndex && Character.isSpaceChar(buffer.charAt(endIndex - 1))) {
            --endIndex;
        }
        if (startIndex < endIndex && buffer.charAt(startIndex) == '(') {
            ++startIndex;
        }
        if (startIndex < endIndex && buffer.charAt(endIndex - 1) == ')') {
            --endIndex;
        }
        String string = value = startIndex < endIndex ? buffer.substring(startIndex, endIndex).trim() : "";
        if (value.length() == 0) {
            return this.procedureCall;
        }
        if (null == this.procedureCall.getName() && !this.isNameProcessed) {
            this.procedureCall.setName(value);
        } else {
            FBProcedureParam callParam = this.procedureCall.addParam(paramPosition, value);
            if (callParam.isParam()) {
                callParam.setIndex(++paramCount);
            }
        }
        return this.procedureCall;
    }

    protected boolean processToken(String token) {
        if ("EXECUTE".equalsIgnoreCase(token) && !this.isExecuteWordProcessed && !this.isProcedureWordProcessed && !this.isNameProcessed) {
            this.isExecuteWordProcessed = true;
            return true;
        }
        if ("PROCEDURE".equalsIgnoreCase(token) && this.isExecuteWordProcessed && !this.isProcedureWordProcessed && !this.isNameProcessed) {
            this.isProcedureWordProcessed = true;
            return true;
        }
        if ("call".equalsIgnoreCase(token) && !this.isCallWordProcessed && !this.isNameProcessed) {
            this.isCallWordProcessed = true;
            return true;
        }
        if ((this.isCallWordProcessed || this.isExecuteWordProcessed && this.isProcedureWordProcessed) && !this.isNameProcessed) {
            this.procedureCall.setName(token);
            this.isNameProcessed = true;
            return true;
        }
        return false;
    }

    protected String processParam(String param) throws SQLException {
        return this.escapedParser.parse(param);
    }
}

