/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.ISCConstants;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jdbc.FBTpbMapper;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;

public class FBConnectionHelper {
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_BOOLEAN = 1;
    private static final int TYPE_BYTE = 2;
    private static final int TYPE_INT = 3;
    private static final int TYPE_STRING = 4;
    public static final String TRANSACTION_SERIALIZABLE = "TRANSACTION_SERIALIZABLE";
    public static final String TRANSACTION_REPEATABLE_READ = "TRANSACTION_REPEATABLE_READ";
    public static final String TRANSACTION_READ_COMMITTED = "TRANSACTION_READ_COMMITTED";
    public static final String DPB_PREFIX = "isc_dpb_";
    public static final String TPB_PREFIX = "isc_tpb_";
    public static final String TPB_MAPPING_PROPERTY = "tpb_mapping";
    public static final String ISC_DPB_TYPES_RESOURCE = "isc_dpb_types.properties";
    private static final Map<String, Integer> dpbTypes;
    private static final Map<String, Integer> dpbParameterTypes;
    private static final Map<String, Integer> tpbTypes;

    public static Integer getDpbKey(String name) {
        return dpbTypes.get(name);
    }

    public static Map<String, Integer> getDpbMap() {
        return Collections.unmodifiableMap(dpbTypes);
    }

    public static Object parseDpbString(String name, Object value) {
        if (value instanceof Boolean || value instanceof Byte || value instanceof Integer) {
            return value;
        }
        if (value != null && !(value instanceof String)) {
            throw new ClassCastException(value.getClass().getName());
        }
        Integer type = dpbParameterTypes.get(name);
        if (type == null) {
            type = 0;
        }
        switch (type) {
            case 1: {
                return "".equals(value) ? Boolean.TRUE : Boolean.valueOf((String)value);
            }
            case 2: {
                return new Byte((String)value);
            }
            case 3: {
                return new Integer((String)value);
            }
            case 4: {
                return value;
            }
        }
        if (value == null || "".equals(value)) {
            return Boolean.TRUE;
        }
        try {
            int intValue = Integer.parseInt((String)value);
            if (intValue < 256) {
                return (byte)intValue;
            }
            return intValue;
        }
        catch (NumberFormatException nfex) {
            return value;
        }
    }

    public static void processTpbMapping(GDS gds, FirebirdConnectionProperties connectionProperties, Properties info) throws FBResourceException {
        if (info.containsKey(TRANSACTION_SERIALIZABLE)) {
            connectionProperties.setTransactionParameters(8, FBTpbMapper.processMapping(gds, info.getProperty(TRANSACTION_SERIALIZABLE)));
        }
        if (info.containsKey(TRANSACTION_REPEATABLE_READ)) {
            connectionProperties.setTransactionParameters(4, FBTpbMapper.processMapping(gds, info.getProperty(TRANSACTION_REPEATABLE_READ)));
        }
        if (info.containsKey(TRANSACTION_READ_COMMITTED)) {
            connectionProperties.setTransactionParameters(2, FBTpbMapper.processMapping(gds, info.getProperty(TRANSACTION_READ_COMMITTED)));
        }
    }

    public static Integer getTpbParam(String name) {
        return tpbTypes.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String resource) throws IOException {
        ClassLoader cl = FBConnectionHelper.class.getClassLoader();
        InputStream in = cl == null ? ClassLoader.getSystemResourceAsStream(resource) : cl.getResourceAsStream(resource);
        if (in == null) {
            return null;
        }
        try {
            Properties props = new Properties();
            props.load(in);
            Properties properties = props;
            return properties;
        }
        finally {
            in.close();
        }
    }

    private static void loadDpbParameterTypes() {
        Properties props;
        try {
            props = FBConnectionHelper.loadProperties(ISC_DPB_TYPES_RESOURCE);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String shortKey = key.substring(DPB_PREFIX.length());
            String value = (String)entry.getValue();
            int hashIndex = value.indexOf(35);
            if (hashIndex != -1) {
                value = value.substring(0, hashIndex).trim();
            }
            if ("boolean".equals(value)) {
                dpbParameterTypes.put(key, 1);
                dpbParameterTypes.put(shortKey, 1);
                continue;
            }
            if ("byte".equals(value)) {
                dpbParameterTypes.put(key, 2);
                dpbParameterTypes.put(shortKey, 2);
                continue;
            }
            if ("int".equals(value)) {
                dpbParameterTypes.put(key, 3);
                dpbParameterTypes.put(shortKey, 3);
                continue;
            }
            if (!"string".equals(value)) continue;
            dpbParameterTypes.put(key, 4);
            dpbParameterTypes.put(shortKey, 4);
        }
    }

    static {
        Field[] fields;
        dpbTypes = new HashMap<String, Integer>();
        dpbParameterTypes = new HashMap<String, Integer>();
        tpbTypes = new HashMap<String, Integer>();
        Class<ISCConstants> iscClass = ISCConstants.class;
        for (Field field : fields = iscClass.getFields()) {
            Integer value;
            if (!field.getType().getName().equals("int")) continue;
            String name = field.getName();
            try {
                value = (Integer)field.get(null);
            }
            catch (IllegalAccessException iaex) {
                continue;
            }
            if (name.startsWith(DPB_PREFIX)) {
                dpbTypes.put(name.substring(DPB_PREFIX.length()), value);
                dpbTypes.put(name, value);
                continue;
            }
            if (!name.startsWith(TPB_PREFIX)) continue;
            tpbTypes.put(name.substring(TPB_PREFIX.length()), value);
            tpbTypes.put(name, value);
        }
        FBConnectionHelper.loadDpbParameterTypes();
    }
}

