/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverterOGS;
import oracle.i18n.text.converter.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;

public abstract class CharacterConverterLC
extends CharacterConverterOGS {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final int MAX_7BIT = 127;
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    static final int ORACHARWIDTH = 16;
    static final int ORACHARWITHLCWIDTH = 32;
    static final int BYTEWIDTH = 8;
    static final int HIBYTEMASK = 65280;
    static final int LOWBYTEMASK = 255;
    static final int LOW16BITMASK = 65535;
    static final int LEADINGCODEWIDTH = 16;
    static final int LEADINGCODESHIFT = 16;
    static final int LEADINGCODEMASK = 65535;
    static final int LCINDEXWIDTH = 4;
    static final int LCINDEXMASK = 15;
    static final int LCINDEXFACTOR = 2;
    static final int MAXBYTEPERCHAR = 4;
    public char[][] m_ucsCharLeadingCode = null;
    public char[] m_ucsCharLevel1 = null;
    public int[] m_ucsCharLevel2 = null;
    public int m_ucsCharReplacement = 0;
    public char m_1ByteOraCharReplacement = '\u0000';
    public char m_2ByteOraCharReplacement = '\u0000';
    public char[] m_displayWidthLevel1 = null;
    public byte[] m_displayWidthLevel2 = null;
    public char[][] m_displayWidthLeadingCode = null;
    public char[] m_oraCharLevel1 = null;
    public int[] m_oraCharLevel2 = null;
    public char[] m_oraCharSurrogateLevel = null;

    CharacterConverterLC() {
        this.m_groupId = 8;
        this.averageCharsPerByte = 1.0f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 4.0f;
    }

    @Override
    public char[] getLeadingCodes() {
        char[] cArray = new char[this.m_ucsCharLeadingCode.length];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = this.m_ucsCharLeadingCode[i][0];
        }
        return cArray;
    }

    int toUnicode(int n) throws SQLException {
        int n2;
        int n3 = 0;
        int n4 = n >> 16 & 0xFFFF;
        for (n2 = 0; n2 < this.m_ucsCharLeadingCode.length; ++n2) {
            if (n4 != this.m_ucsCharLeadingCode[n2][0]) continue;
            n3 = this.m_ucsCharLeadingCode[n2][1];
            break;
        }
        if (n2 == this.m_ucsCharLeadingCode.length) {
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
        int n5 = (n >> 8 & 0xFF) + n3;
        int n6 = n & 0xFF;
        if (this.m_ucsCharLevel1[n5] == '\uffff' || this.m_ucsCharLevel2[this.m_ucsCharLevel1[n5] + n6] == -1) {
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
        int n7 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n5] + n6];
        return n7;
    }

    int toUnicodeWithReplacement(int n) {
        int n2;
        int n3 = 0;
        int n4 = n >> 16 & 0xFFFF;
        for (n2 = 0; n2 < this.m_ucsCharLeadingCode.length; ++n2) {
            if (n4 != this.m_ucsCharLeadingCode[n2][0]) continue;
            n3 = this.m_ucsCharLeadingCode[n2][1];
            break;
        }
        if (n2 == this.m_ucsCharLeadingCode.length) {
            return this.m_ucsCharReplacement;
        }
        int n5 = (n >> 8 & 0xFF) + n3;
        int n6 = n & 0xFF;
        int n7 = this.m_ucsCharLevel1[n5] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n5] + n6] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n5] + n6] : this.m_ucsCharReplacement;
        return n7;
    }

    @Override
    public int getDisplayWidth(int n, boolean bl) throws UnsupportedEncodingException, SQLException {
        byte by;
        int n2;
        char[] cArray = this.parseUnicodeCodePoint(n);
        int n3 = bl ? this.toOracleCharacterWithReplacement(cArray[0], cArray[1]) : this.toOracleCharacter(cArray[0], cArray[1]);
        if (this.m_displayWidthLevel1 == null || this.m_displayWidthLevel2 == null) {
            return this.getDefaultDisplayWidth(n3);
        }
        int n4 = 0;
        int n5 = n3 >> 16 & 0xFFFF;
        for (n2 = 0; n2 < this.m_displayWidthLeadingCode.length; ++n2) {
            if (n5 != this.m_displayWidthLeadingCode[n2][0]) continue;
            n4 = this.m_displayWidthLeadingCode[n2][1];
            break;
        }
        if (n2 == this.m_displayWidthLeadingCode.length) {
            return this.getDefaultDisplayWidth(n3);
        }
        int n6 = (n3 >> 8 & 0xFF) + n4;
        int n7 = n3 & 0xFF;
        if (this.m_displayWidthLevel1[n6] != '\uffff' && (by = this.m_displayWidthLevel2[this.m_displayWidthLevel1[n6] + n7]) != -1) {
            return by;
        }
        return this.getDefaultDisplayWidth(n3);
    }

    int toOracleCharacter(char c, char c2) throws SQLException {
        int n = -1;
        if (c2 != '\u0000') {
            int n2 = c >>> 8 & 0xFF;
            int n3 = c & 0xFF;
            int n4 = c2 >>> 8 & 0xFF;
            int n5 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n2] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5] != -1) {
                n = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5];
            }
        } else {
            int n6 = c >>> 8 & 0xFF;
            int n7 = c & 0xFF;
            if (this.m_oraCharLevel1[n6] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7] != -1) {
                n = this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7];
            }
        }
        if (n == -1) {
            throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
        }
        return n;
    }

    int toOracleCharacterWithReplacement(char c, char c2) {
        int n = -1;
        if (c2 != '\u0000') {
            int n2 = c >>> 8 & 0xFF;
            int n3 = c & 0xFF;
            int n4 = c2 >>> 8 & 0xFF;
            int n5 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n2] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5] != -1) {
                n = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5];
            }
        } else {
            int n6 = c >>> 8 & 0xFF;
            int n7 = c & 0xFF;
            if (this.m_oraCharLevel1[n6] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7] != -1) {
                n = this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7];
            }
        }
        if (n == -1) {
            if (c > '\u2fff') {
                return this.m_2ByteOraCharReplacement;
            }
            return this.m_1ByteOraCharReplacement;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] toOracleString(String string) throws SQLException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            if (cArray[i] >= '\ud800' && cArray[i] < '\udc00') {
                if (i + 1 >= n || cArray[i + 1] < '\udc00' || cArray[i + 1] > '\udfff') throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
                n3 = this.toOracleCharacterWithReplacement(cArray[i], cArray[i + 1]);
                ++i;
            } else {
                n3 = this.toOracleCharacter(cArray[i], '\u0000');
            }
            if (n3 >> 24 != 0) {
                byArray[n2++] = (byte)(n3 >> 24);
                byArray[n2++] = (byte)(n3 >> 16);
                byArray[n2++] = (byte)(n3 >> 8);
                byArray[n2++] = (byte)n3;
                continue;
            }
            if (n3 >> 16 != 0) {
                byArray[n2++] = (byte)(n3 >> 16);
                byArray[n2++] = (byte)(n3 >> 8);
                byArray[n2++] = (byte)n3;
                continue;
            }
            if (n3 >> 8 != 0) {
                byArray[n2++] = (byte)(n3 >> 8);
                byArray[n2++] = (byte)n3;
                continue;
            }
            byArray[n2++] = (byte)n3;
        }
        if (n2 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public byte[] toOracleStringWithReplacement(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            block9: {
                if (cArray[i] >= '\ud800' && cArray[i] <= '\udbff') {
                    if (i + 1 < n && cArray[i + 1] >= '\udc00' && cArray[i + 1] <= '\udfff') {
                        n3 = this.toOracleCharacterWithReplacement(cArray[i], cArray[i + 1]);
                        ++i;
                        break block9;
                    } else {
                        byArray[n2++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                        byArray[n2++] = (byte)this.m_2ByteOraCharReplacement;
                        continue;
                    }
                }
                n3 = this.toOracleCharacterWithReplacement(cArray[i], '\u0000');
            }
            if (n3 >> 24 != 0) {
                byArray[n2++] = (byte)(n3 >> 24);
                byArray[n2++] = (byte)(n3 >> 16);
                byArray[n2++] = (byte)(n3 >> 8);
                byArray[n2++] = (byte)n3;
                continue;
            }
            if (n3 >> 16 != 0) {
                byArray[n2++] = (byte)(n3 >> 16);
                byArray[n2++] = (byte)(n3 >> 8);
                byArray[n2++] = (byte)n3;
                continue;
            }
            if (n3 >> 8 != 0) {
                byArray[n2++] = (byte)(n3 >> 8);
                byArray[n2++] = (byte)n3;
                continue;
            }
            byArray[n2++] = (byte)n3;
        }
        if (n2 < byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    @Override
    protected boolean isOraCharacterReplacement(char c, char c2) {
        int n = this.toOracleCharacterWithReplacement(c, c2);
        return n == this.getOraChar1ByteRep() || n == this.getOraChar2ByteRep();
    }

    @Override
    public void buildUnicodeToOracleMapping() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object[] objectArray;
        int n8;
        this.m_oraCharLevel1 = new char[256];
        char[] cArray = null;
        int[] nArray = null;
        Vector<char[]> vector = new Vector<char[]>(45055, 12287);
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        char c = '\u0000';
        char c2 = '\u0000';
        for (n8 = 0; n8 < 256; ++n8) {
            this.m_oraCharLevel1[n8] = 65535;
        }
        for (n8 = 0; n8 < this.m_ucsCharLeadingCode.length; ++n8) {
            int n9 = this.m_ucsCharLeadingCode[n8][0] << 16;
            for (int i = 0; i < 65535; ++i) {
                int n10 = this.toUnicodeWithReplacement(n9 | i);
                if (n10 == this.m_ucsCharReplacement) continue;
                objectArray = new int[2];
                objectArray[0] = n10;
                objectArray[1] = n9 | i;
                vector.addElement((char[])objectArray);
                this.storeMappingRange(n10, hashtable, hashtable2);
            }
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n7 = this.extraUnicodeToOracleMapping.length;
            for (n8 = 0; n8 < n7; ++n8) {
                n6 = this.extraUnicodeToOracleMapping[n8][0];
                this.storeMappingRange(n6, hashtable, hashtable2);
            }
        }
        Enumeration enumeration = hashtable.keys();
        int n11 = 0;
        int n12 = 0;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            objectArray = (char[])hashtable.get(k);
            if (objectArray == null) continue;
            n11 += 256;
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            objectArray = (char[])hashtable2.get(k);
            if (objectArray == null) continue;
            n12 += 256;
        }
        if (n11 != 0) {
            cArray = new char[n11];
        }
        if (n12 != 0) {
            nArray = new int[n12];
        }
        for (n5 = 0; n5 < n11; ++n5) {
            cArray[n5] = 65535;
        }
        for (n5 = 0; n5 < n12; ++n5) {
            nArray[n5] = -1;
        }
        for (n5 = 0; n5 < vector.size(); ++n5) {
            int[] nArray2 = (int[])vector.elementAt(n5);
            n4 = nArray2[0] >>> 24 & 0xFF;
            n3 = nArray2[0] >>> 16 & 0xFF;
            n2 = nArray2[0] >>> 8 & 0xFF;
            n = nArray2[0] & 0xFF;
            if (n4 >= 216 && n4 < 220) {
                if (this.m_oraCharLevel1[n4] == '\uffff') {
                    this.m_oraCharLevel1[n4] = c2;
                    c2 = (char)(c2 + 256);
                }
                if (cArray[this.m_oraCharLevel1[n4] + n3] == '\uffff') {
                    cArray[this.m_oraCharLevel1[n4] + n3] = c2;
                    c2 = (char)(c2 + 256);
                }
                if (cArray[cArray[this.m_oraCharLevel1[n4] + n3] + n2] == '\uffff') {
                    cArray[cArray[this.m_oraCharLevel1[n4] + n3] + n2] = c;
                    c = (char)(c + 256);
                }
                if (nArray[cArray[cArray[this.m_oraCharLevel1[n4] + n3] + n2] + n] != -1) continue;
                nArray[cArray[cArray[this.m_oraCharLevel1[n4] + n3] + n2] + n] = nArray2[1];
                continue;
            }
            if (this.m_oraCharLevel1[n2] == '\uffff') {
                this.m_oraCharLevel1[n2] = c;
                c = (char)(c + 256);
            }
            if (nArray[this.m_oraCharLevel1[n2] + n] != -1) continue;
            nArray[this.m_oraCharLevel1[n2] + n] = nArray2[1];
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n7 = this.extraUnicodeToOracleMapping.length;
            for (n5 = 0; n5 < n7; ++n5) {
                n6 = this.extraUnicodeToOracleMapping[n5][0];
                n4 = n6 >>> 24 & 0xFF;
                n3 = n6 >>> 16 & 0xFF;
                n2 = n6 >>> 8 & 0xFF;
                n = n6 & 0xFF;
                if (n4 >= 216 && n4 < 220) {
                    if (this.m_oraCharLevel1[n4] == '\uffff') {
                        this.m_oraCharLevel1[n4] = c2;
                        c2 = (char)(c2 + 256);
                    }
                    if (cArray[this.m_oraCharLevel1[n4] + n3] == '\uffff') {
                        cArray[this.m_oraCharLevel1[n4] + n3] = c2;
                        c2 = (char)(c2 + 256);
                    }
                    if (cArray[cArray[this.m_oraCharLevel1[n4] + n3] + n2] == '\uffff') {
                        cArray[cArray[this.m_oraCharLevel1[n4] + n3] + n2] = c;
                        c = (char)(c + 256);
                    }
                    nArray[cArray[cArray[this.m_oraCharLevel1[n4] + n3] + n2] + n] = this.extraUnicodeToOracleMapping[n5][1];
                    continue;
                }
                if (this.m_oraCharLevel1[n2] == '\uffff') {
                    this.m_oraCharLevel1[n2] = c;
                    c = (char)(c + 256);
                }
                nArray[this.m_oraCharLevel1[n2] + n] = this.extraUnicodeToOracleMapping[n5][1];
            }
        }
        this.m_oraCharLevel2 = nArray;
        this.m_oraCharSurrogateLevel = cArray;
    }

    @Override
    public void extractCodepoints(Vector vector) {
        for (int i = 0; i < this.m_ucsCharLeadingCode.length; ++i) {
            char c = this.m_ucsCharLeadingCode[i][0];
            int n = c << 16;
            int n2 = n + 65535;
            for (int j = n; j <= n2; ++j) {
                try {
                    int[] nArray = new int[]{j, this.toUnicode(j)};
                    vector.addElement(nArray);
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        for (int i = 0; i < this.extraUnicodeToOracleMapping.length; ++i) {
            vector.addElement(this.extraUnicodeToOracleMapping[i]);
        }
    }

    @Override
    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    @Override
    public char getOraChar1ByteRep() {
        return this.m_1ByteOraCharReplacement;
    }

    @Override
    public char getOraChar2ByteRep() {
        return this.m_2ByteOraCharReplacement;
    }

    @Override
    public int getUCS2CharRep() {
        return this.m_ucsCharReplacement;
    }
}

