/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.util.LittleEndian;

public final class SlidePersistAtom
extends RecordAtom {
    private byte[] _header;
    private static long _type = 1011L;
    private int refID;
    private boolean hasShapesOtherThanPlaceholders;
    private int numPlaceholderTexts;
    private int slideIdentifier;
    private byte[] reservedFields;

    public int getRefID() {
        return this.refID;
    }

    public int getSlideIdentifier() {
        return this.slideIdentifier;
    }

    public int getNumPlaceholderTexts() {
        return this.numPlaceholderTexts;
    }

    public boolean getHasShapesOtherThanPlaceholders() {
        return this.hasShapesOtherThanPlaceholders;
    }

    public void setRefID(int id) {
        this.refID = id;
    }

    public void setSlideIdentifier(int id) {
        this.slideIdentifier = id;
    }

    protected SlidePersistAtom(byte[] source, int start, int len) {
        if (len < 8) {
            len = 8;
        }
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this.refID = LittleEndian.getInt((byte[])source, (int)(start + 8));
        int flags = LittleEndian.getInt((byte[])source, (int)(start + 12));
        this.hasShapesOtherThanPlaceholders = flags == 4;
        this.numPlaceholderTexts = LittleEndian.getInt((byte[])source, (int)(start + 16));
        this.slideIdentifier = LittleEndian.getInt((byte[])source, (int)(start + 20));
        this.reservedFields = new byte[len - 24];
        System.arraycopy(source, start + 24, this.reservedFields, 0, this.reservedFields.length);
    }

    public SlidePersistAtom() {
        this._header = new byte[8];
        LittleEndian.putUShort((byte[])this._header, (int)0, (int)0);
        LittleEndian.putUShort((byte[])this._header, (int)2, (int)((int)_type));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)20);
        this.hasShapesOtherThanPlaceholders = true;
        this.reservedFields = new byte[4];
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        int flags = 0;
        if (this.hasShapesOtherThanPlaceholders) {
            flags = 4;
        }
        SlidePersistAtom.writeLittleEndian(this.refID, out);
        SlidePersistAtom.writeLittleEndian(flags, out);
        SlidePersistAtom.writeLittleEndian(this.numPlaceholderTexts, out);
        SlidePersistAtom.writeLittleEndian(this.slideIdentifier, out);
        out.write(this.reservedFields);
    }
}

