/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.logging.Logger;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.AbstractStatement;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBObjectListener;

public class FBStatement
extends AbstractStatement {
    public FBStatement(GDSHelper c, int rsType, int rsConcurrency, int rsHoldability, FBObjectListener.StatementListener statementListener) throws SQLException {
        super(c, rsType, rsConcurrency, rsHoldability, statementListener);
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return this.getUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        if (max > Integer.MAX_VALUE) {
            this.addWarning(new SQLWarning(String.format("Implementation limit: maxRows cannot exceed Integer.MAX_VALUE, value was %d, reset to 0", max), "HY009"));
            max = 0L;
        }
        this.setMaxRows((int)max);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return this.getMaxRows();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        int[] updateCountsInt = this.executeBatch();
        long[] updateCountsLong = new long[updateCountsInt.length];
        for (int i = 0; i < updateCountsInt.length; ++i) {
            updateCountsLong[i] = updateCountsInt[i];
        }
        return updateCountsLong;
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql, columnIndexes);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql, columnNames);
    }
}

