/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AuthenticationJNI;
import com.microsoft.sqlserver.jdbc.CertificateDetails;
import com.microsoft.sqlserver.jdbc.DLLException;
import com.microsoft.sqlserver.jdbc.KeyStoreProviderCommon;
import com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionKeyStoreProvider;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;

public final class SQLServerColumnEncryptionCertificateStoreProvider
extends SQLServerColumnEncryptionKeyStoreProvider {
    private static final Logger windowsCertificateStoreLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionCertificateStoreProvider");
    static boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows");
    String name = "MSSQL_CERTIFICATE_STORE";
    static final String localMachineDirectory = "LocalMachine";
    static final String currentUserDirectory = "CurrentUser";
    static final String myCertificateStore = "My";
    private Path keyStoreDirectoryPath = null;

    public SQLServerColumnEncryptionCertificateStoreProvider() {
        windowsCertificateStoreLogger.entering(SQLServerColumnEncryptionCertificateStoreProvider.class.getName(), "SQLServerColumnEncryptionCertificateStoreProvider");
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public byte[] encryptColumnEncryptionKey(String string, String string2, byte[] byArray) throws SQLServerException {
        throw new SQLServerException(null, SQLServerException.getErrString("R_InvalidWindowsCertificateStoreEncryption"), null, 0, false);
    }

    private byte[] decryptColumnEncryptionKeyWindows(String string, String string2, byte[] byArray) throws SQLServerException {
        try {
            return AuthenticationJNI.DecryptColumnEncryptionKey(string, string2, byArray);
        }
        catch (DLLException dLLException) {
            DLLException.buildException(dLLException.GetErrCode(), dLLException.GetParam1(), dLLException.GetParam2(), dLLException.GetParam3());
            return null;
        }
    }

    private CertificateDetails getCertificateDetails(String string) throws SQLServerException {
        String string2 = null;
        String[] stringArray = string.split("/");
        if (stringArray.length > 3) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_AECertpathBad"));
            Object[] objectArray = new Object[]{string};
            throw new SQLServerException(messageFormat.format(objectArray), null);
        }
        if (stringArray.length > 2) {
            if (stringArray[0].equalsIgnoreCase(localMachineDirectory)) {
                string2 = localMachineDirectory;
            } else if (stringArray[0].equalsIgnoreCase(currentUserDirectory)) {
                string2 = currentUserDirectory;
            } else {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_AECertLocBad"));
                Object[] objectArray = new Object[]{stringArray[0], string};
                throw new SQLServerException(messageFormat.format(objectArray), null);
            }
        }
        if (stringArray.length > 1 && !stringArray[stringArray.length - 2].equalsIgnoreCase(myCertificateStore)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_AECertStoreBad"));
            Object[] objectArray = new Object[]{stringArray[stringArray.length - 2], string};
            throw new SQLServerException(messageFormat.format(objectArray), null);
        }
        String string3 = stringArray[stringArray.length - 1];
        if (null == string3 || 0 == string3.length()) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_AECertHashEmpty"));
            Object[] objectArray = new Object[]{string};
            throw new SQLServerException(messageFormat.format(objectArray), null);
        }
        return this.getCertificateByThumbprint(string2, string3, string);
    }

    private String getThumbPrint(X509Certificate x509Certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] byArray = x509Certificate.getEncoded();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        return DatatypeConverter.printHexBinary((byte[])byArray2);
    }

    private CertificateDetails getCertificateByThumbprint(String string, String string2, String string3) throws SQLServerException {
        FileInputStream fileInputStream = null;
        if (null == this.keyStoreDirectoryPath) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_AEKeyPathEmptyOrReserved"));
            Object[] objectArray = new Object[]{this.keyStoreDirectoryPath};
            throw new SQLServerException(messageFormat.format(objectArray), null);
        }
        Path path = this.keyStoreDirectoryPath.resolve(string);
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("PKCS12");
        }
        catch (KeyStoreException keyStoreException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_CertificateError"));
            Object[] objectArray = new Object[]{string3, this.name};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        File file = path.toFile();
        File[] fileArray = file.listFiles();
        if (null == fileArray || null != fileArray && 0 == fileArray.length) {
            throw new SQLServerException(SQLServerException.getErrString("R_KeyStoreNotFound"), null);
        }
        for (File file2 : fileArray) {
            Object[] objectArray;
            Object object;
            if (file2.isDirectory()) continue;
            char[] cArray = "".toCharArray();
            try {
                fileInputStream = new FileInputStream(file2);
                keyStore.load(fileInputStream, cArray);
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException exception) {
                continue;
            }
            try {
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    objectArray = (Object[])keyStore.getCertificate((String)object);
                    if (!string2.matches(this.getThumbPrint((X509Certificate)objectArray))) continue;
                    Key key = null;
                    try {
                        key = keyStore.getKey((String)object, "".toCharArray());
                        if (null == key) {
                            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_UnrecoverableKeyAE"));
                            Object[] objectArray2 = new Object[]{string3};
                            throw new SQLServerException((Object)this, messageFormat.format(objectArray2), null, 0, false);
                        }
                    }
                    catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException generalSecurityException) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_UnrecoverableKeyAE"));
                        Object[] objectArray3 = new Object[]{string3};
                        throw new SQLServerException((Object)this, messageFormat.format(objectArray3), null, 0, false);
                    }
                    return new CertificateDetails((X509Certificate)objectArray, key);
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException generalSecurityException) {
                object = new MessageFormat(SQLServerException.getErrString("R_CertificateError"));
                objectArray = new Object[]{string3, this.name};
                throw new SQLServerException(((Format)object).format(objectArray), generalSecurityException);
            }
        }
        throw new SQLServerException(SQLServerException.getErrString("R_KeyStoreNotFound"), null);
    }

    private byte[] decryptColumnEncryptionKeyLinux(String string, String string2, byte[] byArray) throws SQLServerException {
        KeyStoreProviderCommon.validateNonEmptyMasterKeyPath(string);
        CertificateDetails certificateDetails = this.getCertificateDetails(string);
        return KeyStoreProviderCommon.decryptColumnEncryptionKey(string, string2, byArray, certificateDetails);
    }

    @Override
    public byte[] decryptColumnEncryptionKey(String string, String string2, byte[] byArray) throws SQLServerException {
        windowsCertificateStoreLogger.entering(SQLServerColumnEncryptionCertificateStoreProvider.class.getName(), "decryptColumnEncryptionKey", "Decrypting Column Encryption Key.");
        byte[] byArray2 = null;
        if (!isWindows) {
            throw new SQLServerException(SQLServerException.getErrString("R_notSupported"), null);
        }
        byArray2 = this.decryptColumnEncryptionKeyWindows(string, string2, byArray);
        windowsCertificateStoreLogger.exiting(SQLServerColumnEncryptionCertificateStoreProvider.class.getName(), "decryptColumnEncryptionKey", "Finished decrypting Column Encryption Key.");
        return byArray2;
    }
}

