/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;

public final class ExcelStyleFormat {
    private static final String VERSION = "6.4.3.3 (2016/03/04)";
    private static final String[] DATE_TYPE = new String[]{"yyyyMMdd", "yyyyMMddHHmmss", "HHmmss"};
    private static final DateFormat[] DT_FORMAT = new DateFormat[DATE_TYPE.length];
    private final StylesTable stylesTable;
    private final ConcurrentMap<Integer, String> fmtStrMap = new ConcurrentHashMap<Integer, String>();
    private final ConcurrentMap<Integer, Integer> extFmtIdxMap = new ConcurrentHashMap<Integer, Integer>();
    private int extFmtCnt;

    public ExcelStyleFormat() {
        this.stylesTable = null;
    }

    public ExcelStyleFormat(StylesTable stylesTable) {
        this.stylesTable = stylesTable;
    }

    public void addExtFmtRec(ExtendedFormatRecord extendedFormatRecord) {
        short s = extendedFormatRecord.getFormatIndex();
        short s2 = extendedFormatRecord.getXFType();
        if (s2 == 0) {
            this.extFmtIdxMap.put(this.extFmtCnt, Integer.valueOf(s));
        }
        ++this.extFmtCnt;
    }

    public void addFmtRec(FormatRecord formatRecord) {
        int n = formatRecord.getIndexCode();
        String string = formatRecord.getFormatString();
        this.fmtStrMap.put(n, string);
    }

    public String getNumberValue(String string, String string2) {
        int n;
        XSSFCellStyle xSSFCellStyle;
        String string3 = null;
        if (this.stylesTable != null && string != null && !string.isEmpty() && (string3 = (xSSFCellStyle = this.stylesTable.getStyleAt(n = Integer.parseInt(string))).getDataFormatString()) == null) {
            short s = xSSFCellStyle.getDataFormat();
            string3 = BuiltinFormats.getBuiltinFormat((int)s);
        }
        return ExcelStyleFormat.getNumberValue(string3, Double.parseDouble(string2));
    }

    public String getNumberValue(NumberRecord numberRecord) {
        short s = numberRecord.getXFIndex();
        int n = (Integer)this.extFmtIdxMap.get(s);
        String string = n < 164 ? BuiltinFormats.getBuiltinFormat((int)n) : (String)this.fmtStrMap.get(n);
        return ExcelStyleFormat.getNumberValue(string, numberRecord.getValue());
    }

    public static String getNumberValue(String string, double d) {
        return ExcelStyleFormat.isDateFormat(string) ? ExcelStyleFormat.dateFormat(d) : NumberToTextConverter.toText((double)d);
    }

    private static boolean isDateFormat(String string) {
        return string != null && !string.isEmpty() && !"General".equalsIgnoreCase(string) && (string.contains("\u5e74") || string.contains("\u6708") || string.contains("\u65e5") || string.contains("yy") || string.contains("y/m") || string.contains("m/d") || string.contains("h:m"));
    }

    public static String dateFormat(double d) {
        int n = 0;
        n = d < 1.0 ? 2 : (Double.compare(d, Math.floor(d)) == 0 ? 0 : 1);
        DateFormat dateFormat = DT_FORMAT[n];
        if (dateFormat == null) {
            ExcelStyleFormat.DT_FORMAT[n] = dateFormat = new SimpleDateFormat(DATE_TYPE[n], Locale.JAPAN);
        }
        Date date = DateUtil.getJavaDate((double)d);
        return dateFormat.format(date);
    }
}

