/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* GET_RESOURCE ( FUNCTION )                                                */
/* Created : 2016/04/02 23:30:54                                            */
/****************************************************************************/

CREATE 
FUNCTION GET_RESOURCE(
	XPRJCODE       IN VARCHAR2 ,
	XTASK_ID       IN VARCHAR2   )
RETURN VARCHAR2
/**********************************************************************/
/* タスクの使用リソース求め                                           */
/*  GET_RESOURCE( PRJCODE,TASK_ID )                                   */
/*                                                                    */
/*	 PRJCODE  IN VARCHAR2    プロジェクトコード                       */
/*	 TASK_ID  IN VARCHAR2    タスクID                                 */
/*                                                                    */
/*	指定された値をキーに、GF66（タスクリソース定義）を検索し、        */
/*  複数のリソースIDの名称を、カンマで連結させて、返します            */
/*  リソースIDの名称は、GF63(リソースマスタ定義）より求めます。       */
/*                                                                    */
/**********************************************************************/
IS
    RTN     VARCHAR2(1000);
	SEP     VARCHAR2(1)  ;

	CURSOR CODEC1 IS
		SELECT A.NAME_JA
			FROM GF63 A,GF66 B
			WHERE	B.PRJCODE      = XPRJCODE
			AND		B.TASK_ID      = XTASK_ID
			AND		A.RESOURCE_ID  = B.RESOURCE_ID
			AND		A.FGJ         IN ( '0','1' )
			AND		B.FGJ         IN ( '0','1' )
			ORDER BY B.SEQ ;

	CODEREC CODEC1%ROWTYPE;

BEGIN
	RTN := '' ;
	SEP := '' ;

	OPEN	CODEC1;
	LOOP
		FETCH CODEC1 INTO CODEREC;
		EXIT WHEN CODEC1%NOTFOUND;

		RTN := RTN || SEP || CODEREC.NAME_JA ;
		SEP := ',' ;

	END LOOP;
	CLOSE CODEC1;

	RETURN RTN;

END GET_RESOURCE;
;
