'---------------------------------------------------------------------------------------------------
'
'gp@Fcscript Html2Ods [-html] Htmlt@C [-ods ODSt@C ]
'								[-syslog уO -joblog JobO -jobmask JobOϽ]
'
'			2008N0418VK
'---------------------------------------------------------------------------------------------------

Option Explicit

Const cnSysMsgFilter		= 7 		'OϽ
'Const cnSysMsgFilter			= &HFFFF	'OϽ
Const cnDefaultJobMsgFilter 	= 6 		'JobƂ̃t@COϽ
Const cnDefaultScreenMsgFilter	= 6 		'ʏo̓OϽ
'Const cnDefaultScreenMsgFilter = &HFFFF	'ʏo̓OϽ

Const cnDescription = 1 		'
Const cnWarning 	= 2 		'[jO
Const cnError		= 4 		'G[

Const csDescription = " INFO    [0]:"
Const csWarning 	= " WARNING [1]:"
Const csError		= " ERROR   [2]:"
Const csProgErr 	= " PG BUG  [3]:"

Const csPathSep 	= "\"       'fBNg̕
Const csExtSep		= "."
Const csEmptyString = ""		'̕

Const cnLogFileMaxSize	= 5000000				' Log t@C̍ől 悻5M

Dim oHtml2Ods
Dim nRetVal

' Ұp萔
Dim arrParamsKeys
arrParamsKeys = Array("-html", "-ods", "-syslog", "-joblog", "-jobmask")
' "-html"baseҰł
Const cnBaseParamsIndex = 0   'arrParamsKeysz̍ŏIndex
Const cnHtmlKeyIndex	= 0
Const cnOdsKeyIndex 	= 1
Const cnSyslogKeyIndex  = 2
Const cnJoblogKeyIndex  = 3
Const cnJobmaskKeyIndex = 4

Const csBaseHtmlExt  = ".html"
Const csCoverHtmlPtn = "_FIRST"

'-------------------------------------------------------------------------------------
'v^֏o͂̊jSNX
'-------------------------------------------------------------------------------------
Class Html2Ods
	Dim bIsCScript, bIsWScript
	Dim oRegExp
	Dim oFS, oSysLogFile, oJobLogFile, oWShell, oParamsDict
    Dim excelObj, scalcObj

	Dim bIsLogging						' OL^׸
	Dim bLogToScreen					' ʂɃOo
	Dim bSysLogToFile, bJobLogToFile	' t@CփOo
	Dim strSysLogFileName				' Ot@C
	Dim strTempSysLogFileName			' WindowsTempfBNgɃO܂
	Dim bSysLogInTemp					' EBhTempɃOĂꍇAݒ
	Dim strJobLogFileName				' JobOt@C
	Dim nJobMsgFilter					' JobOt@C^

	Dim strFileName 					' ^t@C
	Dim strPrinterName					' o͐v^
	Dim strOutFileName					' o͐t@C(PDF̂)

	Private Sub Class_Initialize   ' Setup Initialize event.
		Dim strScript

		Set oFS 		= Nothing
		Set oSysLogFile = Nothing
		Set oJobLogFile = Nothing
		Set oWShell 	= Nothing
		Set oParamsDict = Nothing
		Set oRegExp 	= Nothing

		Set excelObj	= Nothing
        Set scalcObj    = Nothing

		bSysLogToFile		= true
		bJobLogToFile		= true
		strSysLogFileName = csEmptyString
		'strSysLogFileName = "D:\temp\test\XXXX"
		bSysLogInTemp	= false
		bLogToScreen = true

		'Call LogMsg(cnDescription, "Begin a New Html2Ods ObjectB", csEmptyString)

		strScript = LCase(WScript.FullName)

		'vbTextCompare = 1
		bIsCScript = ( InStr(1, strScript, "cscript", 1) > 0 )
		bIsWScript = ( InStr(1, strScript, "wscript", 1) > 0 )

		strFileName 	= csEmptyString
		strOutFileName	= csEmptyString
	End Sub

	Private Sub Class_Terminate   ' Setup Terminate event.

		Call LogMsg(cnDescription, "End of Html2Ods ObjectB", csEmptyString)

		'2003/10/15 Excel Close Error ΍
		If NOT excelObj IS Nothing Then
			excelObj.Quit
		End If
		Set excelObj = Nothing

		If Not oSysLogFile Is Nothing Then
			oSysLogFile.Close
			Set oSysLogFile = Nothing
		End If

		If Not oJobLogFile Is Nothing Then
			oJobLogFile.Close
			Set oJobLogFile = Nothing
		End If

		If Not oFS is Nothing Then
			Set oFS = Nothing
		End If

		If Not oWShell Is Nothing Then
			Set oWShell = Nothing
		End If

		If Not oParamsDict Is Nothing Then
			oParamsDict.RemoveAll
			Set oParamsDict = Nothing
		End If

		If Not oRegExp Is Nothing Then
			Set oRegExp = Nothing
		End If
	End Sub

	Sub ParseParams
		Dim dictParams, objArgs
		Dim arrUnnamedParams()
		Dim nKeysMaxIndex, nParamsMaxIndex
		Dim nKeysIndex, nParamsIndex
		Dim strKey, bKeyExisted, bSetToDict, bThisTimeKeySet
		Dim strCurrentKey, strCurrentValue
		Dim nNakedIndex, nUnnamedIndex

		Set dictParams = GetParamsDict()

		Set objArgs = WScript.Arguments
		nKeysMaxIndex = UBound(arrParamsKeys, 1)
		nParamsMaxIndex = objArgs.Count
		bKeyExisted = False
		bSetToDict = False
		strCurrentKey	= csEmptyString
		strCurrentValue = csEmptyString
		nNakedIndex 	= 0
		nUnnamedIndex = 0

		ReDim arrUnnamedParams(nKeysMaxIndex)

		For nParamsIndex = 0 To nParamsMaxIndex - 1 Step 1
			bThisTimeKeySet = False
			If Not bKeyExisted Then
				For Each strKey In arrParamsKeys
					If StrComp(objArgs(nParamsIndex), strKey, 1) = 0 Then
						strCurrentKey	= strKey
						bKeyExisted 	= True
						bThisTimeKeySet = True
						Exit For
					End If
				Next
			End iF

			If Not bKeyExisted Then
				If nUnnamedIndex > nKeysMaxIndex Then
					Exit For
				End If

				arrUnnamedParams(nUnnamedIndex) = objArgs(nParamsIndex)
				nUnnamedIndex = nUnnamedIndex + 1


				bSetToDict = True
			Else
				If Not bThisTimeKeySet Then
					strCurrentValue = objArgs(nParamsIndex)
					bSetToDict = True
				End If
			End If

			If bSetToDict Then
				If Not dictParams.Exists(strCurrentKey) Then
					dictParams.Add strCurrentKey, strCurrentValue
				End If
				strCurrentKey	= csEmptyString
				strCurrentValue = csEmptyString
				bKeyExisted = False
				bSetToDict	= False
			End If
		Next

		' Ұ̏
		nUnnamedIndex = 0
		For nNakedIndex = cnBaseParamsIndex To nKeysMaxIndex Step 1
			strCurrentKey	= arrParamsKeys(nNakedIndex)
			strCurrentValue = arrUnnamedParams(nUnnamedIndex)
			If IsEmpty( strCurrentValue) Then
				Exit For
			End If

			If Not dictParams.Exists(strCurrentKey) Then
				dictParams.Add strCurrentKey, strCurrentValue
				nUnnamedIndex = nUnnamedIndex + 1
			End If
		Next

		Set objArgs = Nothing
		Set dictParams = Nothing
		Erase arrUnnamedParams
	End Sub

	Function GetParamFromKey(strKey, strDefaultVal)
		Dim dictParams
		Set dictParams = GetParamsDict()
		If dictParams.Exists(strKey) Then
			GetParamFromKey = dictParams.Item(strKey)
		Else
			GetParamFromKey = strDefaultVal
		End If
		Set dictParams = Nothing
	End Function

	' FileSystemObject̃t@Ng
	Function GetFS()
		If oFS Is Nothing Then
			Set oFS = WScript.CreateObject("Scripting.FileSystemObject")
		End If

		Set GetFS = oFS
	End Function

	' WShell܂
	Function GetWShell()
		If oWShell Is Nothing Then
			' IE ̃WXgPDFWriterp̏o̓tH_ݒ肷B
			Set oWShell = WScript.CreateObject("WScript.Shell")
		End If

		Set GetWShell = oWShell
	End Function

	' Ұ̏W
	Function GetParamsDict()
		If oParamsDict Is Nothing Then
			Set oParamsDict = WScript.CreateObject("Scripting.Dictionary")
		End If

		Set GetParamsDict = oParamsDict
	End Function

	' Regular Expression (RegExp) Objectg
	Function GetRegExp()
		If oRegExp Is Nothing Then
			Set oRegExp = New RegExp
		End If

		Set GetRegExp = oRegExp
	End Function

	' wSIZE܂łLOGt@CVK
	Function CreateLogFileWithSizeLimit(objFS, strLogName, nFileMaxSize)
		Const ForWriting   = 2
		Const ForAppending = 8

		Dim oFile
		Dim modeIO

		On Error Resume Next 'G[̏

		modeIO	   = ForWriting

		If objFS.FileExists(strLogName) Then
			Set oFile = objFS.GetFile(strLogName)
			If ( Not oFile Is Nothing ) And ( oFile.size < nFileMaxSize ) Then
				modeIO = ForAppending
			End If
			Set oFile = Nothing
		End if

		'Set CreateLogFileWithSizeLimit = objFS.CreateTextFile(strLogName, bOverwrite)
		Set CreateLogFileWithSizeLimit = objFS.OpenTextFile(strLogName, modeIO, True)
	End Function

	'EBhXTempfBNg Log File
	Function CreateLogInSystemTempDir( objFS, strTempLogName)
		Dim tFolder, tPath, tName, tFile
		Const TemporaryFolder = 2

		On Error Resume Next 'G[̏

		Set tFile = Nothing
		Set tFolder = objFS.GetSpecialFolder(TemporaryFolder)
		If Not tFolder Is Nothing Then
			tName =   tFolder.Path & csPathSep & strTempLogName
			strTempSysLogFileName = tName
			'Set tFile = tFolder.CreateTextFile(tName)
			Set tFile = CreateLogFileWithSizeLimit(objFS, tName, cnLogFileMaxSize)
			Set tFolder = Nothing
		End If
		Set CreateLogInSystemTempDir = tFile
		Set tFile = Nothing
	End Function

	'Ot@C܂
	Function CreateSysLogTextFile(strLogName)
		Dim fsObj, oLogFile
		Dim dtNow, strYYYYMMDD, strLogNameInTemp
		Const strExtname = ".log"

		On Error Resume Next 'G[̏

		Set fsObj = GetFS()
		dtNow = Date
		strYYYYMMDD = CStr(Year(dtNow)) _
					& Right("0" & CStr(Month(dtNow)), 2) _
					& Right("0" & CStr(Day(dtNow)), 2)

		If csEmptyString <> strLogName Then
			Set oLogFile = CreateLogFileWithSizeLimit( fsObj, _
									  strLogName & "_" & strYYYYMMDD & strExtname, cnLogFileMaxSize)
		Else
			Set oLogFile = Nothing
		End If

		If oLogFile Is Nothing Then
			bSysLogInTemp = true
			strLogNameInTemp = WScript.ScriptName & "_" & strYYYYMMDD & strExtname

			Set oLogFile = CreateLogInSystemTempDir(fsObj, strLogNameInTemp )
		End IF

		Set fsObj = Nothing

		Set CreateSysLogTextFile = oLogFile
		Set oLogFile = Nothing
	End Function

	' JobOt@C
	Function CreateJobLogTextFile(strLogName)
		Dim fsObj
		On Error Resume Next 'G[̏

		Set fsObj = GetFS()
		Set CreateJobLogTextFile = CreateLogFileWithSizeLimit( fsObj, strLogName , cnLogFileMaxSize)
		Set fsObj = Nothing
	End Function

	'bZ[Wknft@C͉ʂɏo
	Sub LogMsg( nLevel, strMsg, strAddMsg)
		Dim strLogMsg, strLevel

		On Error Resume Next 'G[̏

		Select Case nLevel
			Case cnDescription	 strLevel = csDescription
			Case cnWarning		 strLevel = csWarning
			Case cnError		 strLevel = csError
			Case Else			 strLevel = csProgErr
		End Select

		strLogMsg = FormatDateTime(Now, 0) & strLevel & " " & strMsg & " " & strAddMsg

		'Log To Screen
		If bLogToScreen Then
			If ( nLevel and cnDefaultScreenMsgFilter ) Then
				WScript.Echo strLogMsg
			End If
		End If

		'VXeO Log To File
		If bSysLogToFile Then
			If ( nLevel and cnSysMsgFilter ) Then
				If oSysLogFile Is Nothing Then
					Set oSysLogFile = CreateSysLogTextFile(strSysLogFileName)

					If oSysLogFile Is Nothing Then
						bSysLogToFile = false
						Call LogMsg(cnWarning, "уOt@Cւްo͂ł܂B", csEmptyString)
					Else
						IF bSysLogInTemp Then
							Call LogMsg(cnWarning, "LOGt@CTempɍ܂B", strTempSysLogFileName)
						Else
							Call LogMsg(cnDescription, "LOGt@C܂B", strSysLogFileName)
						End If
					End If
				End If

				If Not oSysLogFile Is Nothing Then
					oSysLogFile.WriteLine(strLogMsg)
				End If
			End If
		End If

		'JobO
		If bJobLogToFile Then
			If ( nLevel and nJobMsgFilter ) Then
				If oJobLogFile Is Nothing Then
					Set oJobLogFile = CreateJobLogTextFile(strJobLogFileName)
					If oJobLogFile Is Nothing Then
						bJobLogToFile = False
						Call LogMsg(cnWarning, "JobOt@Cւްo͂ł܂B", csEmptyString)
					Else
						Call LogMsg(cnDescription, "JobOt@C܂B", strJobLogFileName)
					End If
				End If

				If Not oJobLogFile Is Nothing Then
					oJobLogFile.WriteLine(strLogMsg)
				End If
			End If
		End If
	End Sub

	Function CheckParams()
		Dim blnRet, strText

		blnRet = true

		' ̃`FbNƎ荞
		'ҰParse
		Call ParseParams

		' уOt@C
		strSysLogFileName	= GetParamFromKey(arrParamsKeys(cnSyslogKeyIndex ), csEmptyString)
		strFileName 		= GetParamFromKey(arrParamsKeys(cnHtmlKeyIndex	 ), csEmptyString)
		strOutFileName		= GetParamFromKey(arrParamsKeys(cnOdsKeyIndex	 ), csEmptyString)

		strJobLogFileName	= GetParamFromKey(arrParamsKeys(cnJoblogKeyIndex ), csEmptyString)
		bJobLogToFile		= ( csEmptyString <> strJobLogFileName )
		strText 			= GetParamFromKey(arrParamsKeys(cnJobmaskKeyIndex), cnDefaultJobMsgFilter )
		If IsNumeric(strText) Then
			nJobMsgFilter	= CInt(strText)
		Else
			nJobMsgFilter	= cnDefaultJobMsgFilter
		End If

		If csEmptyString = strFileName Then
			Call LogMsg(cnError, "sۂɓnĂҰsłB", csEmptyString)
			blnRet = false
		Else
			Call LogMsg(cnDescription, "End Parameter ParsingB", csEmptyString)

			' ^t@C̓ǂݍ
			Call LogMsg(cnDescription, "ҰnĂt@CF", strFileName)

			' o͐t@C̓ǂݍ
			Call LogMsg(cnDescription, "ҰnĂo̓t@CF", strOutFileName)

			Call LogMsg(cnDescription, "End Parameter CheckingB", csEmptyString)
		End If

		Call LogMsg(cnDescription, "Begin a New Html2Ods ProcessingB", csEmptyString)

		CheckParams = blnRet

	End Function

	' wPatternŃt@Cʂ
	Function IsPatternFile(strFileName, strPattern)
		' HTMLt@CΉĂȂ
		Dim regEx

		Set regEx = GetRegExp() 				' Create regular expression.
		regEx.Pattern = strPattern				' Set pattern.
		regEx.IgnoreCase = True 				' Set case sensitivity.
		IsPatternFile = regEx.Test(strFileName) ' Execute the search test.
		Set regEx = Nothing
	End Function

	' HTMLt@C𔻕
	Function IsHtmlFile(strFileName)
		IsHtmlFile = IsPatternFile(strFileName, "(htm|html)$")
	End Function

	Function ChangeFileName(strFileName, strNamePattern, strNewName)
		Dim regEx

		Set regEx	= GetRegExp()				' Create regular expression.
		regEx.Pattern	= strNamePattern		' Set pattern.
		regEx.IgnoreCase	= True				' Set case sensitivity.
		ChangeFileName		= regEx.Replace(strFileName, strNewName)
		Set regEx = Nothing
	End Function

	' [NubNo͂
	Function SaveWooksheet(oWorkbook, nFileFormat, strFileOut)
		Dim bSaveStatus

		On Error Resume Next

		' ʂȌ`t@Cۑ
		oWorkbook.SaveAs strFileOut, nFileFormat, "", "", False, False

		bSaveStatus = ( Err.Number = 0 )
		If bSaveStatus Then
			Call LogMsg(cnDescription, "t@Cۑ܂B", strFileOut)
		Else
			Call LogMsg(cnError, Err.Description, csEmptyString)
		End If

		SaveWooksheet = bSaveStatus
	End Function

	Function SetWorksheetsName(oWorkbook, strFileName)
		Dim oWorksheets
		Dim bRet, nCount, nIndex
		Dim strFileBaseName

		bRet = True
		strFileBaseName = csEmptyString
		If Not ( oWorkbook Is Nothing ) Then

			nIndex = InStrRev(strFileName, csPathSep, -1, 1)
			If nIndex > 0 Then
				strFileBaseName = Mid(strFileName, nIndex + 1 )
			Else
				strFileBaseName = strFileName
			End If
			nIndex = InStr(1, strFileBaseName, csExtSep, 1)
			If nIndex > 0 Then
				strFileBaseName = Left(strFileBaseName, nIndex - 1 )
			End If

			If csEmptyString <> strFileBaseName Then
				Set oWorksheets = oWorkbook.Worksheets
				nCount = oWorksheets.Count
				For nIndex = 1 To nCount Step 1
    				If 1 = nCount Then
                        If InStr(strFileBaseName, csCoverHtmlPtn) > 0 Then
    					    oWorksheets(1).Name = Mid(csCoverHtmlPtn, 2)
                        Else
    					    oWorksheets(1).Name = strFileBaseName
                        End If
    				Else
    					oWorksheets(nIndex).Name = strFileBaseName & "(" & CStr(nIndex) & ")"
    				End If
				Next

				Set oWorksheets = Nothing
			End If
		End If

		SetWorksheetsName = bRet
	End Function

	' ̃[NubN܂
	Function ConbineHtmlToOneWorkbook(oExcel, oMainWorkbook, strHtmlFilename, strCoverHtml)
		Dim oInternalWorkbook, oSlaveWorkbook
		Dim strRealHtmlFile
		Dim bRet

		On Error Resume Next
		Set ConbineHtmlToOneWorkbook = Nothing

    	strRealHtmlFile = strHtmlFilename

		Set oInternalWorkbook = Nothing
		If oMainWorkbook Is Nothing Then
    		Set oInternalWorkbook = oExcel.Workbooks.Open(strRealHtmlFile, , true)
            If Not (oInternalWorkbook Is Nothing) Then
    			Call SetWorksheetsName(oInternalWorkbook, strRealHtmlFile)
    			If csEmptyString <> strCoverHtml Then
    				Set oSlaveWorkbook		= oExcel.Workbooks.Open(strCoverHtml, , true)
                    If Not (oSlaveWorkbook Is Nothing) Then
            			Call SetWorksheetsName(oSlaveWorkbook, strCoverHtml)
        				Call oSlaveWorkbook.Worksheets.Move(oInternalWorkbook.Worksheets(1))
                    End If
    			End If
            End If
			bRet = ( 0 = Err.Number  )
			If Not bRet Then
				Call LogMsg(cnError, Err.Description, csEmptyString)
			End If
		Else
			Set oSlaveWorkbook = oExcel.Workbooks.Open(strCoverHtml, , true)
            If Not (oSlaveWorkbook Is Nothing) Then
    			Call oSlaveWorkbook.Worksheets.Move(, oMainWorkbook.Worksheets(oMainWorkbook.Worksheets.Count))
    			Set oSlaveWorkbook = oExcel.Workbooks.Open(strRealHtmlFile, , true)
            End If
			bRet = ( Err.Number = 0 )
			If Not bRet Then
				Call LogMsg(cnError, Err.Description, csEmptyString)
			Else
				Call SetWorksheetsName(oSlaveWorkbook, strRealHtmlFile)
				Call oSlaveWorkbook.Worksheets.Move(, oMainWorkbook.Worksheets(oMainWorkbook.Worksheets.Count))

				bRet = ( Err.Number = 0 )
				If Not bRet Then
					Call LogMsg(cnError, Err.Description, csEmptyString)
				End If

				Set oInternalWorkbook = oMainWorkbook
			End If
			
			If Not bRet Then oMainWorkbook.Close( False )
		End if

		If bRet Then
			Set ConbineHtmlToOneWorkbook = oInternalWorkbook
			Call LogMsg(cnDescription, "ExcelɃt@CLoad܂B", strRealHtmlFile)
		End If
		Set oSlaveWorkbook = Nothing
		Set oInternalWorkbook = Nothing

	End Function

	' PDFst@Cɑ΂鏈̂߂̃Tu[`
	Function File2Ods(oExcel, oScalc, fileIn, fileOut)
		Dim oWorkBook, fsObj, fIn, sInName, xlsSpec, outSpec
		Dim bRet, strBaseHtmlFile, strCoverHtmlFile

		bRet = True

		On Error Resume Next

		Call LogMsg(cnDescription, "ExcelŃt@CJn߂܂c", fileIn)

		Set fsObj = GetFS()
        set fIn = fsObj.GetFile(fileIn)

        outSpec = fileOut
        If csEmptyString = outSpec Then
            outSpec = ChangeFileName(fIn.Path, "[^\.]+$", "ods")
        End If
        sInName = fIn.Name
        Set fIn   = Nothing

	    If fsObj.FolderExists(outSpec) Then
            xlsSpec = outSpec & "\" & ChangeFileName(sInName, "(htm|html)$", "xls")
        Else
            xlsSpec = ChangeFileName(outSpec, "[^\.]+$", "xls")
        End If

        strCoverHtmlFile = ChangeFileName(fileIn, "(\.(htm|html))$",  csCoverHtmlPtn & "$1")
        if Not fsObj.FileExists(strCoverHtmlFile) Then 
            strCoverHtmlFile = csEmptyString
    		Call LogMsg(cnDescription, "Jo[܂B", fileIn)
        End If

		Set fsObj = Nothing

		'Set oWorkBook = oExcel.Workbooks.Open(fileIn, , true)
		Set oWorkBook = ConbineHtmlToOneWorkbook(oExcel, Nothing, fileIn, strCoverHtmlFile)
		If oWorkBook Is Nothing Then
			Call LogMsg(cnError, "t@CExcelŊJ܂łB", fileIn)
			bRet = False
		Else
			'xlstBo
			'Const xlNormal = -4143
			bRet = SaveWooksheet(oWorkbook, -4143, xlsSpec)
			oWorkBook.Close( false )
			Set oWorkBook = Nothing
		End IF

		File2Ods = bRet
	End Function

	' PDFst@Cɑ΂鏈̂߂̃Tu[`
	Function Dir2Ods(oExcel, oScalc, pathIn, filePattern, fileOut)
		Dim fsObj, folderObj, fileObj
		Dim oWorkBook
		Dim strSingleFileName, strRealPattern, strBaseHtmlFile
		Dim bPatternFile, bHasPattern
		Dim bRet

		bRet = True

		On Error Resume Next

		Set oWorkBook = Nothing

		bHasPattern = ( csEmptyString <> filePattern )
		If bHasPattern Then
			strRealPattern = Replace(filePattern,	 ".", "\.", 1, -1, 1)
			strRealPattern = Replace(strRealPattern, "*", ".*", 1, -1, 1)
		End If

		Call LogMsg(cnDescription, "fBNgɃt@C̃veOn߂܂c", pathIn)
		Set fsObj = GetFS()
		Set folderObj = fsObj.GetFolder(pathIn)

		For Each fileObj In folderObj.Files
			strSingleFileName = pathIn & csPathSep & fileObj.Name
			If Not IsHtmlFile(strSingleFileName) Then
				' ɃG[łȂBʂްꍇɁAHTMLt@C܂
				Call LogMsg(cnWarning, "HTMLłȂt@Cł܂(Ή)B", strSingleFileName)
			Else
                bPatternFile = True
                If bHasPattern Then
    				bPatternFile = IsPatternFile(strSingleFileName, strRealPattern )
                    'Skip _FIRST.htm(l)t@C
    				If bPatternFile Then
                        bPatternFile = (InStr(fileObj.Name, csCoverHtmlPtn) = 0)
    				End If
                End If

				If bPatternFile Then
    				bRet = File2Ods(oExcel, oScalc, strSingleFileName, fileOut)
    				If Not bRet Then Exit For
				End If
			End If
		Next
		Set folderObj = Nothing
		Set fsObj = Nothing

		Dir2Ods = bRet
	End Function

	'w肳ꂽt@C̃t@C
	Function PrintData( strFileName, strPrinterName, strOutFileName )
		Dim fsObj
		Dim strPathName, strFilePattern, nIndex
		Dim blnRet

		blnRet = true

		On Error Resume Next 'G[̏

		Call LogMsg(cnDescription, "ExcelN܂c", csEmptyString)

		Set excelObj = WScript.CreateObject("Excel.Application")

		If excelObj Is Nothing Then
			Call LogMsg(cnError, "ExcelNł܂łB", csEmptyString)
			blnRet = False
		else

			excelObj.Visible = False
			'excelObj.Visible = True
			' r̃_AOo
			excelObj.DisplayAlerts = False

			Set fsObj = GetFS()

			If ( fsObj.FileExists(strFileName) ) Then
				If Not IsHtmlFile(strFileName) Then
					Call LogMsg(cnError, "HTMLłȂt@Cł܂(Ή)B", strFileName)
					blnRet = False
				Else
					Call LogMsg(cnDescription, "t@C̃veOn܂܂c", strFileName)
					blnRet = File2Ods(excelObj, strPrinterName, strFileName,  strOutFileName)
				End If
			Else
				If fsObj.FolderExists(strFileName) Then
					strPathName 	= strFileName
					strFilePattern	= "*" & csBaseHtmlExt
                Else
    				'C:\temp\Test*.html悤Ȍ`t@CɑΉ
    				nIndex = InStrRev(strFileName, csPathSep, -1, 1)
    				If nIndex > 0 Then
    					strPathName 	= Left(strFileName, nIndex - 1)
    					'fBNgɕvNOHTMLt@C
    					strFilePattern	= Mid(strFileName, nIndex + 1 )
    				End If
                End If

				If csEmptyString <> strPathName Then
					If fsObj.FolderExists(strPathName) Then
						blnRet = Dir2Ods(excelObj, strPrinterName, strPathName, strFilePattern,  strOutFileName)
					End If
				Else
					Call LogMsg(cnError, "t@C݂͑܂B", strFileName)
					blnRet = false
				End If
			End IF

			Set fsObj = Nothing

			If NOT excelObj IS Nothing Then
				excelObj.Quit
			End If
			Set excelObj = Nothing
			Call LogMsg(cnDescription, "End of Excel CloseB", csEmptyString)
		End if

		PrintData = blnRet
	End Function

	Public Function Print()
		Dim nRet

		nRet = 0
		If Not CheckParams() Then
			nRet = 1
		ElseIf Not PrintData( strFileName, strPrinterName, strOutFileName ) then
			nRet = 2
		End if
		Print = nRet
	End Function

End Class

'-------------------------------------------------------------------------------------
'vOs
'-------------------------------------------------------------------------------------
Set oHtml2Ods = New Html2Ods	' Create an instance of TestClass.
nRetVal = oHtml2Ods.Print()		' Print Data
Set oHtml2Ods = Nothing			' Destroy the instance.

'-------------------------------------------------------------------------------------
'vOI
'-------------------------------------------------------------------------------------
'WScript.Sleep( 10000 )
WScript.Quit( nRetVal )
