/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opengion.fukurou.model.ExcelModel;
import org.opengion.fukurou.model.JacobUtil;
import org.opengion.fukurou.model.POIUtil;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class ExcelFileTag
extends CommonTagSupport {
    private static final String VERSION = "6.4.5.2 (2016/05/06)";
    private static final long serialVersionUID = 645220160506L;
    private TypeEnum valueType = TypeEnum.CSV;
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String file1;
    private String file2;
    private String sheetName;
    private String sheetNos;
    private String sheetConstKeys;
    private String sheetConstAdrs;
    private boolean useActiveWorkbook;
    private String addTitleSheet;
    private String addImageFile;
    private String readText;
    private String readSheet;
    private String readName;
    private String readStyle;
    private boolean useConverter;
    private String convFile;
    private String convMap;
    private String saveAs;
    private String toPrint;
    private String scope = "request";

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.useTag()) {
            super.setScope(this.scope);
            String string = HybsSystem.url2dir(this.fileURL);
            File file = new File(StringUtil.urlAppend((CharSequence)string, (CharSequence[])new CharSequence[]{this.file1}));
            if (this.toPrint == null) {
                if (this.saveAs == null) {
                    ExcelModel excelModel = new ExcelModel(file);
                    if (this.addTitleSheet != null) {
                        excelModel.setAddTitleSheet(this.addTitleSheet);
                    }
                    if (this.addImageFile != null) {
                        this.putImageFile(excelModel);
                    }
                    if (this.readText != null) {
                        this.setObject(this.readText, this.getExcelText(excelModel));
                    }
                    if (this.readSheet != null) {
                        this.setAttriObject(this.readSheet, excelModel.getSheetNames());
                    }
                    if (this.readName != null) {
                        this.setAttriObject(this.readName, excelModel.getNames());
                    }
                    if (this.readStyle != null) {
                        this.setAttriObject(this.readStyle, excelModel.getStyleNames());
                    }
                    if (this.sheetConstKeys != null && this.sheetConstAdrs != null) {
                        this.sheetConstSet(excelModel);
                    }
                    if (this.useConverter) {
                        this.textConverter(excelModel);
                    }
                    if (this.useActiveWorkbook) {
                        excelModel.activeWorkbook(true);
                    }
                    if (this.file2 != null) {
                        File file2 = new File(StringUtil.urlAppend((CharSequence)string, (CharSequence[])new CharSequence[]{this.file2}));
                        excelModel.saveFile(file2);
                    }
                } else {
                    if (this.file2 != null) {
                        String string2 = "file2\u3068saveAs\u306f\u3001\u540c\u6642\u306b\u6307\u5b9a\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + CR + "  file2=[" + this.file2 + "] , saveAs=[" + this.saveAs + "]";
                        throw new HybsSystemException(string2);
                    }
                    File file3 = new File(StringUtil.urlAppend((CharSequence)string, (CharSequence[])new CharSequence[]{this.saveAs}));
                    JacobUtil.saveAs((File)file, (File)file3);
                }
            } else {
                JacobUtil.toPrint((File)file, (String)this.toPrint);
            }
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.valueType = TypeEnum.CSV;
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.file1 = null;
        this.file2 = null;
        this.sheetName = null;
        this.sheetNos = null;
        this.sheetConstKeys = null;
        this.sheetConstAdrs = null;
        this.useActiveWorkbook = false;
        this.addTitleSheet = null;
        this.addImageFile = null;
        this.readText = null;
        this.readSheet = null;
        this.readName = null;
        this.readStyle = null;
        this.useConverter = false;
        this.convFile = null;
        this.convMap = null;
        this.saveAs = null;
        this.toPrint = null;
        this.scope = "request";
    }

    private void putImageFile(ExcelModel excelModel) {
        String[] stringArray = this.addImageFile.split(" ");
        String[] stringArray2 = Arrays.copyOf(stringArray, 10);
        String string = StringUtil.nval((String)stringArray2[0], null);
        int n = StringUtil.nval((String)stringArray2[1], (int)0);
        int n2 = StringUtil.nval((String)stringArray2[2], (int)0);
        int n3 = StringUtil.nval((String)stringArray2[3], (int)0);
        int n4 = StringUtil.nval((String)stringArray2[4], (int)n2);
        int n5 = StringUtil.nval((String)stringArray2[5], (int)n3);
        int n6 = StringUtil.nval((String)stringArray2[6], (int)0);
        int n7 = StringUtil.nval((String)stringArray2[7], (int)0);
        int n8 = StringUtil.nval((String)stringArray2[8], (int)0);
        int n9 = StringUtil.nval((String)stringArray2[9], (int)0);
        excelModel.addImageFile(string, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    private String getExcelText(ExcelModel excelModel) {
        StringBuilder stringBuilder = new StringBuilder(500);
        excelModel.textConverter((string, string2) -> {
            if (string != null) {
                stringBuilder.append((String)string).append(CR);
            }
            return null;
        });
        return stringBuilder.toString();
    }

    private void sheetConstSet(ExcelModel excelModel) {
        int n;
        Object object;
        Map<String, String> map = this.getCSVParameter(this.sheetConstKeys, this.sheetConstAdrs);
        int n2 = map.size();
        String[] stringArray2 = new String[n2];
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n3 = 0;
        for (Map.Entry<String, String> stringArray3 : map.entrySet()) {
            stringArray2[n3] = stringArray3.getKey();
            String n4 = stringArray3.getValue();
            object = POIUtil.kigo2rowCol((String)n4);
            nArray[n3] = (int)object[0];
            nArray2[n3] = (int)object[1];
            ++n3;
        }
        int n4 = excelModel.getNumberOfSheets();
        String[][] stringArray = new String[n2][n4];
        for (n = 0; n < n4; ++n) {
            object = excelModel.getSheetName(n);
            for (int i = 0; i < n2; ++i) {
                stringArray[i][n] = nArray[i] < 0 ? object : excelModel.getValue(nArray[i], nArray2[i]);
            }
        }
        for (n = 0; n < n2; ++n) {
            this.setAttriObject(stringArray2[n], stringArray[n]);
        }
    }

    private void textConverter(ExcelModel excelModel) {
        LinkedHashMap<String, String> linkedHashMap = null;
        if (this.convFile == null) {
            if (this.convMap != null) {
                linkedHashMap = (LinkedHashMap<String, String>)this.getObject(this.convMap);
            }
        } else {
            String string = HybsSystem.url2dir(this.fileURL, this.convFile);
            List list = FileUtil.getLineList((String)string, (String)"UTF-8");
            int n = list.size();
            linkedHashMap = new LinkedHashMap<String, String>();
            for (String string2 : list) {
                int n2 = string2.indexOf(9);
                if (n2 <= 0) continue;
                String string3 = string2.substring(0, n2);
                String string4 = string2.substring(n2 + 1);
                linkedHashMap.put(string3, string4);
            }
        }
        if (linkedHashMap != null) {
            excelModel.textConverter(linkedHashMap);
        }
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.fileURL = StringUtil.urlAppend((CharSequence)this.fileURL, (CharSequence[])new CharSequence[]{string2});
        }
    }

    public void setFile1(String string) {
        this.file1 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.file1);
    }

    public void setFile2(String string) {
        this.file2 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.file2);
    }

    public void setSheetName(String string) {
        this.sheetName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sheetName);
    }

    public void setSheetNos(String string) {
        this.sheetNos = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sheetNos);
        if (this.sheetNos != null && this.sheetNos.length() > 0) {
            boolean bl = false;
            for (int i = 0; i < this.sheetNos.length(); ++i) {
                char c = this.sheetNos.charAt(i);
                if (c == '-' || c == ',' || c == '*' && (i == 0 || i == this.sheetNos.length() - 1) || c >= '0' && c <= '9') continue;
                bl = true;
                break;
            }
            if (bl) {
                String string2 = "sheetNos \u306e\u6307\u5b9a\u3092\u898b\u76f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002sheetNos=[" + this.sheetNos + "]";
                throw new HybsSystemException(string2);
            }
        }
    }

    public void setSheetConstKeys(String string) {
        this.sheetConstKeys = string;
    }

    public void setSheetConstAdrs(String string) {
        this.sheetConstAdrs = string;
    }

    public void setUseActiveWorkbook(String string) {
        this.useActiveWorkbook = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useActiveWorkbook);
    }

    public void setAddTitleSheet(String string) {
        this.addTitleSheet = StringUtil.nval((String)this.getRequestParameter(string), (String)this.addTitleSheet);
    }

    public void setAddImageFile(String string) {
        this.addImageFile = StringUtil.nval((String)this.getRequestParameter(string), (String)this.addImageFile);
    }

    public void setValueType(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.valueType = TypeEnum.valueOf(string2);
        }
    }

    public void setReadText(String string) {
        this.readText = StringUtil.nval((String)this.getRequestParameter(string), (String)this.readText);
    }

    public void setReadSheet(String string) {
        this.readSheet = StringUtil.nval((String)this.getRequestParameter(string), (String)this.readSheet);
    }

    public void setReadName(String string) {
        this.readName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.readName);
    }

    public void setReadStyle(String string) {
        this.readStyle = StringUtil.nval((String)this.getRequestParameter(string), (String)this.readStyle);
    }

    public void setUseConverter(String string) {
        this.useConverter = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useConverter);
    }

    public void setConvFile(String string) {
        this.convFile = StringUtil.nval((String)this.getRequestParameter(string), (String)this.convFile);
    }

    public void setConvMap(String string) {
        this.convMap = StringUtil.nval((String)this.getRequestParameter(string), (String)this.convMap);
    }

    public void setSaveAs(String string) {
        this.saveAs = StringUtil.nval((String)this.getRequestParameter(string), (String)this.saveAs);
    }

    public void setToPrint(String string) {
        this.toPrint = StringUtil.nval((String)this.getRequestParameter(string), (String)this.toPrint);
    }

    @Override
    public void setScope(String string) {
        this.scope = StringUtil.nval((String)this.getRequestParameter(string), (String)this.scope);
    }

    private void setAttriObject(String string, String[] stringArray) {
        if (this.valueType == TypeEnum.LIST) {
            this.setObject(string, Arrays.asList(stringArray));
        } else {
            this.setObject(string, StringUtil.array2csv((String[])stringArray));
        }
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("fileURL", (Object)this.fileURL).println("file1", (Object)this.file1).println("file2", (Object)this.file2).println("sheetName", (Object)this.sheetName).println("sheetNos", (Object)this.sheetNos).println("sheetConstKeys", (Object)this.sheetConstKeys).println("sheetConstAdrs", (Object)this.sheetConstAdrs).println("useActiveWorkbook", (Object)this.useActiveWorkbook).println("addTitleSheet", (Object)this.addTitleSheet).println("addImageFile", (Object)this.addImageFile).println("valueType", (Object)this.valueType).println("readText", (Object)this.readText).println("readSheet", (Object)this.readSheet).println("readName", (Object)this.readName).println("readStyle", (Object)this.readStyle).println("useConverter", (Object)this.useConverter).println("convFile", (Object)this.convFile).println("convMap", (Object)this.convMap).println("saveAs", (Object)this.saveAs).println("toPrint", (Object)this.toPrint).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }

    private static enum TypeEnum {
        CSV,
        LIST,
        MAP;

    }
}

