/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLConnection;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.URLConnect;

public class SOAPConnect
extends URLConnect {
    private static final String CONTENT_TYPE = "text/xml;charset=UTF-8";
    private static final String ACCEPT = "text/xml, multipart/related, text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    private final String nameSpace;
    private final String methodName;

    public SOAPConnect(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2) {
        this(string, string2, string3, string4, SOAPConnect.makeParamData(stringArray, stringArray2));
    }

    public SOAPConnect(String string, String string2, String string3, String string4, String string5) {
        super(string, string2);
        this.nameSpace = string3;
        this.methodName = string4;
        this.setPostData(this.getSoapEnvelop(string5));
    }

    @Override
    protected URLConnection getConnection() throws IOException {
        URLConnection uRLConnection = super.getConnection();
        uRLConnection.setRequestProperty("Content-Type", CONTENT_TYPE);
        uRLConnection.setRequestProperty("Accept", ACCEPT);
        uRLConnection.setRequestProperty("Soapaction", "\"" + this.nameSpace + this.methodName + "\"");
        return uRLConnection;
    }

    private String getSoapEnvelop(String string) {
        StringBuilder stringBuilder = new StringBuilder(200).append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>").append("<env:Envelope ").append(" xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\" ").append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><env:Body>").append("<tns:").append(this.methodName).append(" xmlns:tns=\"").append(this.nameSpace).append("\">").append(string).append("</tns:").append(this.methodName).append('>').append("</env:Body></env:Envelope>");
        return stringBuilder.toString();
    }

    private static final String makeParamData(String[] stringArray, String[] stringArray2) {
        StringBuilder stringBuilder = new StringBuilder(200);
        String string = null;
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray3 = StringUtil.csv2Array(stringArray[i], '>');
            if (stringArray3.length > 2) {
                throw new OgRuntimeException("keys,vals\u5f62\u5f0f\u3067\u306f2\u968e\u5c64\u307e\u3067\u306e\u30c7\u30fc\u30bf\u306e\u307f\u3092\u5b9a\u7fa9\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u30023\u968e\u5c64\u4ee5\u4e0a\u306e\u30c7\u30fc\u30bf\u306b\u95a2\u3057\u3066\u306f\u3001\u76f4\u63a5XML\u3067\u30e1\u30bd\u30c3\u30c9\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u3092\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002");
            }
            if (!(string == null || stringArray3.length != 1 && string.equals(stringArray3[0]))) {
                stringBuilder.append(SOAPConnect.getKeyTag(string, true));
            }
            if (stringArray3.length > 1) {
                if (string == null || !string.equals(stringArray3[0])) {
                    stringBuilder.append(SOAPConnect.getKeyTag(stringArray3[0], false));
                }
                string2 = stringArray3[1];
                string = stringArray3[0];
            } else {
                string2 = stringArray3[0];
                string = null;
            }
            if ("null".equals(stringArray2[i])) {
                stringBuilder.append(SOAPConnect.getKeyTag(string2, false, "xsi:nil=\"true\""));
            } else {
                stringBuilder.append(SOAPConnect.getKeyTag(string2, false)).append(stringArray2[i]);
            }
            stringBuilder.append(SOAPConnect.getKeyTag(string2, true));
        }
        if (string != null) {
            stringBuilder.append(SOAPConnect.getKeyTag(string, true));
        }
        return stringBuilder.toString();
    }

    private static final String getKeyTag(String string, boolean bl) {
        return SOAPConnect.getKeyTag(string, bl, null);
    }

    private static final String getKeyTag(String string, boolean bl, String string2) {
        String string3;
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append('<');
        if (bl) {
            stringBuilder.append('/');
        }
        boolean bl2 = string.charAt(0) == '@';
        String string4 = string3 = bl2 ? string.substring(1) : string;
        if (bl2) {
            stringBuilder.append("tns:");
        }
        stringBuilder.append(string3);
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(' ').append(string2);
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        SOAPConnect sOAPConnect;
        String string;
        if (stringArray.length < 3) {
            LogWriter.log("Usage: java org.opengion.fukurou.util.SOAPConnect [-info/-data] \u2026 url [user:passwd]");
            LogWriter.log("   args[*] : [-info/-data]      \u60c5\u5831\u306e\u53d6\u5f97\u304b\u3001\u30c7\u30fc\u30bf\u306e\u53d6\u5f97\u304b\u3092\u6307\u5b9a\u3057\u307e\u3059(\u521d\u671f\u5024:-data)\u3002");
            LogWriter.log("   args[*] : [-data=\u30d5\u30a1\u30a4\u30eb\u540d] \u9001\u4fe1\u3059\u308b\u30c7\u30fc\u30bf\u304c\u8a18\u8ff0\u3055\u308c\u305fXML\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
            LogWriter.log("   args[*] : [-out=\u30d5\u30a1\u30a4\u30eb\u540d]  \u7d50\u679c\u3092\u30d5\u30a1\u30a4\u30eb\u306b\u51fa\u529b\u3057\u307e\u3059\u3002\u30d5\u30a1\u30a4\u30eb\u30a8\u30f3\u30b3\u30fc\u30c9\u3082\u6307\u5b9a\u3057\u307e\u3059\u3002");
            LogWriter.log("   args[*] : [-nameSpace=\u540d\u524d\u7a7a\u9593]    \u30e1\u30bd\u30c3\u30c9\u540d\u53ca\u3073\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u306e\u540d\u524d\u7a7a\u9593\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
            LogWriter.log("   args[*] : [-methodName=\u30e1\u30bd\u30c3\u30c9\u540d] \u30e1\u30bd\u30c3\u30c9\u540d\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
            LogWriter.log("   args[*] : [-keys=\u30ad\u30fc\u4e00\u89a7]   \u30e1\u30bd\u30c3\u30c9\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u306e\u30ad\u30fc\u4e00\u89a7\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002(data\u3092\u6307\u5b9a\u3057\u305f\u5834\u5408\u306f\u7121\u8996\u3055\u308c\u307e\u3059)");
            LogWriter.log("   args[*] : [-vals=\u5024\u4e00\u89a7]     \u30e1\u30bd\u30c3\u30c9\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u306e\u5024\u4e00\u89a7\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002  (data\u3092\u6307\u5b9a\u3057\u305f\u5834\u5408\u306f\u7121\u8996\u3055\u308c\u307e\u3059)");
            LogWriter.log("   args[A] : url                \uff35\uff32\uff2c\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002GET\u306e\u5834\u5408\u3001\u30d1\u30e9\u30e1\u30fc\u30bf\u306f ?KEY=VAL\u3067\u3059\u3002");
            LogWriter.log("   args[B] : [user:passwd]      BASIC\u8a8d\u8a3c\u306e\u30a8\u30ea\u30a2\u3078\u306e\u30a2\u30af\u30bb\u30b9\u6642\u306b\u6307\u5b9a\u3057\u307e\u3059\u3002");
            return;
        }
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = new String[2];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            if ("-info".equalsIgnoreCase(string)) {
                bl = true;
                continue;
            }
            if ("-data".equalsIgnoreCase(string)) {
                bl = false;
                continue;
            }
            if (string.startsWith("-post=")) {
                string2 = string.substring(6);
                continue;
            }
            if (string.startsWith("-out=")) {
                string3 = string.substring(5);
                continue;
            }
            if (string.startsWith("-nameSpace=")) {
                string4 = string.substring(11);
                continue;
            }
            if (string.startsWith("-methodName=")) {
                string5 = string.substring(12);
                continue;
            }
            if (string.startsWith("-keys=")) {
                stringArray2 = StringUtil.csv2Array(string.substring(6));
                continue;
            }
            if (string.startsWith("-vals=")) {
                stringArray3 = StringUtil.csv2Array(string.substring(6));
                continue;
            }
            if (StringUtil.startsChar(string, '-')) {
                System.out.println("Error Argment:" + string);
                continue;
            }
            stringArray4[n++] = string;
        }
        String string6 = stringArray4[0];
        string = stringArray4[1];
        if (string2 == null) {
            sOAPConnect = new SOAPConnect(string6, string, string4, string5, stringArray2, stringArray3);
        } else {
            object = FileUtil.getValue(string2, "UTF-8");
            sOAPConnect = new SOAPConnect(string6, string, string4, string5, (String)object);
        }
        sOAPConnect.connect();
        Object object2 = object = string3 == null ? FileUtil.getLogWriter("System.out") : FileUtil.getPrintWriter(new File(string3), "UTF-8");
        if (bl) {
            ((PrintWriter)object).println("URL    :" + sOAPConnect.getUrl());
            ((PrintWriter)object).println("Type   :" + sOAPConnect.getType());
            ((PrintWriter)object).println("Code   :" + sOAPConnect.getCode());
            ((PrintWriter)object).println("Message:" + sOAPConnect.getMessage());
            ((PrintWriter)object).println("Charset:" + sOAPConnect.getCharset());
        } else {
            ((PrintWriter)object).println(sOAPConnect.readData());
        }
        sOAPConnect.disconnect();
        Closer.ioClose((Closeable)object);
    }
}

