/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.common;

import java.io.IOException;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.WebListener;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.URLConnect;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.SystemManager;
import org.opengion.hayabusa.common.SystemParameter;

@WebListener
public class HybsContextListener
implements ServletContextListener,
ContainerListener {
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        Map<String, String> map = SystemParameter.makeSystemParameter(servletContext);
        HybsSystem.setInitialData(map);
        LogWriter.init((String)HybsSystem.url2dir(System.getProperty("SYS_LOG_URL", HybsSystem.sys("SYS_LOG_URL")), new String[0]));
        new Thread(new InitialCallURL()).start();
        System.out.println("-------");
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        String string = HybsSystem.sys("CONTEXT_NAME");
        System.out.println("Context Destroyed [" + string + "]  " + new Date());
        SystemManager.clearGE12();
        SystemManager.allClear(true);
        SystemManager.sessionDestroyed();
        SystemManager.deleteGUIAccessInfo();
        System.out.println("-------");
    }

    public void containerEvent(ContainerEvent containerEvent) {
        System.out.println("\u3010ContainerEvent:" + containerEvent.getType() + " : " + containerEvent.toString() + "\u3011");
    }

    private void addRegistration(ServletContext servletContext) {
        FilterRegistration.Dynamic dynamic = servletContext.addFilter("AccessStopFilter", "org.opengion.hayabusa.filter.AccessStopFilter");
        dynamic.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/jsp/*"});
        FilterRegistration.Dynamic dynamic2 = servletContext.addFilter("GZIPFilter", "org.opengion.hayabusa.filter.GZIPFilter");
        dynamic2.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/jsp/*"});
        FilterRegistration.Dynamic dynamic3 = servletContext.addFilter("FileFilter", "org.opengion.hayabusa.filter.FileFilter");
        dynamic3.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/jsp/*"});
        FilterRegistration.Dynamic dynamic4 = servletContext.addFilter("URLCheckFilter", "org.opengion.hayabusa.filter.URLCheckFilter");
        dynamic4.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/jsp/*"});
        FilterRegistration.Dynamic dynamic5 = servletContext.addFilter("URLHashFilter", "org.opengion.hayabusa.filter.URLHashFilter");
        dynamic5.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"*.jsp"});
        ServletRegistration.Dynamic dynamic6 = servletContext.addServlet("fileDownload", "org.opengion.hayabusa.servlet.FileDownload");
        dynamic6.addMapping(new String[]{"/jsp/fileDownload"});
        ServletRegistration.Dynamic dynamic7 = servletContext.addServlet("admin", "org.opengion.hayabusa.servlet.HybsAdmin");
        dynamic7.addMapping(new String[]{"/jsp/admin"});
        ServletRegistration.Dynamic dynamic8 = servletContext.addServlet("makeImage", "org.opengion.hayabusa.servlet.MakeImage");
        dynamic8.addMapping(new String[]{"/jsp/makeImage"});
        ServletRegistration.Dynamic dynamic9 = servletContext.addServlet("remoteControl", "org.opengion.hayabusa.servlet.RemoteControlServlet");
        dynamic9.addMapping(new String[]{"/servlet/remoteControl"});
    }

    static {
        Cleanable cleanable = new Cleanable(){

            public void clear() {
                ConnectionFactory.realClose();
            }
        };
        SystemManager.addCleanable(cleanable);
    }

    private static final class InitialCallURL
    implements Runnable {
        private InitialCallURL() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                LogWriter.log((String)("InterruptedException:" + interruptedException.getMessage()));
            }
            HybsEntry[] hybsEntryArray = HybsSystem.sysEntry("CONTEXT_INITIAL_CALL_URL");
            String string = HybsSystem.sys("CONTEXT_INITIAL_CALL_USERPASS");
            boolean bl = false;
            for (int i = 0; i < hybsEntryArray.length; ++i) {
                String string2 = hybsEntryArray[i].getValue();
                if (string2 == null || string2.isEmpty()) continue;
                URLConnect uRLConnect = new URLConnect(string2, string);
                try {
                    uRLConnect.connect();
                    String string3 = uRLConnect.getCode() + ":" + uRLConnect.getMessage();
                    uRLConnect.disconnect();
                    System.out.println("    URL[" + i + "]:" + string2);
                    System.out.println("           " + string3);
                    bl = true;
                    continue;
                }
                catch (IOException iOException) {
                    LogWriter.log((String)("    URL[" + i + "]:" + string2));
                    LogWriter.log((String)("           " + iOException.getMessage()));
                }
            }
            if (bl) {
                System.out.println("  CONTEXT_INITIAL_CALL_URL");
                System.out.println("-------");
            }
        }
    }
}

