/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.SystemManager;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;

public final class DBCellFactory {
    private static final String DEFAULT_RENDERER = "LABEL";
    private static final String DEFAULT_EDITOR = "TEXT";
    private static final ConcurrentMap<String, CellRenderer> REN_MAP = new ConcurrentHashMap<String, CellRenderer>();
    private static final ConcurrentMap<String, CellEditor> EDT_MAP = new ConcurrentHashMap<String, CellEditor>();

    private DBCellFactory() {
    }

    public static CellRenderer newRenderer(String string2, DBColumn dBColumn) {
        String string3 = string2 == null ? DEFAULT_RENDERER : string2.toUpperCase(Locale.JAPAN);
        CellRenderer cellRenderer = REN_MAP.computeIfAbsent(string3, string -> (CellRenderer)HybsSystem.newInstance("Renderer_", string));
        return cellRenderer.newInstance(dBColumn);
    }

    public static CellEditor newEditor(String string2, DBColumn dBColumn) {
        String string3 = string2 == null ? DEFAULT_EDITOR : string2.toUpperCase(Locale.JAPAN);
        return EDT_MAP.computeIfAbsent(string3, string -> (CellEditor)HybsSystem.newInstance("Editor_", string)).newInstance(dBColumn);
    }

    public static void clear() {
        REN_MAP.clear();
        EDT_MAP.clear();
    }

    static {
        Cleanable cleanable = new Cleanable(){

            public void clear() {
                DBCellFactory.clear();
            }
        };
        SystemManager.addCleanable(cleanable);
    }
}

