/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.util.SimpleCMYKColorSpace;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;

public final class ImageUtil {
    private static final String ICC_PROFILE = "ISOcoated_v2_eci.icc";
    public static final int LEFT = -1;
    public static final int CENTER = -2;
    public static final int RIGHT = -3;
    public static final int TOP = -4;
    public static final int MIDDLE = -5;
    public static final int BOTTOM = -6;
    public static final String READER_SUFFIXES;
    public static final String WRITER_SUFFIXES;

    private ImageUtil() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage readFile(String string) {
        if (!ImageUtil.isReaderSuffix(string)) {
            String string2 = "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306f" + READER_SUFFIXES + "\u306e\u3044\u305a\u308c\u304b\u306e\u5f62\u5f0f\u306e\u307f\u6307\u5b9a\u53ef\u80fd\u3067\u3059\u3002" + "File=[" + string + "]";
            throw new OgRuntimeException(string2);
        }
        File file = new File(string);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (IIOException iIOException) {
            String string3 = "cmykToSRGB \u51e6\u7406\u304c\u5fc5\u8981\u3067\u3059\u3002" + iIOException.getMessage();
            System.err.println(string3);
        }
        catch (IOException iOException) {
            String string4 = "\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u8fbc\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002File=[" + string + "]";
            throw new OgRuntimeException(string4, iOException);
        }
        if (bufferedImage != null) return bufferedImage;
        FileSeekableStream fileSeekableStream = null;
        try {
            fileSeekableStream = new FileSeekableStream(file.getAbsolutePath());
            bufferedImage = ImageUtil.cmykToSRGB(JAI.create((String)"stream", (Object)fileSeekableStream).getAsBufferedImage(null, null));
        }
        catch (IOException iOException) {
            try {
                String string5 = "\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u8fbc(JAI)\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002File=[" + string + "]";
                throw new OgRuntimeException(string5, iOException);
                catch (RuntimeException runtimeException) {
                    String string6 = "\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u8fbc(JAI)\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30d5\u30a1\u30a4\u30eb\u304c\u58ca\u308c\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002File=[" + string + "]";
                    throw new OgRuntimeException(string6, runtimeException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(fileSeekableStream);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)fileSeekableStream);
        return bufferedImage;
    }

    public static void saveFile(BufferedImage bufferedImage, String string) {
        File file = new File(string);
        try {
            String string2 = ImageUtil.getSuffix(string);
            ImageIO.write((RenderedImage)bufferedImage, string2, file);
        }
        catch (IOException iOException) {
            String string3 = "\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002File=[" + string + "]";
            throw new OgRuntimeException(string3, iOException);
        }
    }

    public static byte[] byteImage(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedImage bufferedImage = ImageUtil.readFile(string);
        try {
            String string2 = ImageUtil.getSuffix(string);
            ImageIO.write((RenderedImage)bufferedImage, string2, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            String string3 = "\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002File=[" + string + "]";
            throw new OgRuntimeException(string3, iOException);
        }
        finally {
            Closer.ioClose(byteArrayOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String getSuffix(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = string.lastIndexOf(46)) >= 0) {
            string2 = string.substring(n + 1).toLowerCase(Locale.JAPAN);
        }
        return string2;
    }

    public static boolean isReaderSuffix(String string) {
        String string2 = ImageUtil.getSuffix(string);
        return string2 != null && READER_SUFFIXES.indexOf(string2) >= 0;
    }

    public static boolean isWriterSuffix(String string) {
        String string2 = ImageUtil.getSuffix(string);
        return string2 != null && WRITER_SUFFIXES.indexOf(string2) >= 0;
    }

    public static void changeColor(BufferedImage bufferedImage, Color color, Color color2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = color.getRGB();
        int n4 = color2.getRGB();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (bufferedImage.getRGB(j, i) != n3) continue;
                bufferedImage.setRGB(j, i, n4);
            }
        }
    }

    public static BufferedImage cmykToSRGB(BufferedImage bufferedImage) throws IOException {
        Object object;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(ICC_PROFILE);
        ColorSpace colorSpace = null;
        if (inputStream == null) {
            object = "ISOcoated_v2_eci.icc \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + HybsConst.CR + " CLASSPATH\u306e\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u5834\u6240\u306b\u914d\u5099\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + HybsConst.CR + " \u6a19\u6e96\u306eSimpleCMYKColorSpace\u3092\u4f7f\u7528\u3057\u307e\u3059\u306e\u3067\u30a8\u30e9\u30fc\u306b\u306f\u306a\u308a\u307e\u305b\u3093\u304c\u3001\u975e\u5e38\u306b\u9045\u3044\u3067\u3059\u3002";
            System.out.println((String)object);
            colorSpace = SimpleCMYKColorSpace.getInstance();
        } else {
            object = ICC_Profile.getInstance(inputStream);
            colorSpace = new ICC_ColorSpace((ICC_Profile)object);
        }
        object = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        ColorSpace colorSpace2 = ((BufferedImage)object).getColorModel().getColorSpace();
        ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, colorSpace2, null);
        colorConvertOp.filter(bufferedImage, (BufferedImage)object);
        int n = ((BufferedImage)object).getWidth();
        int n2 = ((BufferedImage)object).getHeight();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = ((BufferedImage)object).getRGB(i, j);
                int n4 = (n3 & 0xFF0000) >> 16;
                int n5 = (n3 & 0xFF00) >> 8;
                int n6 = n3 & 0xFF;
                n3 = (Math.abs(n4 - 255) << 16) + (Math.abs(n5 - 255) << 8) + Math.abs(n6 - 255);
                ((BufferedImage)object).setRGB(i, j, n3);
            }
        }
        return object;
    }

    public static BufferedImage mixImage(BufferedImage bufferedImage, String string, int n, int n2, int n3, int n4, Font font, Color color) {
        Font font2;
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        int n7 = n3 <= 0 ? n5 : Math.min(n3, n5);
        int n8 = n4 <= 0 ? n6 : Math.min(n4, n6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (font != null) {
            graphics2D.setFont(font);
        }
        float f = 5.0f;
        while (true) {
            font2 = graphics2D.getFont().deriveFont(f);
            graphics2D.setFont(font2);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n9 = fontMetrics.stringWidth(string);
            int n10 = fontMetrics.getAscent();
            if (n7 < n9 || n8 < n10) break;
            f += 0.5f;
        }
        font2 = graphics2D.getFont().deriveFont(f -= 0.5f);
        return ImageUtil.mixImage(bufferedImage, string, n, n2, font2, color);
    }

    public static BufferedImage mixImage(BufferedImage bufferedImage, String string, int n, int n2, Font font, Color color) {
        int n3;
        int n4;
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (font != null) {
            graphics2D.setFont(font);
        }
        if (color == null) {
            graphics2D.setColor(Color.BLACK);
        } else {
            graphics2D.setColor(color);
        }
        int n5 = n;
        if (n5 < 0) {
            int n6 = bufferedImage.getWidth();
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            n4 = fontMetrics.stringWidth(string);
            switch (n5) {
                case -1: {
                    n5 = 0;
                    break;
                }
                case -2: {
                    n5 = n6 / 2 - n4 / 2;
                    break;
                }
                case -3: {
                    n5 = n6 - n4;
                    break;
                }
                default: {
                    String string2 = "X\u8ef8 \u3067\u7bc4\u56f2\u5916\u306e\u30c7\u30fc\u30bf\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002text=[" + string + "]" + " (x,y)=[" + n + "," + n2 + "]";
                    throw new OgRuntimeException(string2);
                }
            }
        }
        if ((n3 = n2) < 0) {
            n4 = bufferedImage.getHeight() - 2;
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n7 = fontMetrics.getAscent() - 2;
            switch (n3) {
                case -4: {
                    n3 = n7;
                    break;
                }
                case -5: {
                    n3 = n4 / 2 + n7 / 2;
                    break;
                }
                case -6: {
                    n3 = n4;
                    break;
                }
                default: {
                    String string3 = "Y\u8ef8 \u3067\u7bc4\u56f2\u5916\u306e\u30c7\u30fc\u30bf\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002text=[" + string + "]" + " (x,y)=[" + n + "," + n2 + "]";
                    throw new OgRuntimeException(string3);
                }
            }
        }
        graphics2D.drawString(string, n5, n3);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 5) {
            System.out.println("Usage: java org.opengion.fukurou.util.ImageUtil \n               \u5165\u529b\u30d5\u30a1\u30a4\u30eb \u51fa\u529b\u30d5\u30a1\u30a4\u30eb \u30c6\u30ad\u30b9\u30c8 X\u8ef8 Y\u8ef8 [\u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba]\n\tX\u8ef8\u3068Y\u8ef8\u306b\u306f\u3001\u7279\u5225\u306a\u8a18\u53f7\u304c\u3042\u308a\u3001\u5de6\u5bc4\u305b\u3001\u53f3\u5bc4\u305b\u7b49\u306e\u6307\u793a\u304c\u53ef\u80fd\u3067\u3059\u3002\n\t   X\u8ef8 \u6307\u5b9a\n\t    -1 \uff65\uff65\uff65 LEFT    \u5de6\u5bc4\u305b\n\t    -2 \uff65\uff65\uff65 CENTER  \u4e2d\u592e\u63c3\u3048\n\t    -3 \uff65\uff65\uff65 RIGHT   \u53f3\u5bc4\u305b\n\t\n\t   Y\u8ef8 \u6307\u5b9a \n\t    -4 \uff65\uff65\uff65 TOP     \u4e0a\u63c3\u3048\n\t    -5 \uff65\uff65\uff65 MIDDLE  \u4e2d\u592e\u63c3\u3048\n\t    -6 \uff65\uff65\uff65 BOTTOM  \u4e0b\u63c3\u3048\n");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        int n = Integer.parseInt(stringArray[3]);
        int n2 = Integer.parseInt(stringArray[4]);
        int n3 = 14;
        if (stringArray.length > 5) {
            n3 = Integer.parseInt(stringArray[5]);
        }
        BufferedImage bufferedImage = ImageUtil.readFile(string);
        Font font = new Font("Serif", 1, n3);
        Color color = new Color(255, 0, 0);
        ImageUtil.mixImage(bufferedImage, string3, n, n2, font, color);
        ImageUtil.saveFile(bufferedImage, string2);
    }

    static {
        Object[] objectArray = ImageIO.getReaderFileSuffixes();
        Arrays.sort(objectArray);
        READER_SUFFIXES = Arrays.toString(objectArray);
        Object[] objectArray2 = ImageIO.getWriterFileSuffixes();
        Arrays.sort(objectArray2);
        WRITER_SUFFIXES = Arrays.toString(objectArray2);
    }
}

