/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;

public final class ColorMap {
    private static final Color[] CLR_ARY = new Color[]{Color.BLUE, Color.CYAN, Color.GRAY, Color.GREEN, Color.LIGHT_GRAY, Color.MAGENTA, Color.DARK_GRAY, Color.ORANGE, Color.PINK, Color.RED, Color.YELLOW};
    private static final Map<String, Color> CLR_MAP = new HashMap<String, Color>();

    private ColorMap() {
    }

    public static Color getColorInstance(String string) {
        Color color;
        if (string == null || string.length() == 0) {
            String string2 = "\u6307\u5b9a\u306e\u8272\u30b3\u30fc\u30c9\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093 Color=[" + string + "]" + HybsConst.CR + "ColorMap=" + CLR_MAP.keySet().toString();
            throw new OgRuntimeException(string2);
        }
        if (string.charAt(0) == '#') {
            color = Color.decode(string);
        } else {
            String string3 = string.replaceAll("_", "").toUpperCase(Locale.JAPAN);
            color = CLR_MAP.get(string3);
            if (color == null) {
                String string4 = "\u6307\u5b9a\u306e\u8272\u30b3\u30fc\u30c9\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093 Color=[" + string + "]" + HybsConst.CR + "ColorMap=" + CLR_MAP.keySet().toString();
                throw new OgRuntimeException(string4);
            }
        }
        return color;
    }

    public static Color getColorInstance(int n) {
        return CLR_ARY[n % CLR_ARY.length];
    }

    public static String[] getColorKeys() {
        return CLR_MAP.keySet().toArray(new String[CLR_MAP.size()]);
    }

    static {
        CLR_MAP.put("BLUE", Color.BLUE);
        CLR_MAP.put("CYAN", Color.CYAN);
        CLR_MAP.put("GRAY", Color.GRAY);
        CLR_MAP.put("GREEN", Color.GREEN);
        CLR_MAP.put("LIGHTGRAY", Color.LIGHT_GRAY);
        CLR_MAP.put("MAGENTA", Color.MAGENTA);
        CLR_MAP.put("DARKGRAY", Color.DARK_GRAY);
        CLR_MAP.put("ORANGE", Color.ORANGE);
        CLR_MAP.put("PINK", Color.PINK);
        CLR_MAP.put("RED", Color.RED);
        CLR_MAP.put("YELLOW", Color.YELLOW);
        CLR_MAP.put("WHITE", Color.WHITE);
        CLR_MAP.put("BLACK", Color.BLACK);
        CLR_MAP.put("TRANSPARENT", new Color(255, 255, 255, 0));
        CLR_MAP.put("LIME", Color.decode("#00FF00"));
        CLR_MAP.put("AQUA", Color.decode("#00FFFF"));
        CLR_MAP.put("SILVER", Color.decode("#C0C0C0"));
        CLR_MAP.put("MAROON", Color.decode("#800000"));
        CLR_MAP.put("OLIVE", Color.decode("#808000"));
        CLR_MAP.put("TEAL", Color.decode("#008080"));
        CLR_MAP.put("NAVY", Color.decode("#000080"));
        CLR_MAP.put("FUCHSIA", Color.decode("#FF00FF"));
        CLR_MAP.put("PURPLE", Color.decode("#800080"));
        CLR_MAP.put("ALICEBLUE", Color.decode("#F0F8FF"));
        CLR_MAP.put("ANTIQUEWHITE", Color.decode("#FAEBD7"));
        CLR_MAP.put("AQUAMARINE", Color.decode("#7FFFD4"));
        CLR_MAP.put("AZURE", Color.decode("#F0FFFF"));
        CLR_MAP.put("BEIGE", Color.decode("#F5F5DC"));
        CLR_MAP.put("BISQUE", Color.decode("#FFE4C4"));
        CLR_MAP.put("BLANCHEDALMOND", Color.decode("#FFEBCD"));
        CLR_MAP.put("BLUEVIOLET", Color.decode("#8A2BE2"));
        CLR_MAP.put("BROWN", Color.decode("#A52A2A"));
        CLR_MAP.put("BURLYWOOD", Color.decode("#DEB887"));
        CLR_MAP.put("CADETBLUE", Color.decode("#5F9EA0"));
        CLR_MAP.put("CHARTREUSE", Color.decode("#7FFF00"));
        CLR_MAP.put("CHOCOLATE", Color.decode("#D2691E"));
        CLR_MAP.put("CORAL", Color.decode("#FF7F50"));
        CLR_MAP.put("CORNFLOWERBLUE", Color.decode("#6495ED"));
        CLR_MAP.put("CORNSILK", Color.decode("#FFF8DC"));
        CLR_MAP.put("CRIMSON", Color.decode("#DC143C"));
        CLR_MAP.put("DARKBLUE", Color.decode("#00008B"));
        CLR_MAP.put("DARKCYAN", Color.decode("#008B8B"));
        CLR_MAP.put("DARKGOLDENROD", Color.decode("#B8860B"));
        CLR_MAP.put("DARKGREEN", Color.decode("#006400"));
        CLR_MAP.put("DARKKHAKI", Color.decode("#BDB76B"));
        CLR_MAP.put("DARKMAGENTA", Color.decode("#8B008B"));
        CLR_MAP.put("DARKOLIVEGREEN", Color.decode("#556B2F"));
        CLR_MAP.put("DARKORANGE", Color.decode("#FF8C00"));
        CLR_MAP.put("DARKORCHID", Color.decode("#9932CC"));
        CLR_MAP.put("DARKRED", Color.decode("#8B0000"));
        CLR_MAP.put("DARKSALMON", Color.decode("#E9967A"));
        CLR_MAP.put("DARKSEAGREEN", Color.decode("#8FBC8F"));
        CLR_MAP.put("DARKSLATEBLUE", Color.decode("#483D8B"));
        CLR_MAP.put("DARKSLATEGRAY", Color.decode("#2F4F4F"));
        CLR_MAP.put("DARKTURQUOISE", Color.decode("#00CED1"));
        CLR_MAP.put("DARKVIOLET", Color.decode("#9400D3"));
        CLR_MAP.put("DEEPPINK", Color.decode("#FF1493"));
        CLR_MAP.put("DEEPSKYBLUE", Color.decode("#00BFFF"));
        CLR_MAP.put("DIMGRAY", Color.decode("#696969"));
        CLR_MAP.put("DODGERBLUE", Color.decode("#1E90FF"));
        CLR_MAP.put("FIREBRICK", Color.decode("#B22222"));
        CLR_MAP.put("FLORALWHITE", Color.decode("#FFFAF0"));
        CLR_MAP.put("FORESTGREEN", Color.decode("#228B22"));
        CLR_MAP.put("GAINSBORO", Color.decode("#DCDCDC"));
        CLR_MAP.put("GHOSTWHITE", Color.decode("#F8F8FF"));
        CLR_MAP.put("GOLD", Color.decode("#FFD700"));
        CLR_MAP.put("GOLDENROD", Color.decode("#DAA520"));
        CLR_MAP.put("GREENYELLOW", Color.decode("#ADFF2F"));
        CLR_MAP.put("HONEYDEW", Color.decode("#F0FFF0"));
        CLR_MAP.put("HOTPINK", Color.decode("#FF69B4"));
        CLR_MAP.put("INDIANRED", Color.decode("#CD5C5C"));
        CLR_MAP.put("INDIGO", Color.decode("#4B0082"));
        CLR_MAP.put("IVORY", Color.decode("#FFFFF0"));
        CLR_MAP.put("KHAKI", Color.decode("#F0E68C"));
        CLR_MAP.put("LAVENDER", Color.decode("#E6E6FA"));
        CLR_MAP.put("LAVENDERBLUSH", Color.decode("#FFF0F5"));
        CLR_MAP.put("LAWNGREEN", Color.decode("#7CFC00"));
        CLR_MAP.put("LEMONCHIFFON", Color.decode("#FFFACD"));
        CLR_MAP.put("LIGHTBLUE", Color.decode("#ADD8E6"));
        CLR_MAP.put("LIGHTCORAL", Color.decode("#F08080"));
        CLR_MAP.put("LIGHTCYAN", Color.decode("#E0FFFF"));
        CLR_MAP.put("LIGHTGOLDENRODYELLOW", Color.decode("#FAFAD2"));
        CLR_MAP.put("LIGHTGREEN", Color.decode("#90EE90"));
        CLR_MAP.put("LIGHTPINK", Color.decode("#FFB6C1"));
        CLR_MAP.put("LIGHTSALMON", Color.decode("#FFA07A"));
        CLR_MAP.put("LIGHTSEAGREEN", Color.decode("#20B2AA"));
        CLR_MAP.put("LIGHTSKYBLUE", Color.decode("#87CEFA"));
        CLR_MAP.put("LIGHTSLATEGRAY", Color.decode("#778899"));
        CLR_MAP.put("LIGHTSTEELBLUE", Color.decode("#B0C4DE"));
        CLR_MAP.put("LIGHTYELLOW", Color.decode("#FFFFE0"));
        CLR_MAP.put("LIMEGREEN", Color.decode("#32CD32"));
        CLR_MAP.put("LINEN", Color.decode("#FAF0E6"));
        CLR_MAP.put("MEDIUMAQUAMARINE", Color.decode("#66CDAA"));
        CLR_MAP.put("MEDIUMBLUE", Color.decode("#0000CD"));
        CLR_MAP.put("MEDIUMORCHID", Color.decode("#BA55D3"));
        CLR_MAP.put("MEDIUMPURPLE", Color.decode("#9370DB"));
        CLR_MAP.put("MEDIUMSEAGREEN", Color.decode("#3CB371"));
        CLR_MAP.put("MEDIUMSLATEBLUE", Color.decode("#7B68EE"));
        CLR_MAP.put("MEDIUMSPRINGGREEN", Color.decode("#00FA9A"));
        CLR_MAP.put("MEDIUMTURQUOISE", Color.decode("#48D1CC"));
        CLR_MAP.put("MEDIUMVIOLETRED", Color.decode("#C71585"));
        CLR_MAP.put("MIDNIGHTBLUE", Color.decode("#191970"));
        CLR_MAP.put("MINTCREAM", Color.decode("#F5FFFA"));
        CLR_MAP.put("MISTYROSE", Color.decode("#FFE4E1"));
        CLR_MAP.put("MOCCASIN", Color.decode("#FFE4B5"));
        CLR_MAP.put("NAVAJOWHITE", Color.decode("#FFDEAD"));
        CLR_MAP.put("OLDLACE", Color.decode("#FDF5E6"));
        CLR_MAP.put("OLIVEDRAB", Color.decode("#6B8E23"));
        CLR_MAP.put("ORANGERED", Color.decode("#FF4500"));
        CLR_MAP.put("ORCHID", Color.decode("#DA70D6"));
        CLR_MAP.put("PALEGOLDENROD", Color.decode("#EEE8AA"));
        CLR_MAP.put("PALEGREEN", Color.decode("#98FB98"));
        CLR_MAP.put("PALETURQUOISE", Color.decode("#AFEEEE"));
        CLR_MAP.put("PALEVIOLETRED", Color.decode("#DB7093"));
        CLR_MAP.put("PAPAYAWHIP", Color.decode("#FFEFD5"));
        CLR_MAP.put("PEACHPUFF", Color.decode("#FFDAB9"));
        CLR_MAP.put("PERU", Color.decode("#CD853F"));
        CLR_MAP.put("PLUM", Color.decode("#DDA0DD"));
        CLR_MAP.put("POWDERBLUE", Color.decode("#B0E0E6"));
        CLR_MAP.put("ROSYBROWN", Color.decode("#BC8F8F"));
        CLR_MAP.put("ROYALBLUE", Color.decode("#4169E1"));
        CLR_MAP.put("SADDLEBROWN", Color.decode("#8B4513"));
        CLR_MAP.put("SALMON", Color.decode("#FA8072"));
        CLR_MAP.put("SANDYBROWN", Color.decode("#F4A460"));
        CLR_MAP.put("SEAGREEN", Color.decode("#2E8B57"));
        CLR_MAP.put("SEASHELL", Color.decode("#FFF5EE"));
        CLR_MAP.put("SIENNA", Color.decode("#A0522D"));
        CLR_MAP.put("SKYBLUE", Color.decode("#87CEEB"));
        CLR_MAP.put("SLATEBLUE", Color.decode("#6A5ACD"));
        CLR_MAP.put("SLATEGRAY", Color.decode("#708090"));
        CLR_MAP.put("SNOW", Color.decode("#FFFAFA"));
        CLR_MAP.put("SPRINGGREEN", Color.decode("#00FF7F"));
        CLR_MAP.put("STEELBLUE", Color.decode("#4682B4"));
        CLR_MAP.put("TAN", Color.decode("#D2B48C"));
        CLR_MAP.put("THISTLE", Color.decode("#D8BFD8"));
        CLR_MAP.put("TOMATO", Color.decode("#FF6347"));
        CLR_MAP.put("TURQUOISE", Color.decode("#40E0D0"));
        CLR_MAP.put("VIOLET", Color.decode("#EE82EE"));
        CLR_MAP.put("WHEAT", Color.decode("#F5DEB3"));
        CLR_MAP.put("WHITESMOKE", Color.decode("#F5F5F5"));
        CLR_MAP.put("YELLOWGREEN", Color.decode("#9ACD32"));
        for (int i = 0; i < CLR_ARY.length; ++i) {
            CLR_MAP.put(String.valueOf(i), CLR_ARY[i]);
        }
    }
}

