package org.opengion.hayabusa.servlet;

import javax.websocket.OnMessage;
import javax.websocket.server.ServerEndpoint;

/**
 * WebSocketデモ。
 *
 * @author DukeLab
 */
@ServerEndpoint(value = "/wsdemo")
public class WebSocketDemo {

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	public WebSocketDemo() {
		super();		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。
	}

	/**
	 * WebSocketデモ。
	 *
	 * @param text 入力テキスト
	 * @return メッセージ
	 */
    @OnMessage
    public String onMessage(final String text ) {
        return text;
    }

}
