<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<og:comment
	system   = "**:エンジン共通"
	pgid     = "01_ADMIN"
	title    = "Admin管理"
	date     = "2015/06/08"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="NEW" debug="{@debug}" maxRowCount="0" dbid="RESOURCE">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
	select distinct A.SYSTEM_ID, A.CONTXT_PATH
		, B.PARAM AS "OS_INFO"      
		, C.PARAM AS "SERVER_INFO"  
		, D.PARAM AS "SERVLET_INFO" 
		, E.PARAM AS "JDK_INFO"     
		, F.PARAM AS "REAL_PATH"    
		, G.PARAM AS "ENGINE_INFO"  
		, H.PARAM AS "STARTING_TIME"  
	from GE12 A
			inner join GE12 B on A.SYSTEM_ID = B.SYSTEM_ID and A.CONTXT_PATH = B.CONTXT_PATH and B.PARAM_ID = 'OS_INFO'
			inner join GE12 C on A.SYSTEM_ID = C.SYSTEM_ID and A.CONTXT_PATH = C.CONTXT_PATH and C.PARAM_ID = 'SERVER_INFO'
			inner join GE12 D on A.SYSTEM_ID = D.SYSTEM_ID and A.CONTXT_PATH = D.CONTXT_PATH and D.PARAM_ID = 'SERVLET_INFO'
			inner join GE12 E on A.SYSTEM_ID = E.SYSTEM_ID and A.CONTXT_PATH = E.CONTXT_PATH and E.PARAM_ID = 'JDK_INFO'
			inner join GE12 F on A.SYSTEM_ID = F.SYSTEM_ID and A.CONTXT_PATH = F.CONTXT_PATH and F.PARAM_ID = 'REAL_PATH'
			inner join GE12 G on A.SYSTEM_ID = G.SYSTEM_ID and A.CONTXT_PATH = G.CONTXT_PATH and G.PARAM_ID = 'ENGINE_INFO'
			inner join GE12 H on A.SYSTEM_ID = H.SYSTEM_ID and A.CONTXT_PATH = H.CONTXT_PATH and H.PARAM_ID = 'STARTING_TIME'
	order by A.SYSTEM_ID, A.CONTXT_PATH
</og:query>

<og:view
	viewFormType = "HTMLTable"
	command    = "NEW"
	writable   = "false"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
