/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.ThrowUtil;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.hayabusa.common.HybsSystem;

public class ProgramRun {
    private final StringBuilder errMsg;
    private final String SYSTEM_ID;
    private final String YKNO;
    private final String LISTID;
    private final boolean DEBUG;
    private String sqlCmd;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;

    public ProgramRun(String string, String string2, String string3, boolean bl) {
        this.SYSTEM_ID = string;
        this.YKNO = string2;
        this.LISTID = string3;
        this.DEBUG = bl;
        this.errMsg = new StringBuilder(200);
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYSTEM_ID, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("ProgramRun", this.YKNO, this.LISTID);
        } else {
            this.appInfo = null;
        }
    }

    public boolean execute() {
        boolean bl;
        System.out.print("ProgramRun [" + this.SYSTEM_ID + "]... ");
        try {
            bl = this.makeSQLCommand();
            if (bl) {
                System.out.print(" MK SQL,");
            }
            if (bl && (bl = this.programRun())) {
                System.out.print(" PG RUN,");
            }
            System.out.println(" End.");
        }
        catch (Throwable throwable) {
            this.errMsg.append("ProgramRun Execute Error! ").append(HybsConst.CR).append("==============================").append(HybsConst.CR).append(ThrowUtil.ogStackTrace((Throwable)throwable)).append(HybsConst.CR);
            bl = false;
        }
        return bl;
    }

    private boolean makeSQLCommand() {
        StringBuilder stringBuilder = new StringBuilder(200).append("{ call ").append(this.LISTID).append("P.").append(this.LISTID).append("( ?,?,?,? ) }");
        this.sqlCmd = stringBuilder.toString();
        if (this.DEBUG) {
            System.out.println();
            System.out.println(this.sqlCmd);
        }
        return true;
    }

    private boolean programRun() {
        String[] stringArray = new String[]{"ProgRUN", this.YKNO};
        String[] stringArray2 = DBUtil.dbCallExecute((String)this.sqlCmd, (String[])stringArray, (ApplicationInfo)this.appInfo);
        boolean bl = false;
        if (stringArray2 != null && stringArray2.length == 2) {
            String string = stringArray2[0];
            String string2 = stringArray2[1];
            if ("0".equals(string)) {
                bl = true;
            } else {
                this.errMsg.append("PL/SQL=[").append(this.sqlCmd).append("] YKNO=[").append(this.YKNO).append("] LISTID=[").append(this.LISTID).append("] ").append(string).append(':').append(string2).append(HybsConst.CR);
                LogWriter.log((String)this.errMsg.toString());
            }
        }
        return bl;
    }

    public String getErrMsg() {
        return this.errMsg.toString();
    }
}

