/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.query;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.AbstractQuery;

public class Query_JDBCPrepared
extends AbstractQuery {
    private static final String VERSION = "6.4.2.0 (2016/01/29)";

    public void execute(String ... stringArray) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int n;
            if (preparedStatement == null) {
                preparedStatement = this.getConnection().prepareStatement(this.getStatement());
                preparedStatement.setQueryTimeout(DB_MAX_QUERY_TIMEOUT);
            }
            for (n = 0; n < stringArray.length; ++n) {
                preparedStatement.setString(n + 1, StringUtil.rTrim((String)stringArray[n]));
            }
            n = preparedStatement.execute() ? 1 : 0;
            if (n != 0) {
                resultSet = preparedStatement.getResultSet();
                this.createTableModel(resultSet);
                this.setUpdateFlag(false);
            } else {
                this.setExecuteCount(preparedStatement.getUpdateCount());
            }
            this.setErrorCode(0);
        }
        catch (SQLException sQLException) {
            try {
                this.setErrorCode(8);
                String string = sQLException.getMessage() + ":" + sQLException.getSQLState() + CR + this.getStatement() + CR;
                throw new HybsSystemException(string, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                Closer.resultClose(resultSet);
                Closer.stmtClose(preparedStatement);
                throw throwable;
            }
        }
        Closer.resultClose((ResultSet)resultSet);
        Closer.stmtClose((Statement)preparedStatement);
    }
}

