/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.xml;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.opengion.fukurou.system.HybsConst;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class HybsErrorListener
implements ErrorListener,
ErrorHandler {
    private final StringBuilder errBuf;

    public HybsErrorListener() {
        this(new StringBuilder());
    }

    public HybsErrorListener(StringBuilder stringBuilder) {
        this.errBuf = stringBuilder;
    }

    @Override
    public void warning(TransformerException transformerException) {
        this.errMsg("Warning:", transformerException);
    }

    @Override
    public void error(TransformerException transformerException) {
        this.errMsg("Error:", transformerException);
    }

    @Override
    public void fatalError(TransformerException transformerException) {
        this.errMsg("Fatal:", transformerException);
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        this.errMsg("Warning:", sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        this.errMsg("Error:", sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) {
        this.errMsg("Fatal:", sAXParseException);
    }

    private void errMsg(String string, TransformerException transformerException) {
        Throwable throwable;
        String string2;
        SourceLocator sourceLocator = transformerException.getLocator();
        if (sourceLocator != null) {
            this.errBuf.append(" (").append(sourceLocator.getLineNumber()).append("): ");
        }
        if ((string2 = transformerException.getMessage()) != null && !"null".equals(string2)) {
            this.errBuf.append(string).append(string2).append(HybsConst.CR);
        }
        if ((throwable = transformerException.getException()) instanceof TransformerException) {
            this.errMsg("\uff97\uff6f\uff8c\uff9f:", (TransformerException)throwable);
        }
        if ((throwable = transformerException.getCause()) instanceof TransformerException) {
            this.errMsg("\u539f\u56e0:", (TransformerException)throwable);
        }
    }

    private void errMsg(String string, SAXParseException sAXParseException) {
        Throwable throwable;
        String string2;
        int n = sAXParseException.getLineNumber();
        if (n >= 0) {
            this.errBuf.append(" (").append(n).append("): ");
        }
        if ((string2 = sAXParseException.getMessage()) != null && !"null".equals(string2)) {
            this.errBuf.append(string).append(string2).append(HybsConst.CR);
        }
        if ((throwable = sAXParseException.getException()) instanceof SAXParseException) {
            this.errMsg("\uff97\uff6f\uff8c\uff9f:", (SAXParseException)throwable);
        }
        if ((throwable = sAXParseException.getCause()) instanceof SAXParseException) {
            this.errMsg("\u539f\u56e0:", (SAXParseException)throwable);
        }
    }

    public String toString() {
        return this.errBuf.toString();
    }
}

