/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.mail;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.opengion.fukurou.mail.MailAttachFiles;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.UnicodeCorrecter;

public class MailMessage {
    private static final String MSG_EX = "\u30e1\u30c3\u30bb\u30fc\u30b8\u60c5\u5831\u306e\u30cf\u30f3\u30c9\u30ea\u30f3\u30b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
    private final String host;
    private final String user;
    private final Message message;
    private final Map<String, String> headerMap;
    private String subject;
    private String content;
    private String messageID;

    public MailMessage(Message message, String string, String string2) {
        this.host = string;
        this.user = string2;
        this.message = message;
        this.headerMap = this.makeHeaderMap(null);
    }

    public Message getMessage() {
        return this.message;
    }

    public String getHost() {
        return this.host;
    }

    public String getUser() {
        return this.user;
    }

    public String getHeader(String string) {
        return this.headerMap.get(string);
    }

    public String getHeaders() {
        String[] stringArray = this.headerMap.keySet().toArray(new String[this.headerMap.size()]);
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]).append(':').append(this.headerMap.get(stringArray[i])).append(HybsConst.CR);
        }
        return stringBuilder.toString();
    }

    public String getSubject() {
        if (this.subject == null) {
            try {
                this.subject = MailMessage.mimeDecode(this.message.getSubject());
            }
            catch (MessagingException messagingException) {
                throw new OgRuntimeException(MSG_EX, messagingException);
            }
        }
        if (this.subject == null) {
            this.subject = "No Subject";
        }
        return this.subject;
    }

    public String getContent() {
        if (this.content == null) {
            this.content = UnicodeCorrecter.correctToCP932(this.mime2str((Part)this.message));
        }
        return this.content;
    }

    public String getMessageID() {
        if (this.messageID == null) {
            try {
                this.messageID = ((MimeMessage)this.message).getMessageID();
                if (this.messageID == null) {
                    Date date = this.message.getSentDate();
                    if (date == null) {
                        date = this.message.getReceivedDate();
                    }
                    Long l = date == null ? 0L : date.getTime();
                    String string = ((InternetAddress[])this.message.getFrom())[0].getAddress();
                    this.messageID = "unknown." + l + "." + string;
                } else {
                    this.messageID = this.messageID.substring(1, this.messageID.length() - 1);
                }
            }
            catch (MessagingException messagingException) {
                throw new OgRuntimeException(MSG_EX, messagingException);
            }
        }
        return this.messageID;
    }

    public void deleteMessage(boolean bl) {
        try {
            this.message.setFlag(Flags.Flag.DELETED, bl);
        }
        catch (MessagingException messagingException) {
            throw new OgRuntimeException(MSG_EX, messagingException);
        }
    }

    public String getSimpleMessage() {
        StringBuilder stringBuilder = new StringBuilder(200).append(this.getHeaders()).append(HybsConst.CR).append("Subject:").append(this.getSubject()).append(HybsConst.CR).append("===============================").append(HybsConst.CR).append(this.getContent()).append(HybsConst.CR).append("===============================").append(HybsConst.CR);
        return stringBuilder.toString();
    }

    public void saveSimpleMessage(String string) {
        this.saveMessage(string);
        this.saveAttachFiles(string, true);
    }

    public void saveMessage(String string) {
        String string2 = this.getMessageID();
        File file = new File(string, string2 + ".txt");
        PrintWriter printWriter = FileUtil.getPrintWriter(file, "UTF-8");
        printWriter.println(this.getSimpleMessage());
        printWriter.close();
    }

    public void saveAttachFiles(String string, boolean bl) {
        String string2;
        Object object;
        if (bl) {
            object = this.getMessageID();
            string2 = string.endsWith("/") ? string + (String)object + "/" : string + "/" + (String)object + "/";
        } else {
            string2 = string;
        }
        object = new MailAttachFiles((Part)this.message);
        String[] stringArray = ((MailAttachFiles)object).getNames();
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                ((MailAttachFiles)object).saveFileName(string2, null, i);
            }
        }
    }

    public String getNotificationTo() {
        return this.headerMap.get("Disposition-Notification-To");
    }

    private Map<String, String> makeHeaderMap(String[] stringArray) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        try {
            Enumeration enumeration = stringArray == null ? this.message.getAllHeaders() : this.message.getMatchingHeaders(stringArray);
            while (enumeration.hasMoreElements()) {
                Header header = (Header)enumeration.nextElement();
                String string = header.getName();
                String string2 = MailMessage.mimeDecode(header.getValue());
                String string3 = (String)linkedHashMap.get(string);
                if (string3 != null) {
                    string2 = string3 + "," + string2;
                }
                linkedHashMap.put(string, string2);
            }
        }
        catch (MessagingException messagingException) {
            throw new OgRuntimeException(MSG_EX, messagingException);
        }
        return linkedHashMap;
    }

    private String mime2str(Part part) {
        String string = null;
        try {
            if (part.isMimeType("text/plain")) {
                if ("text/plain".equalsIgnoreCase(part.getContentType())) {
                    MimeMessage mimeMessage = new MimeMessage((MimeMessage)part);
                    mimeMessage.setHeader("Content-Type", "text/plain; charset=iso-2022-jp");
                    string = (String)mimeMessage.getContent();
                } else {
                    string = (String)part.getContent();
                }
            } else if (part.isMimeType("message/rfc822")) {
                string = this.mime2str((Part)part.getContent());
            } else if (part.isMimeType("multipart/*")) {
                BodyPart bodyPart;
                Multipart multipart = (Multipart)part.getContent();
                int n = multipart.getCount();
                for (int i = 0; i < n && (string = this.mime2str((Part)(bodyPart = multipart.getBodyPart(i)))) == null; ++i) {
                }
            }
        }
        catch (MessagingException messagingException) {
            throw new OgRuntimeException(MSG_EX, messagingException);
        }
        catch (IOException iOException) {
            throw new OgRuntimeException("\u30c6\u30ad\u30b9\u30c8\u60c5\u5831\u306e\u53d6\u308a\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", iOException);
        }
        return string;
    }

    public static final String mimeDecode(String string) {
        if (string == null || string.indexOf("=?") < 0) {
            return string;
        }
        String string2 = string.replace('\t', ' ');
        try {
            int n = string2.indexOf("=?");
            int n2 = 0;
            StringBuilder stringBuilder = new StringBuilder(200).append(string2.substring(0, n));
            while (n >= 0) {
                n2 = string2.indexOf("?=", n) + 2;
                String string3 = string2.substring(n, n2);
                stringBuilder.append(UnicodeCorrecter.correctToCP932(MimeUtility.decodeText((String)string3)));
                n = string2.indexOf("=?", n2);
                if (n <= 0) continue;
                stringBuilder.append(string2.substring(n2, n));
            }
            stringBuilder.append(string2.substring(n2));
            string2 = stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OgRuntimeException("\u30c6\u30ad\u30b9\u30c8\u60c5\u5831\u306e\u30c7\u30b3\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", unsupportedEncodingException);
        }
        return string2;
    }
}

