/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TreeSet;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.resource.ResourceManager;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class ColumnCheckTag
extends CommonTagSupport {
    private static final String VERSION = "6.4.0.2 (2015/12/11)";
    private static final long serialVersionUID = 640220151211L;
    public static final String CMD_NEW = "NEW";
    public static final String CMD_RENEW = "RENEW";
    public static final String CMD_ENTRY = "ENTRY";
    private transient DBTableModel table;
    private String tableId = "h_tblmdl";
    private String command = "NEW";
    private String[] columns;
    private String[] nullCheck;
    private String[] mustAnyCheck;
    private int maxRowCount = -1;
    private int minRowCount = -1;
    private String checkType = "AUTO";
    private String bodyString;
    private String[] matchKeys;
    private String[] matchVals;
    private boolean isRealTime;
    private boolean isStrict;
    private boolean isColumnLabel;
    private String checkNames;

    @Override
    public int doStartTag() {
        return this.useTag() ? 2 : 0;
    }

    @Override
    public int doAfterBody() {
        this.bodyString = this.getBodyString();
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        int n = 6;
        this.table = (DBTableModel)this.getObject(this.tableId);
        if ("AUTO".equals(this.checkType)) {
            this.checkType = this.command;
        }
        if (!CMD_NEW.equals(this.checkType) && !CMD_RENEW.equals(this.checkType) && this.table == null) {
            String string = "\u691c\u7d22\u7d50\u679c\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002 checkType=[" + this.checkType + "]";
            this.jspPrint(string);
            n = 5;
        } else {
            ErrorMessage errorMessage = this.makeErrorDBTable();
            if (errorMessage.getKekka() >= 2) {
                if (this.bodyString != null) {
                    this.jspPrint(this.bodyString);
                }
                if (this.isRealTime) {
                    this.jspPrint(TaglibUtil.makeHTMLSimpleErrorList(errorMessage, this.getResource()));
                } else {
                    this.jspPrint(TaglibUtil.makeHTMLErrorTable(errorMessage, this.getResource()));
                }
                if (CMD_NEW.equals(this.command)) {
                    this.removeObject(this.tableId);
                }
                n = 5;
            } else if (errorMessage.getKekka() == 1) {
                if (this.isRealTime) {
                    this.jspPrint(TaglibUtil.makeHTMLSimpleErrorList(errorMessage, this.getResource()));
                } else {
                    this.jspPrint(TaglibUtil.makeHTMLErrorTable(errorMessage, this.getResource()));
                }
            }
        }
        return n;
    }

    @Override
    protected void release2() {
        super.release2();
        this.command = CMD_NEW;
        this.columns = null;
        this.nullCheck = null;
        this.maxRowCount = -1;
        this.minRowCount = -1;
        this.checkType = "AUTO";
        this.bodyString = null;
        this.tableId = "h_tblmdl";
        this.mustAnyCheck = null;
        this.matchKeys = null;
        this.matchVals = null;
        this.table = null;
        this.isRealTime = false;
        this.isStrict = false;
        this.isColumnLabel = false;
        this.checkNames = null;
    }

    private ErrorMessage makeErrorDBTable() {
        ErrorMessage errorMessage = new ErrorMessage();
        if (CMD_ENTRY.equals(this.checkType)) {
            errorMessage.setTitle("Request Column Error!");
            errorMessage = this.makeEntryErrorMessage(errorMessage);
            errorMessage = this.makeMaxRowCountErrorMessage(errorMessage);
            errorMessage = this.makeMinRowCountErrorMessage(errorMessage);
        } else if (CMD_NEW.equals(this.checkType)) {
            errorMessage.setTitle("Entry Column Error!");
            errorMessage = this.makeErrorMessage(errorMessage);
            errorMessage = this.makeMaxRowCountErrorMessage(errorMessage);
            errorMessage = this.makeMinRowCountErrorMessage(errorMessage);
        } else if (this.minRowCount >= 0 || this.maxRowCount >= 0) {
            errorMessage.setTitle("Row Count Error Limited Error!");
            errorMessage = this.makeMaxRowCountErrorMessage(errorMessage);
            errorMessage = this.makeMinRowCountErrorMessage(errorMessage);
        } else if ("MODIFY,DELETE".indexOf(this.checkType) >= 0) {
            this.minRowCount = 1;
            errorMessage = this.makeMinRowCountErrorMessage(errorMessage);
        }
        return errorMessage;
    }

    private ErrorMessage makeErrorMessage(ErrorMessage errorMessage) {
        Object object;
        int n;
        Object object2;
        if (!this.isRealTime) {
            if (this.nullCheck == null) {
                this.nullCheck = this.getRequestValues("h_must_must");
                if (this.nullCheck != null) {
                    object2 = new TreeSet();
                    object2.addAll(Arrays.asList(this.nullCheck));
                    this.nullCheck = object2.toArray(new String[object2.size()]);
                }
            }
            if (this.mustAnyCheck == null && (object2 = this.getRequestValues("h_must_mustAny")) != null && ((String[])object2).length > 0) {
                this.mustAnyCheck = new String[]{StringUtil.array2line((String[])object2, (String)"|")};
            }
        }
        object2 = this.getResource();
        if (this.nullCheck != null && this.nullCheck.length != 0) {
            for (n = 0; n < this.nullCheck.length; ++n) {
                String string = this.nullCheck[n];
                String string2 = this.getRequestValue(string, false);
                if (string2 != null && !string2.isEmpty()) continue;
                object = this.isColumnLabel ? this.getDBColumn(string).getLabel() : ((ResourceManager)object2).getLabel(string);
                errorMessage.addMessage(0, 2, "ERR0012", new String[]{object});
            }
        }
        if (this.mustAnyCheck != null && this.mustAnyCheck.length != 0) {
            StringBuilder stringBuilder = new StringBuilder(200);
            for (int i = 0; i < this.mustAnyCheck.length; ++i) {
                String string;
                int n2;
                boolean bl = false;
                object = StringUtil.csv2Array((String)this.mustAnyCheck[i], (char)'|');
                for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                    string = this.getRequestValue(object[n2], false);
                    if (string == null || string.length() <= 0) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                stringBuilder.setLength(0);
                for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                    string = object[n2];
                    String string3 = this.isColumnLabel ? this.getDBColumn(string).getLabel() : ((ResourceManager)object2).getLabel(string);
                    stringBuilder.append(string3).append(',');
                }
                errorMessage.addMessage(0, 2, "ERR0036", new String[]{stringBuilder.toString()});
            }
        }
        if (this.columns != null && this.columns.length != 0) {
            for (n = 0; n < this.columns.length; ++n) {
                Object object3 = this.getRequestValue(this.columns[n], false);
                if (object3 == null || object3.length() <= 0) continue;
                object3 = StringUtil.replace((String)object3, (String)"%", (String)"");
                object3 = StringUtil.replace((String)object3, (String)"_", (String)"");
                DBColumn dBColumn = this.getDBColumn(this.columns[n]);
                if (("," + this.checkNames + ",").indexOf("," + this.columns[n] + ",") >= 0 && (object = dBColumn.valueSet((String)object3)) != null) {
                    object3 = object;
                }
                errorMessage.append(dBColumn.valueCheck((String)object3, this.isStrict));
            }
        }
        if (this.matchKeys != null && this.matchKeys.length != 0) {
            for (n = 0; n < this.matchKeys.length; ++n) {
                String string = this.matchKeys[n];
                String string4 = this.getRequestValue(string, false);
                if (string4 == null || string4.matches(this.matchVals[n])) continue;
                object = this.isColumnLabel ? this.getDBColumn(string).getLabel() : ((ResourceManager)object2).getLabel(string);
                errorMessage.addMessage(0, 2, "ERR0037", new String[]{object, string4, this.matchVals[n]});
            }
        }
        return errorMessage;
    }

    private ErrorMessage makeEntryErrorMessage(ErrorMessage errorMessage) {
        int n;
        String string;
        int n2;
        String[] stringArray;
        int n3;
        Object object;
        int[] nArray = this.getParameterRows();
        if (nArray.length == 0) {
            return errorMessage;
        }
        if (!this.isRealTime && this.table != null) {
            if (this.nullCheck == null) {
                this.nullCheck = this.table.getMustArray();
            }
            if (this.mustAnyCheck == null) {
                this.mustAnyCheck = this.table.getMustAnyArray();
            }
        }
        boolean[][] blArray = null;
        boolean[] blArray2 = null;
        if (this.mustAnyCheck != null && this.mustAnyCheck.length != 0) {
            blArray = new boolean[nArray.length][this.mustAnyCheck.length];
            blArray2 = new boolean[nArray.length];
        }
        DBColumn dBColumn = null;
        Enumeration<?> enumeration = this.getParameterNames();
        block0: while (enumeration.hasMoreElements()) {
            int n4;
            object = (String)enumeration.nextElement();
            int n5 = ((String)object).lastIndexOf("__");
            if (n5 <= 0) continue;
            String string2 = ((String)object).substring(0, n5);
            n3 = Integer.parseInt(((String)object).substring(n5 + 2));
            stringArray = this.getRequestValue((String)object, false);
            n2 = Arrays.binarySearch(nArray, n3);
            if (n2 < 0) continue;
            dBColumn = null;
            if (this.isColumnLabel && this.table != null && (n4 = this.table.getColumnNo(string2, false)) >= 0) {
                dBColumn = this.table.getDBColumn(n4);
            }
            if (dBColumn == null) {
                dBColumn = this.getDBColumn(string2);
            }
            string = dBColumn.valueSet((String)stringArray);
            errorMessage.append(n3 + 1, dBColumn.valueCheck(string));
            if (this.nullCheck != null && this.nullCheck.length != 0 && (n = Arrays.binarySearch(this.nullCheck, string2)) >= 0 && (string == null || string.isEmpty())) {
                errorMessage.addMessage(n3 + 1, 2, "ERR0012", new String[]{dBColumn.getLabel()});
            }
            if (blArray != null) {
                for (n = 0; n < this.mustAnyCheck.length; ++n) {
                    if (blArray[n2][n] || this.mustAnyCheck[n].indexOf(string2) < 0 || string == null || string.length() <= 0) continue;
                    blArray[n2][n] = true;
                }
                blArray2[n2] = true;
            }
            if (this.matchKeys == null || this.matchKeys.length == 0) continue;
            for (n = 0; n < this.matchKeys.length; ++n) {
                int n6;
                if (!string2.equals(this.matchKeys[n])) continue;
                if (string == null || string.matches(this.matchVals[n])) continue block0;
                dBColumn = null;
                if (this.isColumnLabel && this.table != null && (n6 = this.table.getColumnNo(string2, false)) >= 0) {
                    dBColumn = this.table.getDBColumn(n6);
                }
                if (dBColumn == null) {
                    dBColumn = this.getDBColumn(string2);
                }
                errorMessage.addMessage(n3 + 1, 2, "ERR0037", new String[]{dBColumn.getLabel(), string, this.matchVals[n2]});
                continue block0;
            }
        }
        object = this.getResource();
        if (blArray != null) {
            StringBuilder stringBuilder = new StringBuilder(200);
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray2[i]) continue;
                for (n3 = 0; n3 < this.mustAnyCheck.length; ++n3) {
                    if (blArray[i][n3]) continue;
                    stringArray = StringUtil.csv2Array((String)this.mustAnyCheck[n3], (char)'|');
                    stringBuilder.setLength(0);
                    stringBuilder.append("row=[").append(nArray[i] + 1).append("] ");
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        string = null;
                        if (this.isColumnLabel && this.table != null) {
                            n = this.table.getColumnNo(stringArray[n2], false);
                            if (n >= 0) {
                                dBColumn = this.table.getDBColumn(n);
                            }
                            if (dBColumn == null) {
                                dBColumn = this.getDBColumn(stringArray[n2]);
                            }
                            string = dBColumn.getLabel();
                        } else {
                            string = ((ResourceManager)object).getLabel(stringArray[n2]);
                        }
                        stringBuilder.append(string).append('|');
                    }
                    errorMessage.addMessage(nArray[i] + 1, 2, "ERR0036", new String[]{stringBuilder.toString()});
                }
            }
        }
        return errorMessage;
    }

    private ErrorMessage makeMaxRowCountErrorMessage(ErrorMessage errorMessage) {
        if (this.maxRowCount < 0) {
            return errorMessage;
        }
        int[] nArray = this.getParameterRows();
        int n = nArray.length;
        if (n > this.maxRowCount) {
            String string = String.valueOf(n);
            String string2 = String.valueOf(this.maxRowCount);
            errorMessage.addMessage(0, 2, "ERR0017", new String[]{string, string2});
        }
        return errorMessage;
    }

    private ErrorMessage makeMinRowCountErrorMessage(ErrorMessage errorMessage) {
        if (this.minRowCount < 0) {
            return errorMessage;
        }
        int[] nArray = this.getParameterRows();
        int n = nArray.length;
        if (n < this.minRowCount) {
            String string = String.valueOf(n);
            String string2 = String.valueOf(this.minRowCount);
            errorMessage.addMessage(0, 2, "ERR0018", new String[]{string, string2});
        }
        return errorMessage;
    }

    public void setColumns(String string) {
        this.columns = StringUtil.csv2Array((String)this.getRequestParameter(string));
        if (this.columns.length == 0) {
            this.columns = null;
        }
        if (this.columns != null && "*".equals(this.columns[0])) {
            TreeSet<String> treeSet = new TreeSet<String>();
            ResourceManager resourceManager = this.getResource();
            Enumeration<?> enumeration = this.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2 == null || string2.isEmpty() || string2.startsWith("h_") || string2.startsWith("hX_") || resourceManager.getDBColumn(string2) == null) continue;
                treeSet.add(string2);
            }
            treeSet.remove("maxRowCount");
            treeSet.remove("command");
            treeSet.remove("pageSize");
            treeSet.remove("pagePlus");
            treeSet.remove("debug");
            treeSet.remove("GAMENID");
            treeSet.remove("BACK_JSPID");
            treeSet.remove("BACK_GAMENID");
            this.columns = treeSet.toArray(new String[treeSet.size()]);
        }
    }

    public void setNullCheck(String string) {
        this.nullCheck = StringUtil.csv2Array((String)this.getRequestParameter(string));
        if (this.nullCheck.length == 0) {
            this.nullCheck = null;
        } else {
            Arrays.sort(this.nullCheck);
        }
    }

    public void setMustAnyCheck(String string) {
        this.mustAnyCheck = StringUtil.csv2Array((String)this.getRequestParameter(string));
        if (this.mustAnyCheck.length == 0) {
            this.mustAnyCheck = null;
        } else {
            Arrays.sort(this.mustAnyCheck);
        }
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() > 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setCheckType(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() > 0) {
            this.checkType = string2;
        }
    }

    public void setMaxRowCount(String string) {
        this.maxRowCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.maxRowCount);
    }

    public void setMinRowCount(String string) {
        this.minRowCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.minRowCount);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setMatchKeys(String string) {
        this.matchKeys = this.getCSVParameter(string);
        if (this.matchVals != null && this.matchKeys.length != this.matchVals.length) {
            String string2 = "matchKeys\u5c5e\u6027\u3068matchVals\u5c5e\u6027\u306e\u500b\u6570\u304c\u5408\u3044\u307e\u305b\u3093\u3002" + CR + " matchKeys=[" + this.matchKeys.length + "]:KEYS=" + StringUtil.array2csv((String[])this.matchKeys) + CR + " matchVals=[" + this.matchVals.length + "]:VLAS=" + StringUtil.array2csv((String[])this.matchVals) + CR;
            throw new HybsSystemException(string2);
        }
    }

    public void setMatchVals(String string) {
        this.matchVals = this.getCSVParameter(string);
        if (this.matchKeys != null && this.matchKeys.length != this.matchVals.length) {
            String string2 = "matchKeys\u5c5e\u6027\u3068matchVals\u5c5e\u6027\u306e\u500b\u6570\u304c\u5408\u3044\u307e\u305b\u3093\u3002" + CR + " matchKeys=[" + this.matchKeys.length + "]:KEYS=" + StringUtil.array2csv((String[])this.matchKeys) + CR + " matchVals=[" + this.matchVals.length + "]:VLAS=" + StringUtil.array2csv((String[])this.matchVals) + CR;
            throw new HybsSystemException(string2);
        }
    }

    public void setRealTime(String string) {
        this.isRealTime = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isRealTime);
    }

    public void setUseStrict(String string) {
        this.isStrict = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isStrict);
    }

    public void setUseColumnLabel(String string) {
        this.isColumnLabel = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isColumnLabel);
    }

    public void setCheckNames(String string) {
        this.checkNames = StringUtil.deleteWhitespace((String)StringUtil.nval((String)this.getRequestParameter(string), (String)this.checkNames));
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("tableId", (Object)this.tableId).println("command", (Object)this.command).println("columns", (Object[])this.columns).println("nullCheck", (Object[])this.nullCheck).println("mustAnyCheck", (Object[])this.mustAnyCheck).println("maxRowCount", (Object)this.maxRowCount).println("minRowCount", (Object)this.minRowCount).println("checkType", (Object)this.checkType).println("matchKeys", (Object[])this.matchKeys).println("matchVals", (Object[])this.matchVals).println("realTime", (Object)this.isRealTime).println("bodyString", (Object)StringUtil.htmlFilter((String)this.bodyString)).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

