/*************************************************************************
 * Gantt Related Routine : Resize and Move
 * 2007/01/09 IE7対応
 * 2009/06/24 Applied to Firefox
 * Revision: $Id: gantt.js,v 1.4 2009/06/29 10:46:56 C21044 Exp $
 *************************************************************************/

var _sCompat_ = document.compatMode;
// var bIsBackCompat = ( "BackCompat" == _sCompat_ );
var bIsCSS1Compat = ( "CSS1Compat" == _sCompat_ );

var cnTabDivSpan     = 2 ;
var cnWidthScroll    = 16;
var cnTabRBodyMargin = 10;  //Extra margin space on the right  of body
var cnTabBBodyMargin =  5;  //Extra margin space on the bottom of body
var __bInResizing    = false;

/* Parameter: evt    - compatible with firefox.(IE:event;FF:e)
 *            iSBits - vertical scroll set.(X1:H->8,V->4;X2:H->2,V->1)
 */
function ganttResize(evt, iSBits) {
	var GBdiv = document.getElementById("GantBody");	// Id applied to table of the entire Gant
	var X1div = document.getElementById("X1");			// Id applied to div in left, fixed part
	var X2div = document.getElementById("X2");			// Id applied to div of right moving part

	if( GBdiv == null || X1div == null || X2div == null ) { return; }

	var x1Tabs = X1div.getElementsByTagName("TABLE");
	var x2Tabs = X2div.getElementsByTagName("TABLE");

	if( x1Tabs.length == 0 || x2Tabs.length == 0 ) { return; }
	x1Tabs = x1Tabs[0]; x2Tabs = x2Tabs[0];

	if(__bInResizing) { return false; }
	__bInResizing = true;

	var iScrollBits = iSBits || 0x1;
	var bX1VScroll = iScrollBits & 0x4;
//	var bX2VScroll = iScrollBits & 0x1;
	var nX1VSWidths = (bX1VScroll ? cnWidthScroll : 0);
//	var nX2VSWidths = (bX2VScroll ? cnWidthScroll : 0);

	//var tblHeight = x2Tabs.offsetHeight + cnTabDivSpan;

	// The height of coming div whose height of the table is larger than the height of div is adjusted.
	//if( tblHeight < X2div.offsetHeight ) {
	//	  X1div.style.height   = tblHeight;
	//	  X2div.style.height   = tblHeight + cnWidthScroll;
	//}

	// It is adjusted to the width of the left end fixation item.
//	  var X0Width  = document.body.clientWidth; 		  // Width of frame to which Gant is displayed
//	  var X0Height = document.body.clientHeight;		  // Height of frame to which Gant is displayed
	var X0Width  = getClientWidth();
	var X0Height = getClientHeight();
	var GBTabHeight = X0Height - (GBdiv.offsetTop + cnTabBBodyMargin);
//	var X1Width = x1Tabs.offsetWidth + 2;	// Room is given between a fixed part and the moving part.
	var X1Width = x1Tabs.offsetWidth + nX1VSWidths + 2;   // Room is given between a fixed part and the moving part.
	var X2Width  = X0Width - X1Width;		// The moving part is displayed in the area of the remainder that displays a fixed part in the whole.

	var nDummy;
	// When Gant cannot be displayed because the frame is too small, it doesn't adjust it.
	if( 20 < GBTabHeight && 20 < X1Width && 20 < X2Width ) {
		//X1div.style.width  = X1Width; 					  // Width of fixed part
		var nNoShow = x1Tabs.offsetTop;
		nDummy = x1Tabs.offsetHeight;
		if((nDummy + 2 * cnTabDivSpan + nNoShow) < (GBTabHeight - cnWidthScroll)){
			X1div.style.height = nDummy + 2 * cnTabDivSpan + nNoShow + "px";	 // Height of fixed part(amount of low of scroll bar)
		}
		else{
			X1div.style.height = GBTabHeight - cnWidthScroll + "px";	 // Height of fixed part(amount of low of scroll bar)
		}
		X2div.style.width  = X2Width  - cnTabRBodyMargin + "px";	 // It is some room at the right of width of the moving part.
		nDummy = x2Tabs.offsetHeight;
		if((nDummy + 2 * cnTabDivSpan + nNoShow) < (GBTabHeight - cnWidthScroll)){
			X2div.style.height = nDummy + 2 * cnTabDivSpan + cnWidthScroll + nNoShow + "px";	 // Height of moving part
		}
		else{
			X2div.style.height = GBTabHeight + "px";								   // Height of moving part
		}

		// 横スクロールバーがない場合の調整 5.9.0.1 (2015/09/11)
		if( X2div.clientWidth == X2div.scrollWidth ){
			X1div.style.height = X1div.offsetHeight + cnWidthScroll + "px";
		}
	}

	__bInResizing = false;
	
	$('.breaktime').height($('#divHlr').height()-$('#divHlr th').height()-6); // 2011/12/26  rush job...
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ++ HYBS's heightAdjust is divided into tow parts(2005/12/12):  ++
// ++      1.heightReset and 2.ganttResize                        ++
// ++      5.9.0.1 (2015/09/11) IE9以降に対応                     ++
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function heightReset(evt) { 
//	var GBdiv = document.getElementById("GantBody");	// Id applied to table of the entire Gant
	var X1div = document.getElementById("X1");			// Id applied to div in left, fixed part
	var X2div = document.getElementById("X2");			// Id applied to div of right moving part

	if( X1div == null || X2div == null ) { return; }

	var x1Tabs = X1div.getElementsByTagName("TABLE");
	var x2Tabs = X2div.getElementsByTagName("TABLE");

	if( x1Tabs.length == 0 || x2Tabs.length == 0 ) { return; }
	x1Tabs = x1Tabs[0]; x2Tabs = x2Tabs[0];

	var x1Rows = x1Tabs.rows, x2Rows = x2Tabs.rows;
	var heiTemp = 0, nRowTest = 0, nTotalRow = x1Rows.length;
	var wkHeight1, wkHeight2, nFHeight1 =0, nFHeight2 = 0;
	var defaultView = document.defaultView; 
	var bDefView = (defaultView ? true :false);
	// The height of the cell is matched to the maximum value of the data of the head five lines.
	var i;
	for( i=0; i < nTotalRow; i++){
		if(bDefView) {
			// Firefoxにautoが取れないため（取れるかな？）、取れたheightの属性に小数点があるかどうかを使って判断する。姑息なやり方
			//defaultView.getComputedStyle(x1Rows[i], null).getPropertyCSSValue("height").cssValueType
			//defaultView.getComputedStyle(x1Rows[i], null).getPropertyCSSValue("height").primitiveType
			//defaultView.getComputedStyle(x1Rows[i], null).getPropertyCSSValue("height").getFloatValue(5)
			// IE9以降で上手く動作しないのでこの判定はやめる。 5.9.0.1 (2015/09/11)
			// chrome等ではautoかどうかを取得する方法が不明なため、判定はしないこととする。
//			if(defaultView.getComputedStyle(x1Rows[i], null).getPropertyValue("height").indexOf(".") < 0) { continue; }
//			if( $(x1Rows[i]).css('height') != "auto" ){ continue; }
		
//			nFHeight1 = defaultView.getComputedStyle(x1Rows[i], null).getPropertyValue("height");
//			nFHeight2 = defaultView.getComputedStyle(x2Rows[i], null).getPropertyValue("height");

			// 下のやり方を一つ選んで、行ける？
			//wkHeight1 = Math.max(x1Rows[i].offsetHeight, Math.ceil(parseFloat(nFHeight1)));
			//wkHeight2 = Math.max(x2Rows[i].offsetHeight, Math.ceil(parseFloat(nFHeight2)));
			//wkHeight1 = Math.ceil(parseFloat(nFHeight1));
			//wkHeight2 = Math.ceil(parseFloat(nFHeight2));
			// 変更(0.5は足さないとずれるので足しておく)
			wkHeight1 = $(x1Rows[i]).height() + 0.5;
			wkHeight2 = $(x2Rows[i]).height() + 0.5;
		}
		else {
			if( x1Rows[i].currentStyle.height != "auto" ) { continue; }  

			wkHeight1 = x1Rows[i].offsetHeight;
			wkHeight2 = x2Rows[i].offsetHeight;
		}

		// One with large data is adopted.
		if( heiTemp < wkHeight1 ) { heiTemp = wkHeight1 ;}
		if( heiTemp < wkHeight2 ) { heiTemp = wkHeight2 ;}

		// 最大5行を入れて、行の高さを確認する
		nRowTest++;
		if(nRowTest >= 5) { break; }
	}

	// The height of the cell is matched to the maximum value data.
	if(heiTemp > 0) {
		for( i = 0; i < nTotalRow; i++){
			if(bDefView) {
			// とりあえず適用してしまうように変更 5.9.0.1 (2015/09/11)
//				if(defaultView.getComputedStyle(x1Rows[i], null).getPropertyValue("height").indexOf(".") != 0) { continue; }
//				if( $(x1Rows[i]).css('height') != "auto" ){ continue; }
			}
			else {
				if( x1Rows[i].currentStyle.height != "auto" ) { continue; }  
			}

			x1Rows[i].style.height = heiTemp + "px" ;
			x2Rows[i].style.height = heiTemp + "px" ;
		}
	}
}

function getClientHeight() {
	var nClientHeight = 0;
	if( bIsCSS1Compat ) {
		nClientHeight =document.documentElement.clientHeight;
	}
	else {
		nClientHeight =document.body.clientHeight;
	}

	return nClientHeight;
}

function getClientWidth() {
	var nClientWidth = 0;
	if( bIsCSS1Compat ) {
		nClientWidth =document.documentElement.clientWidth;
	}
	else {
		nClientWidth =document.body.clientWidth;
	}

	return nClientWidth;
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ++ Patch Added to the HYBS's time-scale gantt                  ++
// ++ 2007/02/13 ADD                                              ++
// ++ 2015/09/04 5.9.0.0  all.tags対応                            ++
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function breakAdjust() {
//	var GBdiv = document.getElementById("GantBody");	// Id applied to table of the entire Gant
	var X1div = document.getElementById("X1");			// Id applied to div in left, fixed part
	var X2div = document.getElementById("X2");			// Id applied to div of right moving part

	if( X1div == null || X2div == null ) { return; }

	// 5.9.0.0 (2015/09/04) HTML5対応
//	var x1Tabs = X1div.all.tags("TABLE")[0];
//	var x2Tabs = X2div.all.tags("TABLE")[0];
	var x1Tabs = $(X1div).find("TABLE")[0];
	var x2Tabs = $(X2div).find("TABLE")[0];

	if( x1Tabs == null || x2Tabs == null ) { return; }

	// 5.9.0.0 (2015/09/04)
//	var aAllSpan = x2Tabs.all.tags("SPAN");
	var aAllSpan = $(x2Tabs).find("SPAN");

	var sX2Pos = X2div.style.position;
	var bX2PosMark = sX2Pos && (sX2Pos == "absolute" || sX2Pos == "relative");
	var oPosParent = (bX2PosMark ? X2div : x2Tabs);

	var nMaxHeight = x2Tabs.offsetHeight;
	var oneSpan, nOneTop;
	for( var nIndexUp = 0; nIndexUp < aAllSpan.length; nIndexUp++) {
		oneSpan = aAllSpan[nIndexUp];
		if("500000px" == oneSpan.currentStyle.height) {
			nOneTop = 0;
			var oMyTabParent = oneSpan;
			while (oMyTabParent != oPosParent) {
				nOneTop += oMyTabParent.offsetTop;
				oMyTabParent = (bX2PosMark ? oMyTabParent.offsetParent : oMyTabParent.parentNode);
			}
			oneSpan.style.pixelHeight = nMaxHeight - nOneTop;
		}
	}
}

//scrollGannt.js


	// Turn on 2D positioning
	//document.execCommand("2D-position",false,true);
	//The last two values of the following array of acnViewSpan for other gantts
//	var acnViewSpan = [48,24,12,8,4,3,2,1,0.5,0.33,1,25];
//	var acnViewSpan = [48,24,12,8,4,3,2,1,0.5,0.33,3.43,25,33,0,0,0,0,0,0,0,12,12];
	var acnViewSpan = [48,24,12,8,4,3,2,1,0.5,0.33,3.43,25,33,0,0,0,0,0,0,0,48,24,24,12,12,6,8,4,6,3,48,24];
    var acnNotchMag = [1 ,1 ,1 ,1,1,1,1,1,1  ,1   ,1   ,1 ,1 ,1,1,1,1,1,1,1,1 ,1 ,1 ,2 ,1 ,1,1,1,1,1,1,1 ];
    var cnFDTick    = 86400;
    var acnDSecSpan = [ cnFDTick   ,cnFDTick   ,cnFDTick   ,cnFDTick   ,cnFDTick   ,cnFDTick   ,cnFDTick   ,cnFDTick   ,cnFDTick   ,cnFDTick  
                       ,cnFDTick   ,cnFDTick   ,cnFDTick   ,cnFDTick   ,cnFDTick   ,cnFDTick   ,cnFDTick   ,cnFDTick   ,cnFDTick   ,cnFDTick  
                       ,cnFDTick/4 ,cnFDTick/4 ,cnFDTick/4 ,cnFDTick/24,cnFDTick/4 ,cnFDTick/4 ,cnFDTick/4 ,cnFDTick/4 ,cnFDTick/4 ,cnFDTick/4
                       ,cnFDTick/2 ,cnFDTick/2 ];
	var cnViewUnknown = -1;
	var nViewIndex    = cnViewUnknown;
	var cnBunkatu = 3;

	// Mouse Action
	var cnMNone    = 0;
	var cnMLeft    = 1;
	var cnMMiddle  = 2;
	var cnMRight   = 3;
	var nLeftRightLimit = 2;		// sayu no tukamishiro no saishou-chi
	var nMAction;

	// Gantt Type
	var cnGanttUnknown = -1;
	var cnGanttBlock   =  0;        //GANTTBLOCK
	var cnGanttStone   =  1;        //MILESTONE
	var cnGanttKaku    =  2;        //KAKUTEI
	var nGanttType;

	var nOldMX, nOldMY ;
	var oBlockHilight = null;
	var oGanttSlider  = null;
	var csIdGanttInfo = "GanttSlider";
	// Attribute Lising
	var ganttAttrs = {beginInput:"beginInput", endInput:"endInput", moveable:"moveable", chboxid:"chboxid",ganttType:"ganttType",
						view:"view", beginDate:"beginDate", endDate:"endDate"};

	// YYYYMMDD[HH24MISS] String to Date Object
	function s2d(s, tm) {
        s += (tm || "") + "000000";
	    return (new Date(parseInt(s.substr(0,4),10), parseInt(s.substr(4,2),10)-1, parseInt(s.substr(6,2),10),
                         parseInt(s.substr(8,2),10), parseInt(s.substr(10,2),10) , parseInt(s.substr(12,2),10)));
	}

	// Date Object to YYYYMMDD[HH24MIDD] String
	function d2s(d, nLen) {
		var sAdd = "00" ;
        nLen = nLen || 8;
		return ( d.getFullYear().toString()
			   + (sAdd + (d.getMonth() + 1).toString()).slice(-2)
			   + (sAdd + d.getDate().toString()).slice(-2) 
			   + (sAdd + d.getHours().toString()).slice(-2) 
			   + (sAdd + d.getMinutes().toString()).slice(-2) 
			   + (sAdd + d.getSeconds().toString()).slice(-2) ).substr(0, nLen);
	}

	// Gantt Type Change
	function getGanttType(oMyGantt) {
		var sGanttType = oMyGantt.getAttribute(ganttAttrs.ganttType,1);
		//return ((oMyGantt.ganttType) ? parseInt(oMyGantt.ganttType, 10) : cnGanttBlock);
		return ((sGanttType) ? parseInt(sGanttType, 10) : cnGanttBlock);
	}

	function getGanttSlider(oMyGantt) {
		var oFindMe = null ; // oParent = oMyGantt;

		oFindMe = document.getElementById(csIdGanttInfo) ;
		return oFindMe;
	}

    function hms2st(sTm) {
        sTm += "000000";
        return parseInt(sTm.substr(0,2),10)*3600 + parseInt(sTm.substr(2,2),10)*60 + parseInt(sTm.substr(4,2),10);
    }

    function getGanttInfo(oGSlider) {
        var oGInfo = new Object();

        var nViewIndex = parseInt(oGSlider.getAttribute(ganttAttrs.view,1), 10);
        oGInfo.nVIndex = nViewIndex;

        if(acnDSecSpan[nViewIndex] >= cnFDTick) {
            oGInfo.nDateLen  = 8;
            oGInfo.nLowNick  = 0;
            oGInfo.nHighNick = cnFDTick;
            oGInfo.nDSTicks  = cnFDTick;
        }
        else {
            var sDaySpan = (oGSlider.daySpan || "0700-2000");
            var nHyphenPos = sDaySpan.indexOf("-");

            oGInfo.nDateLen  = 8 + nHyphenPos;
            oGInfo.nLowNick  = hms2st(sDaySpan.substr(0,nHyphenPos));
            oGInfo.nHighNick = hms2st(sDaySpan.substr(nHyphenPos+1));
            //In case of 24hrs
            if(oGInfo.nLowNick >= oGInfo.nHighNick) oGInfo.nHighNick += cnFDTick;
            oGInfo.nDSTicks  = Math.ceil((oGInfo.nHighNick - oGInfo.nLowNick)/(acnDSecSpan[nViewIndex] * acnNotchMag[nViewIndex]))
                             * acnDSecSpan[nViewIndex] * acnNotchMag[nViewIndex];
        }

		var dBegin = s2d(oGSlider.getAttribute(ganttAttrs.beginDate,1));
        oGInfo.dBegin = new Date(dBegin.getFullYear(), dBegin.getMonth(), dBegin.getDate(), 0, 0, oGInfo.nLowNick);

        return oGInfo;
    }

    //Change pixel span to second span
    function ps2ss(nGView, nDVTicks, nPxSpan, nAddS) {
        nAddS = (nAddS || 0);
        var nMoveSec = Math.round(nPxSpan / acnViewSpan[nGView]) * acnDSecSpan[nGView] + nAddS;
        var nMoveDay = Math.floor(nMoveSec / nDVTicks);
        return (nMoveDay * cnFDTick + nMoveSec - nMoveDay * nDVTicks);
    }

	function performDateChange(nMyGType, nMyMAction, nMyVIndex, oMyGanttBlock) {
		var nWidth, nLeft;
        var oGInfo = oGanttSlider.oGanttInfo;
	//	var dBegin = s2d(oGanttSlider.beginDate);
		var dBegin = oGInfo.dBegin;
        var nDateLen = oGInfo.nDateLen;
        var nDSTicks = oGInfo.nDSTicks;
		var oBlockInfo = getCurrentInfo(nMyGType, nMyMAction, nMyVIndex, oMyGanttBlock);

		nLeft  = oBlockInfo.left  ;
		nWidth = oBlockInfo.width ;

		var dDummy;
		switch (nGanttType) {
			case cnGanttBlock :
			//	dDummy = new Date(dBegin.getYear(), dBegin.getMonth(), dBegin.getDate());
				dDummy = new Date(dBegin.getTime());
			//	dDummy.setDate(dDummy.getDate() + Math.round(nLeft/acnViewSpan[nMyVIndex]));
				dDummy.setSeconds(dDummy.getSeconds() + ps2ss(nMyVIndex, nDSTicks, nLeft));
				// Set begin date value of the specified Input fields or Div fields
				setInputFields( oMyGanttBlock.getAttribute(ganttAttrs.beginInput,1), d2s(dDummy, nDateLen));
				// Set End date value of the specified Input fields or Div fields
			//	dDummy = new Date(dBegin.getYear(), dBegin.getMonth(), dBegin.getDate());
				dDummy = new Date(dBegin.getTime());
				dDummy.setSeconds(dDummy.getSeconds() + ps2ss(nMyVIndex, nDSTicks, (nLeft+nWidth), -1));
				setInputFields( oMyGanttBlock.getAttribute(ganttAttrs.endInput,1)  , d2s(dDummy, nDateLen));
				break;

			case cnGanttStone :
			//	dDummy = new Date(dBegin.getYear(), dBegin.getMonth(), dBegin.getDate());
				dDummy = new Date(dBegin.getTime());
			//	dDummy.setDate(dDummy.getDate() + Math.floor((nLeft + (nWidth>>>2))/acnViewSpan[nMyVIndex]));
				dDummy.setSeconds(dDummy.getSeconds() + ps2ss(nMyVIndex, nDSTicks, (nLeft + (nWidth>>>2)) ));
				// Set begin date value of the specified Input fields or Div fields
				setInputFields( oMyGanttBlock.getAttribute(ganttAttrs.beginInput,1), d2s(dDummy, nDateLen));
				setInputFields( oMyGanttBlock.getAttribute(ganttAttrs.endInput,1)  , d2s(dDummy, nDateLen));
				break;

			default: break;
		}

		//Check Row
		var sChboxId = oMyGanttBlock.getAttribute(ganttAttrs.chboxid,1);
		//if(oMyGanttBlock.chboxid && ( "" != oMyGanttBlock.chboxid)) {
		//	setRowChecked(null, oMyGanttBlock.chboxid);
		if(sChboxId && ( "" != sChboxId)) {
			setRowChecked(null, sChboxId);
		}
	}

	function setInputFields(sName, sValue) {


		var nIndexUp;
		var aInputs=document.getElementsByName(sName);
		if(null != aInputs) {

			for(nIndexUp = 0; nIndexUp < aInputs.length;  nIndexUp++ ) {

				var oSetObj  = aInputs[nIndexUp];
				var sTagName = oSetObj.tagName;
				if("INPUT" == sTagName ) {
					oSetObj.value = sValue;
				}
				else if(("DIV" == sTagName) || ("SPAN" == sTagName)) {
					oSetObj.innerHTML = sValue;
				}
			}
		}
	}

	function getSerialIndex(oCheck, strMark) {

		var nSerial = oCheck.name.indexOf( strMark );
		if(nSerial >= 0) {
			nSerial = parseInt(oCheck.name.substr(nSerial + strMark.length), 10);
		}
		return nSerial;
	}

	function setRowSelected2(oMySelf) {

		var csColMark = "__";
		var nSeries = getSerialIndex(oMySelf, csColMark);
		if(nSeries >= 0 ) { setRowSelected(oMySelf.form, nSeries); }
	}

	function setRowSelected(oMyForm, sRowSelected) {

		var nIndexUp;
//		var aInputs=document.getElementsByName("h_rowSelected");
		var aInputs=document.getElementsByName("h_rowSel");
		if(null != aInputs) {

			for(nIndexUp = 0; nIndexUp < aInputs.length;  nIndexUp++ ) {

				var oSetObj  = aInputs[nIndexUp];
				if(("INPUT" == oSetObj.tagName )
				&& ( "checkbox" == oSetObj.type )
				&& ( sRowSelected == oSetObj.value)) {

					if(!oSetObj.checked) { oSetObj.checked = true; }
					break;
				}
			}
		}
	}

	function setRowChecked(oMyForm, sName, bValue) {

		var nIndexUp;
		var aInputs=document.getElementsByName(sName);
		if(null != aInputs) {

			for(nIndexUp = 0; nIndexUp < aInputs.length;  nIndexUp++ ) {

				var oSetObj  = aInputs[nIndexUp];
				if(("INPUT" == oSetObj.tagName )
				&& (( "checkbox" == oSetObj.type ) || ( "radio" == oSetObj.type ))) {

					oSetObj.checked = ((undefined == bValue) ? true : bValue);
				}
			}
		}
	}

	function getCurrentInfo(nMyGType, nMyMAction, nMyVIndex, oMyGanttBlock) {
		var nRemainder;
		//var nCurX    = oMyGanttBlock.style.pixelLeft;
		var nCurX    = parseInt(oMyGanttBlock.style.left,10);
		var nMyWidth = oMyGanttBlock.offsetWidth;
		var nHalfBlock = acnViewSpan[nMyVIndex]/2;
		var nNextLeft, nNextWidth;

		nNextLeft  = nCurX;
		nNextWidth = nMyWidth;

		switch (nGanttType) {
			case cnGanttBlock :
				switch (nMyMAction) {
					case cnMLeft :
						nRemainder = (nMyWidth % acnViewSpan[nMyVIndex]);
						if( nRemainder < nHalfBlock ) {
							nNextWidth = nMyWidth - nRemainder;
							nNextLeft  = nCurX + nRemainder;
						}
						else {
							nNextWidth = nMyWidth + (acnViewSpan[nMyVIndex] - nRemainder);
							nNextLeft  = nCurX - (acnViewSpan[nMyVIndex] - nRemainder);
						}

						break;
					case cnMRight:
						nRemainder = (nMyWidth % acnViewSpan[nMyVIndex]);
						if( nRemainder > nHalfBlock ) {
							nNextWidth = nMyWidth + (acnViewSpan[nMyVIndex] - nRemainder);
						}
						else {
							nNextWidth = nMyWidth - nRemainder;
						}
						break;
					case cnMMiddle:
						nRemainder = (nCurX % acnViewSpan[nMyVIndex]);
						if( nRemainder > nHalfBlock ) {
							nNextLeft = nCurX + (acnViewSpan[nMyVIndex] - nRemainder);
						}
						else {
							nNextLeft = nCurX - nRemainder;
						}
						break;
					default: break;
				}
				break;

			case cnGanttStone :
				switch (nMyMAction) {
					case cnMMiddle:
						nNextLeft = Math.floor((nCurX + (nMyWidth>>>2))/acnViewSpan[nMyVIndex])*acnViewSpan[nMyVIndex]
							 + ((acnViewSpan[nMyVIndex] - nMyWidth)>>2);
						break;
					default: break;
				}
				break;

			default: break;
		}

		nNextWidth = Math.max( nNextWidth,cnBunkatu*2 );	// cnBunkatu*2 wo Mim Width to suru.
		return { left:nNextLeft, width:nNextWidth };
	}

	function fnMouseDown(evt) {
		var evnt = ( evt ) ? evt : ( ( window.event ) ? window.event : null );
		//var oMySelf = event.srcElement;
		var oMySelf = (evnt.target || evnt.srcElement);

		//if(oMySelf.beginInput)
		if((1 == (evnt.button || evnt.which)) && oMySelf.getAttribute(ganttAttrs.beginInput,1)) {

			oBlockHilight = oMySelf;
			if( cnGanttKaku != getGanttType(oMySelf)) {

				oGanttSlider    = getGanttSlider(oBlockHilight);
                if(!oGanttSlider.oGanttInfo) oGanttSlider.oGanttInfo = getGanttInfo(oGanttSlider);
			}
		}

		//if .moveable is defined
		//if( oMySelf.moveable && ( "0" == oMySelf.moveable || "false" == oMySelf.moveable.toLowerCase()))
		var sMoveable = oMySelf.getAttribute(ganttAttrs.moveable,1);
		if( sMoveable && ( "0" == sMoveable || "false" == sMoveable.toLowerCase()))
            oBlockHilight = null;

		if( null != oBlockHilight ) {
			oMySelf  = oBlockHilight;
			var nMyWidth = oMySelf.offsetWidth;

			nMAction = cnMNone;
			nGanttType = getGanttType(oMySelf);
		  //nViewIndex = parseInt(oGanttSlider.view, 10);
			nLeftRightLimit = Math.min(Math.max(nMyWidth/cnBunkatu, 2),20);

			//nOldMX = event.screenX;
			//nOldMY = event.screenX;
			nOldMX = evnt.screenX;
			nOldMY = evnt.screenY;
			var nOffsetX = ("undefined" == typeof(evnt.offsetX)) ? evnt.layerX : evnt.offsetX; 

			switch (nGanttType) {
				case cnGanttBlock :
					//if     (event.offsetX <= nLeftRightLimit)
					if     (nOffsetX <= nLeftRightLimit) {
						nMAction = cnMLeft;
						oMySelf.style.cursor = "E-resize";
					}
					//else if( event.offsetX > (nMyWidth - nLeftRightLimit))
					else if(nOffsetX > (nMyWidth - nLeftRightLimit)) {
						nMAction = cnMRight;
						oMySelf.style.cursor = "E-resize";
					}
					else {
						nMAction = cnMMiddle;
						oMySelf.style.cursor = "move";
					}
					break;

				case cnGanttStone :
					nMAction = cnMMiddle;
					oMySelf.style.cursor = "move";
					break;

				default: break;
			}

			// IEの時に使う
			if(oMySelf.setCapture) { oMySelf.setCapture(); }

			// Firefoxの固有のドラッグとドロップ機能を無効に
			if(evnt.preventDefault) { evnt.preventDefault(); }
		}
	}

	function fnMouseUp(evt) {
		if( null != oBlockHilight ) {
			//var oMySelf = GanttBlock1
			var oMySelf = oBlockHilight;
			oMySelf.style.cursor = "auto";
			// IEの時に使う
			if(oMySelf.releaseCapture) { oMySelf.releaseCapture(); }

			var nViewIndex = oGanttSlider.oGanttInfo.nVIndex;
			var oBlockInfo = getCurrentInfo(nGanttType, nMAction, nViewIndex, oMySelf);

			oMySelf.style.width = oBlockInfo.width + "px";
			oMySelf.style.left  = oBlockInfo.left + "px";

			nMAction      = cnMNone;
			nGanttType    = cnGanttUnknown;
			oBlockHilight = null;
			oGanttSlider  = null;
		}
	}

	function fnTrackMouse(evt) {

		var evnt = ( evt ) ? evt : ( ( window.event ) ? window.event : null );

		//Left button is pressed.
		//if(( 1 == event.button ) && ( null != oBlockHilight ))
		// Firefoxのmousemoveにevnt.whichが取れなさそうなので、mousedownに移動
		if( null != oBlockHilight ) {

			var nNowMX, nNowMY;
			var nCurX, nIncX;
			//nNowMX = event.screenX;
			//nNowMY = event.screenX;
			nNowMX = evnt.screenX;
			nNowMY = evnt.screenY;
			//var oMySelf = GanttBlock1
			var oMySelf = oBlockHilight;

            var nViewIndex = oGanttSlider.oGanttInfo.nVIndex;

			var nMaxHRange = 0;
			var nMyWidth   = oMySelf.offsetWidth;
			//var nMyLeft    = oMySelf.style.pixelLeft
			var nMyLeft    = parseInt(oMySelf.style.left,10);
			var oParent = oMySelf;
			while(true) {
				nMaxHRange = oParent.parentNode.clientWidth;
				if( 0 != nMaxHRange ) break;

				oParent = oParent.parentNode;
			}

			switch (nGanttType) {
				case cnGanttBlock :
					switch (nMAction) {
						case cnMLeft :
							nIncX = -(nNowMX - nOldMX);
							nCurX = nMyLeft + (nNowMX - nOldMX);
							if( nCurX < 0) {
								nCurX = 0;
								nMyWidth = nMyLeft + nMyWidth;
							}
							else if( acnViewSpan[nViewIndex] > (nMyWidth + nIncX) ) {
								nCurX = nMyLeft + nMyWidth - acnViewSpan[nViewIndex];
								nMyWidth = acnViewSpan[nViewIndex];
							}
							else {
								nMyWidth += nIncX;
							}
							oMySelf.style.left  = nCurX + "px";
							oMySelf.style.width = nMyWidth + "px";

							break;
						case cnMRight:
							nIncX = (nNowMX - nOldMX);
							if((nMyWidth + nIncX) < acnViewSpan[nViewIndex] ) {
								nMyWidth = acnViewSpan[nViewIndex];
							}
							else if ((nMyLeft + nMyWidth + nIncX) > nMaxHRange ) {
								nMyWidth = nMaxHRange - nMyLeft;
							}
							else {
								nMyWidth = nMyWidth + nIncX;
							}

							oMySelf.style.width = nMyWidth + "px";
							break;
						case cnMMiddle:
							nIncX = (nNowMX - nOldMX);
							nCurX = nMyLeft + (nNowMX - nOldMX);
							if( nCurX < 0) { nCurX = 0; }
							if( ( nCurX  + nMyWidth ) >= nMaxHRange) {
								nCurX = nMaxHRange - nMyWidth;
							}
							oMySelf.style.left = nCurX + "px";

							break;
						default: break;
					}
					break;

				case cnGanttStone :
					switch (nMAction) {
						case cnMMiddle:
							nIncX = (nNowMX - nOldMX);
							nCurX = nMyLeft + (nNowMX - nOldMX);
							if( nCurX < 0) { nCurX = 0; }
							if( ( nCurX  + nMyWidth ) >= nMaxHRange) {
								nCurX = nMaxHRange - nMyWidth;
							}
							oMySelf.style.left = nCurX + "px";
							break;
						default: break;
					}
					break;

				default: break;
			}

			nOldMX = nNowMX;
			nOldMY = nNowMY;

			//oMySelf.scrollIntoView(false);
			// Change the date
			performDateChange(nGanttType, nMAction, nViewIndex, oMySelf);
		}
	}
